package miiee.python;

import miiee.util.*;
import miiee.client.*;
import miiee.xml.*;
import org.python.core.*;
import javax.swing.tree.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
import miiee.mml.MMLException;

//---- SPyMethods ---------------------------------------------------------

class UpdateTimeAction extends QueuedExecutable  {
  SMEClient _client;
  float _time;
  UpdateTimeAction( SMEClient c, float time ) { _client = c; _time = time; }
  public void execute() {
	SPyInterface.setTime(_time);
  }
}

class RunAction extends QueuedExecutable  {
  SMEClient _client;
  float _stop_time;
  RunAction( SMEClient c, float stop_time ) { _client = c; _stop_time = stop_time; }
  public void execute() {
	while ( ( SPyMethods.getTime() < _stop_time ) && SPyMethods.run_on() ) { 
	  SPyMethods.step();  
	}
  }
}

public class SPyMethods  {

  static SMEClient _client;
  static ConfigurationPanel _configPanel;
  static boolean _debug = true;
  static float _time = 0f;
  static boolean _go = true;
  static boolean _sim_open = false;
  protected static ExternalClassStub _visad_interface;
  protected static Hashtable _code = new Hashtable(); 
   
  public SPyMethods() { ; }
	
  public static void setClient( SMEClient client ) { _client = client; }
  public static float getTime() { return _time; }
  
  public static String run( float stop_time ) { 
	System.out.println( "Running simulation to time " + stop_time );
	_go = true;
	RunAction ra = new RunAction( _client, stop_time );
	ra.actionPerformed(null);
	return "Runing Simulation to time " + Float.toString(stop_time) + "; use halt() to stop.";
  }
  
   public static void halt() { _go = false; }
   public static boolean run_on() { return _go; }
   public static SMEClient getClient() { return _client; }
   public static void dep() { SPyInterface.addDependencies(); }

   public static void conf() {   
		_configPanel = ConfigurationPanel.getPanel( _client.getInterface() );
		JFrame frame = new JFrame("Model Configuration");
		frame.getContentPane().add(_configPanel);
		frame.setSize(500, 600);
		frame.setVisible(true);
   }
 	public  static ExternalClassStub  getVisADInterface() throws MMLException {
	  if( _visad_interface == null ) {
		_visad_interface = new ExternalClassStub("miiee.visad.stub_interface");
		_visad_interface.addMethod("3dViewer", "create3dViewer( java.util.Vector )" );
		_visad_interface.addMethod("python", "createPythonEditor( java.lang.String )" );
	  } 
	  return _visad_interface;
	}

	public static PyObject getCode( String key ) {
	  return (PyObject) _code.get(key);
	}
	public static void putCode( String key, PyObject code ) {
	  _code.put(key,code);
	}
   
   public static String getLocalNameSpace() { return SPyInterface.getLocalNameSpace(); }
   public static String loc() { return getLocalNameSpace(); }
    
  public static String step( ) { 
	if( _client == null ) {  SimIO.print("Must start up a simulation."); }
	try {
	  open();
	  _client.sme_step(); 
	  _time =  _client.sme_current_time();
	  UpdateTimeAction timeUpdate = new UpdateTimeAction(_client,_time);
	  timeUpdate.executeOnEventDispatchTread();
	  String label = "timestep " + Float.toString(_time);
	  _client.retrieve_messages( label );
	  SPyInterface.selectTab( SPyInterface.kShellTab, false );
	  return "Simulation Step: " + label;
	}  catch( SNPException err ) { return processException( err ); }
  }
  
  public static void restart( ) { 
	if( _client == null ) {  SimIO.print("Must start up a simulation."); }
	try {
	  _client.sme_restart();  
	}  catch( SNPException err ) { processException( err ); }
  }
  
  public static void read( String filename ) {
	try {
	  ExternalClassStub  visad = getVisADInterface();
	  JFrame frame = (JFrame) visad.execMethod("python", new Object[] { filename }  );
	  if( frame != null ) {
		frame.setVisible(true);
	  }
 	} catch( MMLException err ) { processException( err ); }
 }

   public static void read() { read( null ); }

  public static void save( String filename ) {
	try {
	  SPyInterface.saveFile(filename);
 	} catch( IOException err ) { processException( err ); }
  }

   public static void save() { save( null ); }
 
  public static void open( ) { 
	if( _client == null ) {  SimIO.print("Must start up a simulation."); }
	try {
	  if( _sim_open ) return;
	  _client.sme_open(); 
	  _client.initialize( true );
	  SPyInterface.setViewserver( _client.getViewserver() );
	  _sim_open = true;
	} catch( SNPException err ) { processException( err ); }
  }
  public static void shutdown( boolean closeWindow ) { _client.shutdown( closeWindow ); }
  
  public void display( String mod, String var ) { 
	if( _client == null ) {  SimIO.print("Must start up a simulation."); }
	try {
	  _client.sme_var_display_data( mod, var );
	} catch( SNPException err ) { processException( err ); }
  }
  
  public static String processException( Exception err ) {
	  if( _debug ) { err.printStackTrace(); }
	  return "Driver exception: " + err.getMessage(); 
  }
  
  public static SPyObject choose() {
	  Object choice = SPyInterface.getSelectedComponent(true); 
	  SPyInterface.write("Choose: " + choice.toString() + "\n" );
	  return (choice == null ) ? null : new SPyObject( choice, _client ); 
  }

  public static SPyObject choose( String id ) {
	  Object choice = SPyInterface.getSelectedComponent(true); 
	  SPyInterface.write("Choose: " + choice.toString() + "\n" );
	  SPyObject rv = (choice == null ) ? null : new SPyObject( choice, _client ); 
	  if( rv != null ) rv.setID(id);
	  return rv;
  }

  public static String view() { 
	Object c = SPyInterface.getSelectedComponent(false);
	if( c == null ) {
	  SimIO.beep(); 
	  return "No selected component";
	}
	SPyObject po = new SPyObject( c, _client );
	return po.view();
  }

  public static String eqn() { 
	Object c = SPyInterface.getSelectedComponent(false);
	if( c == null ) {
	  SimIO.beep(); 
	  return "No selected component";
	}
	SPyObject po = new SPyObject( c, _client );
	return po.eqn();
  }

  public static void exec( PyObject code ) { 
	SPyInterface.exec(code);
  }

  public static String display() { 
	Object c = SPyInterface.getSelectedComponent(false);
	if( c == null ) {
	  SimIO.beep(); 
	  return "No selected component";
	}
	SPyObject po = new SPyObject( c, _client );
	return po.display();
  }

  public static String conf( String cmd ) { 
	Object c = SPyInterface.getSelectedComponent(false);
	if( c == null ) {
	  SimIO.beep(); 
	  return "No selected component";
	}
	SPyObject po = new SPyObject( c, _client );
	return po.config(cmd);
  }

/*

  public static void dlist( ) { 
	if( _client == null ) {  SimIO.print("Must start up a simulation."); }
	try {
	  JTree dtree = DataSet.getTree();
	  TreeModel tm = dtree.getModel();
	  XMLContainer root = (XMLContainer) tm.getRoot();
	  SPyInterface.setRootSelectionNode( root );
	  SimIO.print("Set root selection node, nChildren= " + root.getChildCount() );
	}  catch( Exception err ) { processException( err ); }
  }
  
  public static void vlist( ) { 
	if( _client == null ) {  SimIO.print("Must start up a simulation."); }
	try {
	  JTree vtree = _client.getVariableTree();
	  TreeModel tm = vtree.getModel();
	  XMLContainer root = (XMLContainer) tm.getRoot();
	  SPyInterface.setRootSelectionNode( root );
	  SimIO.print("Set root selection node, nChildren= " + root.getChildCount() );
	}  catch( Exception err ) { processException( err ); }
  } 
*/

}

