package miiee.python;

import miiee.util.*;
import java.util.Vector;
import java.util.Iterator;
import java.util.ListIterator;
import miiee.client.*;
import miiee.xml.*;
import miiee.mml.ConfigurationHandler;
import org.python.core.*;
import miiee.mml.MMLException;

//---- newclass ---------------------------------------------------------


public class SPyObject extends PyObject  {

	Object _object;
	SMEClient _client;
	Vector _cmds = new Vector(); 
	Vector _vbuff = new Vector(); 
	DataSet _ds;
	DataEntry _de;
	StringBuffer _sbuff = new StringBuffer();
	String[] _names = new String[2];
	String[] _result = new String[2];
	private static boolean _debug = true;
	static Vector _local_dataSets = new Vector();
	String _id;
		
	public SPyObject( Object o, SMEClient c ) { _object = o; _client = c; _id = o.toString(); }
	public SPyObject( DataEntry de, SMEClient c ) { _de = de; _client = c;  _id = de.toString(); }

	int getMMLNames() { return getMMLNames(_object); }
	public void setID( String id ) { _id = id; }
	public String ID() { return _id; }
	
	int getMMLNames( Object o ) {
	  if( ( o == null ) && ( _de != null ) ) { 
		_names[0] =  _de.toString(); 
		return ConfigurationHandler.kVariableL;
	  }
	  if( o== null ) return -1;
	  try {
		ConfigurableObject co = (ConfigurableObject)o;
		return co.getQualifiedName( _names );
	  } catch( ClassCastException err ) {
		try {
		  XMLContainer xo = (XMLContainer)_object;
		  _names[0] = "SPyMethods";
		  return ConfigurationHandler.kModelL;
		} catch( ClassCastException err1 ) {
		  return -1;
		}
	  }
	}
	
	public SPyGrid grid() {
	  if( _ds != null ) return new SPyGrid(_ds);
	  DataEntry de = getActiveDataEntry( true );
	  if( de != null ) {
		DataSet ds = de.getDataSet();
		if( ds != null ) return new SPyGrid(ds);
	  }
	  return null;
  	}

    public boolean isCallable() { return true; }
  	
	public PyObject __call__(PyObject args[], String keywords[]) {
	  PyObject key = args[0];
	  return __finditem__(key);
    }
    
	public PyFloat value( SPyPoint pt ) {
	  DataEntry de = getActiveDataEntry( true );
	  if( de != null ) {
		int index = pt.index();
		if( index < 0 ) {
		  DataSet ds = de.getDataSet();
		  if( ds != null ) {
			int row = pt.row();
			int col = pt.col();
			float rv = ds.getValue( row, col, de );
			return new PyFloat(rv);
		  }
		} else {
		  float rv = de.getValue( index );
		  return new SPyFloat(rv);
		}
	  }
	  return null;
	}

	public  void setValue( SPyPoint pt, PyFloat val ) {
	  if( _de != null ) {
		int index = pt.index();
		if( index < 0 ) {
		  DataSet ds = _de.getDataSet();
		  if( ds != null ) {
			int row = pt.row();
			int col = pt.col();
			ds.setValue( row, col, _de, (float) val.getValue() );
		  } else {
			SPyInterface.error("No DataSet");
		  }
		} else {
		  _de.setValue( index, (float) val.getValue() );		}
	  } else {
		SPyInterface.error("Attempt to set value of immutable object");
	  }
	}

	public  void setValue( PyInteger index, PyFloat val ) {
	  if( _de != null ) {
		_de.setValue( index.getValue(), (float) val.getValue() );
	  } else {
		SPyInterface.error("Attempt to set value of immutable object");
	  }
	}

	public SPyFloat value( PyInteger index ) {
	  DataEntry de = getActiveDataEntry( true );
	  if( de != null ) {
		float rv = de.getValue( index.getValue() );
		return new SPyFloat(rv);
	  }
	  return null;
	}

    public void __setitem__(PyObject key, PyObject value) {
	  try {
		if( (key == Py.None) || (value == Py.None) ) {
			return;
		} else if( key instanceof SPyPoint ) {
		  SPyPoint pt = (SPyPoint)key;
		  PyFloat val = (PyFloat)value;
		  setValue( pt, val );
		} else if( key.isNumberType() ) {
		  PyInteger index = key.__int__();
		  PyFloat val = (PyFloat)value;
		  setValue( index, val );
		} 
	  } catch( Exception err ) {
		processException(err);
	  }
    }

    public PyObject __finditem__(PyObject key) {
	  try {
		if( key == Py.None ) {
			return Py.None;
		} else if( key instanceof SPyPoint ) {
		  return value( (SPyPoint)key );
		} else if( key.isNumberType() ) {
		  return value( key.__int__() );
		} 
	  } catch( Exception err ) {
		processException(err);
	  }
	  return null;
    }
	
	public String config( String command ) {
	  if( getMMLNames() == ConfigurationHandler.kVariableL ) {
		ConfigCommand cmd = new ConfigCommand(command);
		_cmds.add(cmd);
		try {
		  _client.sme_configure_object( _names[0] + "." + _names[1], cmd );
		} catch(SNPException err) {
		  return SPyMethods.processException(err);
		}
	  } else {
		return "Wrong object type for this command";
	  }
	  return "config " + _names[0] + "." + _names[1]  + ": " + command;
	}
	
	String fetchData( boolean view ) {
	  if( getMMLNames() == ConfigurationHandler.kVariableL ) {
		try {
		  _client.sme_var_browse_data( _names[0], _names[1], false, view );
		  return null;
		} catch(SNPException err) {
		  return SPyMethods.processException(err);
		}
	  } else {
		return "Wrong object type for this command.";
	  }
	}
	
	public String view() {
	  if( _object == null ) {
		if( _de != null ) {
		  DataSet ds = _de.getDataSet();
		  SPyInterface.browseDataSet ( ds, _de );
		  return "view " + _de.toString();
		}
	  }
	  String rv = fetchData( true ); 
	  return ( rv == null ) ?  ("view " + _names[0] + "." + _names[1]) : rv;
	}
	
	public String eqn() {
	  try {
		miiee.client.Action a = (miiee.client.Action)_object;
		return a.getCode();
	  } catch( ClassCastException err ) {
		return "Wrong object type for this command.";	  
	  }	
	}

	public String dep() { 
	  String ret = null;
	  try {
		Variable v = (Variable) _object;
		if( getMMLNames(v) == ConfigurationHandler.kVariableL ) {
		  ret = SPyInterface.addDependencies(v); 
		}
	  } catch( ClassCastException err ) {
		return "Wrong object type for this command.";	  
	  }	
	  return ( "add dependencies to " + _names[0] + "." + _names[1] + ":" +  ret );
	}
/*
	  try {
		miiee.client.Action a = (miiee.client.Action)_object;
		Variable v = (Variable) a.getParent();
		Module m = (Module)  v.getParent();
		if( getMMLNames(v) == ConfigurationHandler.kVariableL ) {
		  _sbuff.setLength(0);
		  _sbuff.append(  a.ID() + ": " );
		  XMLTreeModel tm = SPyInterface.getTreeModel();
		  try {
			_client.sme_var_dependencies( _names[0], _names[1], a.ID(),  _vbuff );
			Iterator iter = _vbuff.iterator();
			while( iter.hasNext() ) {
			   String dep_name = (String) iter.next();
			   int slen = dep_name.length()
			   String dep_var_name = ( dep_name.endsWith("_Dep") ? dep_name.substring(0,slen-4) : dep_name;
			   Variable dep_var =  (Variable) m.getChild( dep_var_name );
			   _sbuff.append( " " + dep_var_name  );
			   if( dep_var != null ) {
				  a.addDependency( dep_var );
				 _sbuff.append( '*' );
			   }
			}
		  } catch(Exception err) {
			return SPyMethods.processException(err);
		  }
		} 
	  } catch( ClassCastException err ) {
		return "Wrong object type for this command.";	  
	  }	
	  return "add dependencies to " + _names[0] + "." + _names[1] + "." +  _sbuff.toString();
	}
*/
	public String actions() {
	  if( getMMLNames() == ConfigurationHandler.kVariableL ) {
		_sbuff.setLength(0);
		XMLTreeModel tm = SPyInterface.getTreeModel();
		try {
		  _client.sme_var_actions( _names[0], _names[1], _vbuff );
		  Variable v = (Variable)_object;
		  Iterator iter = _vbuff.iterator();
		  while( iter.hasNext() ) {
			 String aname = (String) iter.next();
			 String info = _client.sme_var_actioninfo (_names[0], _names[1], aname );
			 miiee.client.Action a = new miiee.client.Action(aname,info);
			 v.addAction(a);
			 tm.addChild( v, a );
			 _sbuff.append( " " + aname  );
		  }
		} catch(Exception err) {
		  return SPyMethods.processException(err);
		}
	  } else {
		return "Wrong object type for this command.";
	  }
	  return "add actions to " + _names[0] + "." + _names[1] + ": " + _sbuff.toString();
	}
	
	public String display() {
	  if( getMMLNames() == ConfigurationHandler.kVariableL ) {
		try {
		  _client.sme_var_display_data( _names[0], _names[1] );
		} catch(SNPException err) {
		  return SPyMethods.processException(err);
		}
	  } else {
		return "Wrong object type for this command.";
	  }
	  return "display " + _names[0] + "." + _names[1] ;
	}

	public String data( int r0, int c0 ) {
	  if( getMMLNames() == ConfigurationHandler.kVariableL ) {
		try {
		  _client.sme_var_dump_data ( _names[0], _names[1], r0, c0, _result ) ;									
		} catch(SNPException err) {
		  return SPyMethods.processException(err);
		}
	  } else {
		return "Wrong object type for this command.";
	  }
	  return _result[0];
	}
	
	DataSet fetchDataSet() {
	  ListIterator li = DataSet.getDatasetIterator();
	  if( li == null ) {
		SPyInterface.error("Must step the simulation before fetching variables.\n\n");
		return null;
	  }
	  boolean found = false;
	  while( li.hasNext() ) {
		DataSet ds = (DataSet)li.next();
		if( ds != null ) {
		  String name = ds.toString();
		  if( name.equals( _names[1] ) ) { found = true; }
		  if( _debug ) { SimIO.print( "Checking dataset: " + name + ", target: " + _names[1] + ", found: " + found); }
		  if( found) { return ds; }
		}
	  }
	  return null;
	}
	
	public static DataSet getLocalDataSet( DataEntry de_target, DataEntry de_template ) {
	  DataSet ds_template = de_template.getDataSet();
	  ListIterator li = _local_dataSets.listIterator();
	  while( li.hasNext() ) {
		DataSet ds = (DataSet)li.next();
		if( ds != null ) { 
		  int index = ds.getEntryIndex(de_target);
		  if( index > 0 ) {
			ds.setSelection(index);
			return ds; 
		  }
		}
	  }
	  li = _local_dataSets.listIterator();
	  while( li.hasNext() ) {
		DataSet ds = (DataSet)li.next();
		if( (ds != null) && ( ds.browse() > 0 ) ) { 
		   if( ds.isCommensurate(ds_template) ) { 
			 ds.addEntry(de_target);
			 return ds; 
		   }
		}
	  }
	  byte browse_mode = 1;
	  DataSet ds = DataSet.create( _local_dataSets.size(), ds_template, "Computations", browse_mode );
	  _local_dataSets.add(ds);
	  ds.addEntry(de_target);
	  return ds;
	}
	
	DataEntry fetchDataEntry() {
	  ListIterator li = DataSet.getDatasetIterator();
	  while( li.hasNext() ) {
		DataSet ds = (DataSet)li.next();
		if( ds != null ) {
		  String name = ds.toString();
		  if( name.equals( _names[1] ) ) {
			DataEntry de = ds.lastEntry();
			float time = de.time();
			de.setInfo( toString() + "(" + time + ")" );
			return de;
		  }
		}
	  }
	  ListIterator li2 = DataSet.getDatasetIterator();
	  String myname = toString();
	  while( li2.hasNext() ) {
		DataSet ds = (DataSet)li2.next();
		if( ds != null ) {
		  if( ds.browse() > 0 ) {
			ListIterator li3 = ds.listIterator( ds.size() );
			while( li3.hasPrevious() ) {
			  DataEntry de = (DataEntry)li3.previous();
			  String name = de.toString();	
			  if( _debug ) { SimIO.print( "Checking browse data entry: " + name + ", target: " + myname ); }
			  if( name.startsWith(myname) ) {	  
				return de;
			  }
			}
		  }
		}
	  }
	  return null;
	}
	
	DataEntry getActiveDataEntry( boolean blockUntilAvailable ) {
	  if( _ds == null ) {
		if( _de != null ) { return _de; }
		getData(blockUntilAvailable); 
	  }
	  return ( _ds == null ) ? _de : _ds.lastEntry();
	}
	
	public String getData( boolean blockUntilAvailable ) {
	  if( getMMLNames() == ConfigurationHandler.kVariableL ) {
		if( _ds == null ) { _ds = fetchDataSet(); }
		if( _ds == null ) {
		  fetchData( false ) ;
		  while( _de == null  ) { 
			  try {  Thread.sleep(200L);   }
			  catch (InterruptedException e0) {  break;  }
			  _de = fetchDataEntry();
			  if( !blockUntilAvailable ) break;
		  }
		  if( _de == null ) { return "Can't find data for variable " + _names[1]; }
		  else { return "Got static data for variable " + _names[1]; }
		} else {
		  return "Got dynamic dataset for variable " + _names[1];
		}
	  } else {
		return "Wrong object type for this command.";   
	  }
	} 	
	
	public String toString() { 
	  if( getMMLNames() >= 0 ) {
		if( _names[1] != null ) return ( _names[0] + "." + _names[1] );
		else return _names[0];
	  }
	  return  ( _object == null ) ? super.toString() : _object.toString(); 
	}
		
	abstract class ComputeFloatOperation {
	  public abstract float compute( float f1, float f2 );
	}
	
	PyObject computeSpatialOperation2( String method_name, SPyObject other, ComputeFloatOperation ce ) {
	  try {
		DataEntry de1 = getActiveDataEntry(true);
		DataEntry de2 = other.getActiveDataEntry(true);
		float[] data_array1 = de1.getValues(); 
		byte format1 = de1.getFormat();
		float[] data_array2 = de2.getValues();
		byte format2 = de2.getFormat();
		if( format1 != format2 ) { throw new MMLException("Format incongruity in " + method_name); }
		int ds1 = de1.dataSize(); 
		int ds2 = de2.dataSize(); 
		float time = de1.time();
		if( ds1 != ds2 ) { throw new MMLException("Data size discrepancy in " + method_name); }
		String info = method_name + "(" + this.ID() + ", " + other.ID() + ")";
		float[] data3 = new float[ds1];
		float fval, data_max_value = -Float.MAX_VALUE, data_min_value = Float.MAX_VALUE;
		for( int i=0; i<ds1; i++ ) {
		  fval = ce.compute( data_array1[i], data_array2[i] );
		  if( fval > data_max_value ) data_max_value = fval;
		  if( fval < data_min_value ) data_min_value = fval;
		  data3[i] = fval; 
		}
		DataEntry de3 = new DataEntry( data3, info, format1, data_max_value, data_min_value, time );
		DataSet ds_new = getLocalDataSet( de3, de1 );
		SPyObject rv = new SPyObject(de3,_client);
		return rv;
	  } catch( Exception err ) {
		processException(err);
	  }
	  return null;
	}

	PyObject computeSpatialOperation1( String method_name, float value, ComputeFloatOperation ce ) {
	  try {
		DataEntry de1 = getActiveDataEntry(true);
		float[] data_array1 = de1.getValues(); 
		byte format1 = de1.getFormat();
		int ds1 = de1.dataSize(); 
		float time = de1.time();
		String info = method_name + "(" +  this.ID() + ", " + value + ")";
		float[] data3 = new float[ds1];
		float fval, data_max_value = -Float.MAX_VALUE, data_min_value = Float.MAX_VALUE;
		for( int i=0; i<ds1; i++ ) {
		  fval = ce.compute( data_array1[i], value );
		  if( fval > data_max_value ) data_max_value = fval;
		  if( fval < data_min_value ) data_min_value = fval;
		  data3[i] = fval; 
		}
		DataEntry de3 = new DataEntry( data3, info, format1, data_max_value, data_min_value, time );
		DataSet ds_new = getLocalDataSet( de3, de1 );
		SPyObject rv = new SPyObject(de3,_client);
		return rv;
	  } catch( Exception err ) {
		processException(err);
	  }
	  return null;
	}
	
	PyObject computeSpatialOperation( String method_name, PyObject other, ComputeFloatOperation ce ) {
	  if(  other.isNumberType() ) {
		float value = (float) other.__float__().getValue();
		return computeSpatialOperation1( method_name, value, ce );
	  } else {
		try {
		  return computeSpatialOperation2( method_name, (SPyObject) other, ce ) ;
		} catch( ClassCastException err ) {
		  SPyInterface.error( "Illegal type for this operation: " + other.__findattr__("__class__") );
		  return null;
		}
	  }
	}
    public boolean isMappingType() { return true; }
    public boolean isNumberType() { return false; }
    public boolean isSequenceType() { return false; }
	
	
	public PyObject __add__(PyObject other) {  
		return computeSpatialOperation( "add", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return f1  + f2; }
		} );
	}
	public PyObject __radd__(PyObject other) {  
		return computeSpatialOperation( "radd", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return f1  + f2; }
		} );
	}
	public PyObject __sub__(PyObject other) {  
		return computeSpatialOperation( "sub", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return f1 - f2; }
		} );
	}
	public PyObject __div__(PyObject other) {  
		return computeSpatialOperation( "div", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return f1/f2; }
		} );
	}
	public PyObject __rdiv__(PyObject other) {  
		return computeSpatialOperation( "div", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return f2/f1; }
		} );
	}
	public PyObject __mul__(PyObject other) {  
		return computeSpatialOperation( "mul", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return f1*f2; }
		} );
	}
	public PyObject __rmul__(PyObject other) {  
		return computeSpatialOperation( "mul", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return f1*f2; }
		} );
	}
	public PyObject __pow__(PyObject other) {  
		return computeSpatialOperation( "pow", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return (float) Math.pow( f1, f2 ); }
		} );
	}
	public PyObject __rpow__(PyObject other) {  
		return computeSpatialOperation( "pow", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return (float) Math.pow( f2, f1 ); }
		} );
	}

	public PyObject gt(PyObject other) {  
		return computeSpatialOperation( "gt", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return ( f1 > f2 ) ? 1f : 0f; }
		} );
	}
	public PyObject and(PyObject other) {  
		return computeSpatialOperation( "and", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return ( (f1 > 0f) && (f2 > 0f) ) ? 1f : 0f; }
		} );
	}
	public PyObject or(PyObject other) {  
		return computeSpatialOperation( "or", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return ( (f1 > 0f) || (f2 > 0f) ) ? 1f : 0f; }
		} );
	}
	public PyObject lt(PyObject other) {  
		return computeSpatialOperation( "lt", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return ( f1 < f2 ) ? 1f : 0f; }
		} );
	}
	public PyObject ge(PyObject other) {  
		return computeSpatialOperation( "ge", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return ( f1 >= f2 ) ? 1f : 0f; }
		} );
	}
	public PyObject le(PyObject other) {  
		return computeSpatialOperation( "le", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return ( f1 <= f2 ) ? 1f : 0f; }
		} );
	}
	public PyObject eq(PyObject other) {  
		return computeSpatialOperation( "eq", other, new ComputeFloatOperation() {
		   public float compute( float f1, float f2 ) { return ( f1 == f2 ) ? 1f : 0f; }
		} );
	}
 	
	void processException(Exception err) {
	  String message =  err.getMessage();
	  if( message == null ) { message = err.toString(); }
	  SimIO.show_error( null, message );
	  err.printStackTrace();
	}

}
