package miiee.python;

import miiee.util.*;
import java.util.Vector;
import java.util.Iterator;
import java.util.ListIterator;
import miiee.client.*;
import miiee.xml.*;
import org.python.core.*;
import miiee.mml.MMLException;

//---- SPyPoint ---------------------------------------------------------

public class SPyPoint extends PyObject  {

  int _index = 0;
  int _col = 0;
  int _row = 0; 
  SPyGrid _grid;
  
  public SPyPoint( int index, int row, int col, SPyGrid grid ) {
	_row = row; 
	_col = col; 
	_index = index; 
	_grid = grid;
  }

  public SPyPoint( int row, int col ) {
	_row = row; 
	_col = col; 
	_index = -1; 
  }

  public boolean isCallable() { return false; }
  public boolean isMappingType() { return false; }
  public boolean isNumberType() { return true; }
  public boolean isSequenceType() { return false; }
    
  public int col() { return _col; }
  public int row() { return _row; }
  public int index() { return _index; }
  public SPyGrid grid() { return _grid; }
  
  public PyObject trans(  int row_offset, int col_offset ) {
	return _grid.trans( this, row_offset, col_offset );
  }
  
  public PyObject trans(  SPyPoint pt ) {
	return _grid.trans( this, pt );
  }

  public PyObject __add__(PyObject other) { 
	try { 
	  SPyPoint pt= (SPyPoint)other;
	  SPyGrid grid = ( _grid == null ) ? pt.grid() : _grid;
	  return ( grid == null ) ? new SPyPoint(  _row + pt.row(), _col + pt.col() ) : 
								grid.getPoint( _row + pt.row(), _col + pt.col() );
    } catch( Exception err ) {
	  SPyInterface.error(err);
    }
    return Py.None;
  }

  public PyObject __radd__(PyObject other) { return __add__(other); }

  public PyObject __sub__(PyObject other) { 
	try { 
	  SPyPoint pt= (SPyPoint)other;
	  SPyGrid grid = ( _grid == null ) ? pt.grid() : _grid;
	  return ( grid == null ) ? new SPyPoint(  _row - pt.row(), _col - pt.col() ) : 
								grid.getPoint( _row - pt.row(), _col - pt.col() );
    } catch( Exception err ) {
	  SPyInterface.error(err);
    }
    return Py.None;
  }

  public PyInteger __int__() {
	  return new PyInteger(_index); 
  }
  
  // __class__ boilerplate -- see PyObject for details
  public static PyClass __class__;

  protected PyClass getPyClass() {
	  return __class__;
  }

  public String toString() { 
	return  "(" + _index + ":" + _row + "," + _col + ")"; 
  }

}
