package miiee.python;

import miiee.util.*;
import miiee.client.SMEClient;

//---- SPyStubs ---------------------------------------------------------

public class SPyStubs  {

  
	public SPyStubs() {
	}
	
	public void startup_shell( SMEClient client ) {
	  SPyMethods.setClient(client);
	  SPyInterface.setSelectionTree( client.getModelObjectTree() );
	  SPyInterface.startup(null);
	}
	
	public void set_choosen_object( java.lang.Object o ) {
	  SPyInterface.setSelectedComponent(o);
	}
	
	public void exec( java.lang.String script, java.lang.String file_path ) {
	  RunAction ra = new RunAction(script,file_path);
	  ra.actionPerformed(null);
	}

	public void compile( java.lang.String script, java.lang.String file_path ) {
	  CompileAction ca = new CompileAction(script,file_path);
	  ca.actionPerformed(null);
	}

	class RunAction extends QueuedExecutable {  
	  String _script;
	  String _file_path;
	  public RunAction(String script, String file_path) { _script = script; _file_path = file_path; }
	  public void execute() { 
		 SPyInterface.exec( _script, _file_path );
	  }
	}
	
	class CompileAction extends QueuedExecutable {  
	  String _script;
	  String _file_path;
	  public CompileAction(String script, String file_path) { _script = script; _file_path = file_path; }
	  public void execute() { 
		 SPyInterface.compile( _script, _file_path );
	  }
	}

}
