package miiee.servlet;

import javax.swing.*;
import java.awt.*;
import java.util.*;
import miiee.client.*;
import java.lang.reflect.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.xml.*;
import java.net.*;
import java.io.*;
import java.awt.event.*;

public class ServletClient extends Object {

  ProjectHandler _workBenceHandler;
  URL _servletBase;
  URL _servlet;
  String _servletName;
  boolean _debug = true;
  static Vector _instances = new Vector();
  static ServletClient _current;


  ServletClient( URL servletBase, String servletName ) throws java.net.MalformedURLException {
	_servletBase = servletBase;
	_servletName = servletName;
	_servlet = new URL( _servletBase,  _servletName );
  }
  
  public static ServletClient getInstance( URL servletBase, String servletName ) throws java.net.MalformedURLException {
	for( int i=0; i < _instances.size(); i++ ) {
	  _current = (ServletClient) _instances.elementAt(i);
	  if( _current.servletBase().equals(servletBase) && _current.servletName().equals(servletName) ) return _current;
	}
	_current = new ServletClient(servletBase,servletName);
	_instances.add(_current);
	return _current;
  }

  public static ServletClient getInstance() {
	return _current;
  }
  
  URL servletBase() { return _servletBase; }
  String servletName() { return _servletName; }
  public void destroy() {;}

   public JPanel setWorkBench( String workbenchName, String localHost ) {
	 String source = new String("Project");
	 String method = new String("setWorkBench");
	 Serializable objs[] =   { source, method, workbenchName, localHost };

	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   Object obj = getObject(in);
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error setting WorkBench: ",err);
	 }
	 return null;
  }
/* 
  public JPanel getWorkspaces( String workbenchName, String localHost ) {
	 String source = new String("Project");
	 String method = new String("getWorkspaces");
	 Serializable objs[] =   { source, method, workbenchName };

	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);

	   Object obj = getObject(in);
	   if(obj instanceof WorkSpaceRoot) {
		  _workBenceHandler =   ProjectHandler.create( (WorkSpaceRoot)obj, localHost ) ; 	
		  return _workBenceHandler.createContentPane();
	   } else {
		 SimIO.show_error(null,"Unrecognized Object passed from servlet: " + obj.toString() );
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting WorkSpaces: ",err);
	 }
	 return null;
  }
*/
  public HashMap getUsers() {
	 String source = new String("User");
	 String method = new String("get");
	 Serializable objs[] =   { source, method };

	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);

	   Object obj = getObject(in);
	   if( obj instanceof HashMap ) {
		  return (HashMap) obj;
	   } else {
		 SimIO.show_error(null,"Unrecognized Object passed from servlet: " + obj.toString() );
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Users: ",err);
	 }
	 return null;
  }

  public int setUsers( HashMap users ) {
	 String source = new String("User");
	 String method = new String("set");
	 Serializable objs[] =   { source, method, users };

	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);

	   Object obj = getObject(in);
	   if( obj instanceof Integer ) {
		  return ((Integer)obj).intValue();
	   } else {
		 SimIO.show_error(null,"Unrecognized Object passed from servlet: " + obj.toString() );
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error setting Users: ",err);
	 }
	 return -1;
  }

  public Object getModelList( String workSpace, String project ) {
 	 String source = new String("Project");
	 String method = new String("getModelList");
	 Serializable objs[] =   { source, method, workSpace, project };
	 Object obj = null;
	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   obj = getObject(in);
	   if( !( obj instanceof Vector ) ) {
		 SimIO.show_error(null,"Unrecognized Object passed from servlet: " + obj.toString() );
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Model List: ",err);
	   return null;
	 }
	 return obj;  
  }

  public Object getScenarioList( String workSpace, String project, String model ) {
 	 String source = new String("Project");
	 String method = new String("getScenarioList");
	 Serializable objs[] =   { source, method, workSpace, project, model };
	 Object obj = null;
	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   obj = getObject(in);
	   if( !( obj instanceof Vector ) ) {
		 SimIO.show_error(null,"Unrecognized Object passed from servlet: " + obj.toString() );
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Model List: ",err);
	   return null;
	 }
	 return obj;  
  }
 
   public Object getDataList( String workSpace, String project, String model, String scenario) {
 	 String source = new String("Project");
	 String method = new String("getDataList");
	 Serializable objs[] =   { source, method, workSpace, project, model, scenario };
	 Object obj = null;
	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   obj = getObject(in);
	   if( !( obj instanceof Vector ) ) {
		 SimIO.show_error(null,"Unrecognized Object passed from servlet: " + obj.toString() );
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Model List: ",err);
	   return null;
	 }
	 return obj;  
  }

  public Object getModel( String workSpace, String project, String model ) {
	 String source = new String("Project");
	 String method = new String("getModel");
	 Serializable objs[] =   { source, method, workSpace, project, model };
	 Object obj = null;
	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   obj = getObject(in);
	   if( !( obj instanceof XMLComponent ) ) {
		 SimIO.show_error(null,"Unrecognized Object passed from servlet: " + obj.toString() );
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Model: ",err);
	   return null;
	 }
	 return obj;
  }
  
  public String[] startupSME(  String workspace, String project, String model, String scenario, String lhost ) 	 {
	 String source = new String("Project");
	 String method = new String("startupSME");
	 Serializable objs[] =   { source, method, workspace, project, model, scenario, lhost };
	 Object obj = null;
	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   String rhost = (String) getObject(in);
	   String rport = (String) getObject(in);
	   String rv[] =   { rhost, rport };
	   return rv;
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Model Data: ",err);
	 }
	 return null;
  }


  public int getModelOutput( String workSpace, String project, String model ) {
	 String source = new String("Project");
	 String method = new String("getModelOutput");
	 Serializable objs[] =   { source, method, workSpace, project, model };
	 Object obj = null;
	 int data_count = 0;
	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   Integer nd = (Integer) getObject(in);
	   int ndata = nd.intValue();
	   if( ndata == 0 ) {
		 SimIO.print("ServletClient::getModelOutput: No data for this model.");
	   } else {
		 for( int i=0; i<ndata; i++ ) {
		   SimulationData sd = (SimulationData) getObject(in);
		   if( sd != null ) {
			  if( data_count == 0 ) { DataSet.clearData(); }
			  DataSet.addSimulation( sd );
			  data_count++;
		   }
		 }
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Model Data: ",err);
	 }
	 return data_count;
  }

  public boolean getSimulationData( String data_file ) {
	 String source = new String("Project");
	 String method = new String("getSimulationOutput");
	 Serializable objs[] =   { source, method, data_file };
	 Object obj = null;
	 boolean rv = false;
	 try {
	   ObjectInputStream in =  ServletWriter.postObjects(_servlet, objs);
	   SimulationData sd = (SimulationData) getObject(in);
	   if( sd != null ) {
		  DataSet.addSimulation( sd );
		  rv = true;
	   }
	 } catch ( Exception err ) {
	   if( _debug ) { err.printStackTrace(); }
	   SimIO.show_error(null,"Error getting Simulation Data: ",err);
	 }
	 return rv;
  }
  
  Object getObject(ObjectInputStream in) throws Exception  {
	 Object obj = in.readObject();
	 if ( obj instanceof Exception ) {
	   throw (Exception)obj;
	 }
	 return obj;
  }

}
