package miiee.servlet;

import java.util.*;
import javax.swing.*;
import miiee.xml.*;
import miiee.mml.*;
import miiee.util.*;
import org.xml.sax.*;
import java.io.*;

public class  User extends XMLComponent {

  protected HashMap _ws = new HashMap();
  WorkSpace _webspace;
  StringBuffer _buffer = new StringBuffer();
  	
  public  User( String name, String pw )  {
	 super(name);
	 addAttribute("pw",pw);
  }	
   
  public  User( Attributes atts, XMLContainer parent, ProjectHandler ph ) throws XMLException  {
	 super(atts,parent);
	 decodeWorkSpaces(ph);
  }
  
  public String getPassword() { return (String) getProperty("pw"); }
   
  public String getElementType( int format ) { return "user"; }  

  public Icon getIcon() {
	if( _icon == null ) {
	  _icon  = SimIO.loadIcon( "B-person.gif" );
	}
	return _icon;
  } 
  
  public void setWebSpace( WorkSpace ws ) {
	_webspace = ws;
  }
  
  public WorkSpace getWebSpace() {
	return _webspace;
  } 
  
  public void addWorkSpace( WorkSpace ws ) {
	_ws.put( ws.ID(), ws );
	if( _webspace == null ) { _webspace = ws; }
	encodeWorkSpaces(true);
  }

  public WorkSpace getWorkSpace( String id ) {
	return (WorkSpace) _ws.get( id );
  }
  
  public boolean hasWorkSpace( String id ) {
	return  _ws.containsKey( id );
  }
  
  public boolean canRunModels() {
	String canRun = (String) getProperty("canRunModels");
	try {
	  return canRun.trim().equalsIgnoreCase("true");
	} catch ( Exception err ) {
	  return false;
	}
  }
  
  public void removeWorkSpace( String id ) { 
	 _ws.remove(id);
	 encodeWorkSpaces(true);
  } 
  
  public void removeWorkSpaces() {
	_ws = new HashMap();
	encodeWorkSpaces(true);
  } 
  
  void encodeWorkSpaces( boolean set_property ) {
	_buffer.setLength(0);
	Iterator iter = _ws.entrySet().iterator();
	while( iter.hasNext() ) {
	  Map.Entry entry = (Map.Entry) iter.next();
	  String id = (String) entry.getKey();
	  if( _buffer.length() != 0 ) { _buffer.append(','); }
	  _buffer.append(id);
	} 
	if( set_property ) { 
	  try {
		setProperty( "ws", _buffer.toString(), XMLComponent.kMutable, "string" );
	  } catch ( XMLException err ) {
		SimIO.print( "Error setting property: " + err.getMessage() );
	  }
	}
  }

  public void printWorkSpaces() {
	encodeWorkSpaces(false);
	String ws = (String) getProperty( "ws" );
	SimIO.print("User " + ID() + " WorkSpaces: " + _buffer.toString() + ", ws property: " + ws );
  }
  
  public void decodeWorkSpaces( ProjectHandler ph ) {
	String ws = (String) getProperty( "ws" );
	if( ws != null ) {
	  StringTokenizer st = new StringTokenizer(ws,",");
	  while (st.hasMoreTokens()) {
         String s = st.nextToken();
         if( ph != null ) {
		   _ws.put( s, ph.getWorkSpace(s) );
		 } else {
		   _ws.put( s, null );
		 }
	  }	
	}
  }
  
   
}
