package miiee.servlet;

import java.util.*;
import javax.swing.*;
import java.io.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import javax.swing.border.*;
import javax.help.*;
import java.awt.event.*;
import org.xml.sax.*;
import miiee.xml.*;
import miiee.mml.*;
import miiee.util.*;
import miiee.wizard.*;

class  UserGroup  extends XMLContainer {
		
  public  UserGroup( String id )  {
	 super(id);
  }	
   
  public  UserGroup( Attributes atts )  {
	 super(atts);
  }
   
  public String getElementType( int format ) { return "user_group"; }  

  public Icon getIcon() {
	if( _icon == null ) {
	  _icon  = SimIO.loadIcon( "symbol.gif" );
	}
	return _icon;
  }   
}

public class UserRegister extends XMLHandler {

 
  protected static final int UH_SERIAL = 0;
  protected static final int UH_XML = 1;
 
  protected  XMLTree _usrDataTree;
  protected  JDialog _dialog;
  protected  String _userGroup;
  protected  User _current_User;
  protected  Toolkit _toolkit = Toolkit.getDefaultToolkit();
  protected  boolean _debug = true;
  protected int _write_mode = UH_XML;
  protected ServletClient _sc; 
  protected ProjectHandler _ph;
  protected boolean _changes_made = false;
  protected boolean _allow_user_registration = false;

  public UserRegister( String usergroup,   ServletClient sc ) { 
	super(); 
	_userGroup = usergroup;
	try {
	  createTreeRoot( null ); 
	} catch( XMLException err ) {;}
	_sc = sc;
	read();
  }

  public UserRegister( ProjectHandler ph ) { 
	super(); 
	_userGroup = ph.getWorkBenchName();
	try {
	  createTreeRoot( null ); 
	} catch( XMLException err ) {;}
	_ph = ph;
	read();
  }
 
  public HashMap getUsers() { 
	if( _tree_root == null ) return null;
	return  _tree_root.getChildren(); 
  }  
  
  public User getUser( String id ) { 
	if( _tree_root == null ) return null;
  	return (User) _tree_root.getChild(id); 
  }

  public User getCurrentUser() { 
  	return _current_User; 
  }
  
  public void setUsers(HashMap users) { 
	try {	
	  _tree_root.setChildren(users);
	} catch ( Exception err ) {
	  SimIO.show_error(null,"Error adding children",err);
	}
  }

  protected void createTreeRoot( XMLComponent top_component ) throws XMLException { 
	if( (_tree_root == null ) && ( _userGroup != null ) ) {
	  _tree_root = new UserGroup(_userGroup); 
	  SimIO.print("creating tree root: " + _userGroup );
	}
	if( top_component != null ) {
	  _tree_root.addChild(top_component);
	}
  }
	  
  public void addUser( User user ) { 
	try {	
	  _tree_root.addChild( user ); 
	} catch ( Exception err ) {
	  SimIO.show_error(null,"Error adding child",err);
	}
  }

  
  public void showHandlerDialog() { showTreeView( false ); }
  
  public boolean showConnectionDialog( String name ) {

	JTextField userNameField = new JTextField();
	userNameField.setColumns(12);
	if( name != null ) { userNameField.setText(name); }
	JTextField passwordField = new JPasswordField();
	passwordField.setColumns(12);
	JLabel userNameLabel = new JLabel("User name: ", JLabel.RIGHT);
	JLabel passwordLabel = new JLabel("Password: ", JLabel.RIGHT);

	JPanel connectionPanel = new JPanel(false);
	connectionPanel.setLayout(new BoxLayout(connectionPanel, BoxLayout.X_AXIS));

	JPanel namePanel = new JPanel(false);
	namePanel.setLayout(new BoxLayout(namePanel, BoxLayout.Y_AXIS));
	namePanel.add(userNameLabel);
	namePanel.add(passwordLabel);

	JPanel fieldPanel = new JPanel(false);
	fieldPanel.setLayout(new BoxLayout(fieldPanel, BoxLayout.Y_AXIS));
	fieldPanel.add( userNameField );
	fieldPanel.add( passwordField );

	connectionPanel.add(namePanel);
	connectionPanel.add(fieldPanel);

	Object[] options = { "Log In", "Register", "Cancel" };      
	int response = JOptionPane.showOptionDialog(null, connectionPanel, "Please Log in", 
                  JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                  null, options, options[0]);		
	
	if( response == 0 ) {
		if( verify_user( userNameField.getText(), passwordField.getText() ) ) {
		  return true;
		} else {
		  return showConnectionDialog( userNameField.getText() );
		}
	} else if( response == 1 ) {
	  if( _allow_user_registration ) {
		return showRegistrationDialog( userNameField.getText() );
	  } else {
		SimIO.show_info(null,"Registration permission denied");
		return showConnectionDialog( name ) ;
	  }
	} else return false;	  
  }

//  public Object showSelectUserDialog( String ws ) {
//
//	Vector user_data = getData();
//	JList list = new  JList(user_data);
//
//	Object[] options = { "Select", "Cancel" };      
//	int response = JOptionPane.showOptionDialog(null, list, "Please Select a user", 
//                  JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
//                  null, options, options[0]);		
//	
//	if( response == 0 ) {
//	  return list.getSelectedValue();
//	} else return null;	  
//  }
  

  public boolean showRegistrationDialog( String name ) {

	JTextField userNameField = new JTextField();
	userNameField.setColumns(12);
	if( name != null ) { userNameField.setText(name); }
	JTextField passwordField = new JPasswordField();
	passwordField.setColumns(12);
	JTextField verifyPasswordField = new JPasswordField();
	verifyPasswordField.setColumns(12);
	JLabel userNameLabel = new JLabel("User name: ", JLabel.RIGHT);
	JLabel passwordLabel1 = new JLabel("Password: ", JLabel.RIGHT);
	JLabel passwordLabel2 = new JLabel("Repeat Password: ", JLabel.RIGHT);

	JPanel connectionPanel = new JPanel(false);
	connectionPanel.setLayout(new BoxLayout(connectionPanel, BoxLayout.X_AXIS));

	JPanel namePanel = new JPanel(false);
	namePanel.setLayout(new BoxLayout(namePanel, BoxLayout.Y_AXIS));
	namePanel.add(userNameLabel);
	namePanel.add(passwordLabel1);
	namePanel.add(passwordLabel2);
	
	JPanel fieldPanel = new JPanel(false);
	fieldPanel.setLayout(new BoxLayout(fieldPanel, BoxLayout.Y_AXIS));
	fieldPanel.add( userNameField );
	fieldPanel.add( passwordField );
	fieldPanel.add( verifyPasswordField );

	connectionPanel.add(namePanel);
	connectionPanel.add(fieldPanel);
		
	Object[] options = { "Register", "Cancel" };      
	int response = JOptionPane.showOptionDialog(null, connectionPanel, "Please Register", 
                  JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                  null, options, options[0]);		
	
	if( response == 0 ) {
	  if( passwordField.getText().equals( verifyPasswordField.getText() ) ) {	
		return register_user( userNameField.getText(), passwordField.getText() );
	  } else {
		SimIO.show_warning(null, "Password input error" ); 
		return showRegistrationDialog( userNameField.getText() );
	  }
	} else return false;
  }
  
     public JPanel createContentPane() { 
	  _usrDataTree = new XMLTree( _tree_root );
	  Border loweredBorder = BorderFactory.createLoweredBevelBorder();
	  
	  JPanel c = new JPanel();
	  c.setLayout(new BorderLayout());
	  c.setBorder( loweredBorder );
	  Box main_panel = Box.createVerticalBox();

	  JTextArea ta = new JTextArea(100,70);
	  ta.setMargin( new Insets( 4, 4, 4, 4 ) ); 
	  ta.setWrapStyleWord(true);
	  ta.setLineWrap(true);
	  ta.setBackground( new Color(0, 0, 200) );
	  ta.setForeground( Color.yellow );
	  
	  JScrollPane scrollpane1 = new JScrollPane();
	  scrollpane1.getViewport().setView(ta);
	  scrollpane1.setPreferredSize(new Dimension( 300, 50 ));
	  scrollpane1.setBorder( loweredBorder );
	  main_panel.add(scrollpane1);

	  _usrDataTree.addTreeSelectionListener( new UserDocListener(ta) );	  
	  main_panel.add( _usrDataTree.getDisplayPanel() );
	  c.add( "Center", main_panel );
	  
	  JToolBar toolbar = new JToolBar();	  
	  c.add( "North", toolbar );	
	  			
	  JButton aButton = toolbar.add ( new AbstractAction( null, getIcon("B-person.gif") ) {
		  public void actionPerformed(ActionEvent e) { addUser(); }
		} ); 
	  aButton.setToolTipText( "create user" );
	  aButton.setAlignmentY(0.5f);

	  aButton = toolbar.add ( new AbstractAction( null, getIcon("edit.gif") ) { 
		public void actionPerformed(ActionEvent e) { editSelectedUser(); }
	  } ); 
	  aButton.setToolTipText( "edit user" );
	  aButton.setAlignmentY(0.5f);
	  
	  aButton = toolbar.add (  new AbstractAction( null, getIcon("delete.gif") ) {
		public void actionPerformed(ActionEvent e) { deleteSelectedUser(); }
	  } ); 
	  aButton.setToolTipText( "delete user" );
	  aButton.setAlignmentY(0.5f);

	  aButton = toolbar.add (  new AbstractAction( null, getIcon("workspace.gif" ) ) {
		public void actionPerformed(ActionEvent e) { addSelectedWorkSpaceToSelectedUser(); }
	  } ); 
	  aButton.setToolTipText( "add WorkSpace to user" );
	  aButton.setAlignmentY(0.5f);
	  
	  aButton = toolbar.add (  new AbstractAction( null, getIcon("del_workspace.gif" ) ) {
		public void actionPerformed(ActionEvent e) { removeWorkSpacesFromSelectedUser(); }
	  } ); 
	  aButton.setToolTipText( "clear WorkSpaces from user" );
	  aButton.setAlignmentY(0.5f);

	  toolbar.add( new JLabel( "  User Manager" ) );

	  toolbar.add( Box.createHorizontalGlue() );
/*
	  aButton = toolbar.add ( 
		new AbstractAction( null, getIcon("question.gif")  ) {
		  public void actionPerformed(ActionEvent e) { ; } 
		} 
	  ); 
	  aButton.setToolTipText( "help" );
	  aButton.setAlignmentY( Component.TOP_ALIGNMENT );
	  HelpBroker hb = SimIO.getHelpBroker( "SME"  );
	  hb.enableHelpOnButton( aButton, "UserManager", null );
*/	  
	  reload();
	  return c;
   }
      
   public  void showTreeView( boolean modal ) {
	  JFrame frame = new JFrame("User Handler");
	  _dialog = new JDialog( frame, "User Handler", modal ); // Modal
	
	  WindowListener wL1 = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) { destroy(); }
	  };
	  _dialog.addWindowListener(wL1);
	  
	  JPanel c = createContentPane();
	  			
	  _dialog.setContentPane( c );
	  _dialog.setSize(550,650);
	  
	  Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize(); 
	  int x = (screenDim.width - _dialog.getSize().width) / 2;
	  int y = (screenDim.height - _dialog.getSize().height) / 2;
	  _dialog.setLocation(x, y);	   
	  _dialog.setVisible(true);
   }

     protected JButton createToolbarButton( String icon, String tooltip, String actionCommand, Action a ) {
		JButton b = new JButton( getIcon(icon) ) {
				public float getAlignmentY() { return 0.5f; }
		};
		b.setRequestFocusEnabled(false);
		b.setMargin(new Insets(1,1,1,1));
		b.setToolTipText(tooltip);
		b.setActionCommand(actionCommand);
		b.addActionListener(a);
        return b;
    }  

	public void addUser() {
	  String[] args = { "Demo User", "demo", "demo", "For SME guests", "false" };
	  Wizard w = Wizard.getWizard( "User.create", args );
	  if( w == null ) { 
		XMLException.show_error( _dialog, "Can't find Wizard: User.create" );
		return;
	  }
	  w.addAttribute( "usergroup.name", _userGroup );
	  w.show( true , new ScriptExecutable() {
		public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
		  String name = (String) executer.getDataProperty( "User.name", "value" );
		  String id = (String) executer.getDataProperty( "User.id", "value" );
		  String pw = (String) executer.getDataProperty( "User.pw", "value" );
		  String doc = (String) executer.getDataProperty( "User.doc", "value" );
		  String run_mod = (String) executer.getDataProperty( "User.run_mod", "value" );
		  addUser( name, id, pw, doc, run_mod );
		}
	  } );
	}
	public void editSelectedUser( String name, String pw, String doc, String run_mod ) {
	  User user = (User) _usrDataTree.getSelectedNode( 2 ) ;
	  if( user != null ) {
		try {
		  user.setAttribute("name",name);
		  user.setAttribute("pw",pw);
		  user.setProperty("doc",doc);
		  user.setAttribute("canRunModels",run_mod);
		  SimIO.print("Edited user " + user + ", can run: " + ((user.canRunModels()) ? "true" : "false")  );
		} catch ( Exception err ) {
		  XMLException.show_error( _dialog, "Error setting User properties: ", err );
		}
		_changes_made = true;
		_usrDataTree.processSelectionChange();
		_usrDataTree.reload();
	  } else {
		XMLException.show_error( _dialog, "Must select a User." );
	  }
	}

	public void editSelectedUser() {
	  User user = (User) _usrDataTree.getSelectedNode( 2 ) ;
	  if( user != null ) {
		  System.out.println("Editing User: " + user.ID() );
		  String name = (String) user.getProperty("name");
		  String pw = (String) user.getProperty("pw");
		  String doc = (String) user.getProperty("doc");
		  String canRunModels = (String) user.getProperty("canRunModels"); 
		  String[] args = { name, pw, doc, canRunModels };
		  Wizard w = Wizard.getWizard( "User.edit", args );
		  if( w == null ) { 
			XMLException.show_error( _dialog, "Can't find Wizard: User.edit" );
			return;
		  }
		  w.addAttribute( "usergroup.name", _userGroup );
		  w.show( true , new ScriptExecutable() {
			public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
			  String Name = (String) executer.getDataProperty( "User.name", "value" );
			  String PW = (String) executer.getDataProperty( "User.pw", "value" );
			  String Doc = (String) executer.getDataProperty( "User.doc", "value" );
			  String Run_mod = (String) executer.getDataProperty( "User.run_mod", "value" );
			  editSelectedUser(Name,PW,Doc,Run_mod);
			}
		  } );
	  } else {
		XMLException.show_error( _dialog, "Must select a User." );
	  }
	}

	void editSelectedUserDoc()	{
	  XMLComponent c1 = _usrDataTree.getSelectedNode();
	  if( c1 != null ) {
		System.out.println("Editing node: " + c1.ID() );
		c1.editProperty("doc");
		_changes_made = true;
	  } else {
		XMLException.show_error( _dialog, "Must select something." );
	  }
	}
	
	void deleteSelectedUser() {
	  User user = (User) _usrDataTree.getSelectedNode( 2 ) ;
	  if( user != null ) {
		if( XMLException.show_confirm( _dialog, "Are you sure you want to remove this User?" ) ) {
		  System.out.println("Removong node: " + user.ID() );
		  _usrDataTree.removeCurrentNode();
		  _changes_made = true;
		}
	  } else {
		XMLException.show_error( _dialog, "Must select a User" );
	  }
	}

		  		    
	void addSelectedWorkSpaceToSelectedUser() {
	  if( _ph == null ) {
		XMLException.show_error( _dialog, "No Project Handler" );
		return;
	  }
	  User user = (User) _usrDataTree.getSelectedNode( 2 ) ;
	  if( user != null ) {
		WorkSpace ws = _ph.getSelectedWorkSpace();
		if( ws != null ) {
		  System.out.println( "add WorkSpace: " + ws.ID() + " to User " + user.ID() );
		  SimIO.show_info( null, "Adding WorkSpace: " + ws.ID() + " to User " + user.ID() );
		  user.addWorkSpace(ws);
		  _usrDataTree.processSelectionChange();
		  _changes_made = true;
		} else {
		  XMLException.show_error( null, "Must select a WorkSpace in the Project Manager" );  
		}
	  } else {
		XMLException.show_error( _dialog, "Must select a User" );
	  }
	}

	void removeWorkSpacesFromSelectedUser() {
	  if( _ph == null ) {
		XMLException.show_error( _dialog, "No Project Handler" );
		return;
	  }
	  User user = (User) _usrDataTree.getSelectedNode( 2 ) ;
	  if( user != null ) {
		System.out.println( "Remove WorkSpaces from User " + user.ID() );
		SimIO.show_info( null, "Removing WorkSpaces from User " + user.ID() );
		user.removeWorkSpaces();
		_usrDataTree.processSelectionChange();
		_changes_made = true;
	  } else {
		XMLException.show_error( _dialog, "Must select a User" );
	  }
	}
  		
  boolean verify_user( String name, String pw ) {
	User u = getUser(name);
	System.out.println("Verifying User: " + name + ", result: " + u );
	if( u == null ) {
	  SimIO.show_warning(null, "Unknown user: " + name ); 
	  if( _allow_user_registration ) {
		return showRegistrationDialog( name );
	  } else {
		_current_User = null;
		return false;
	  }
	} else {
	  if( u.getPassword().equals(pw) ) {
		_current_User = u;
		return true;
	  } else {
		_current_User = null;
		SimIO.show_warning(null, "Password input error" ); 
		return false;
	  }
	}
  }
  
  boolean register_user( String name, String pw ) {
	User u = new User(name,pw);
	addUser(u);
	write();
	_current_User = u;
	return true;
  }
  
	public void reload() {
	  XMLTreeModel tm = (XMLTreeModel) _usrDataTree.getModel();
	   tm.reload();
	  _usrDataTree.expandAll();
	}
	
	public  User addUser( String name, String id, String pw, String doc, String run_mod ) {
	  User p = null;
	  try {
		p = new User( id, pw );
		if( _debug ) { System.out.println("Adding User " + p + ", parent: " + _tree_root  ); }
		p.addProperty( "doc", doc );
		p.addAttribute( "name", name );
		p.addAttribute( "canRunModels", run_mod );
		addChildToContainer( _tree_root, p );
		_current_User = p;
		p.stampComponent(); 
		_changes_made = true;
	  } catch (  Exception err ) {
		SimIO.print("Error adding User: " + err.getMessage() );
	  }
	  return p;
	}
	
			  
   private  void destroy() { save(); }
   
   public void save() {
	 if( _changes_made ) {
	  int rv = JOptionPane.showConfirmDialog( null, 
		  "Save User changes?", "JST confirm", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE );
	  SimIO.print("Got response: " + rv );
	  if( rv == 0 ) { 
		_changes_made = false;
		write(); 
	  }
	}
   }

	void addChildToContainer( XMLContainer parent, XMLComponent child ) {
	  XMLTreeModel tm = getTreeModel();
	  if( parent == null ) { parent = getTreeRoot(); }
	  if( tm != null ) {
		tm.addChild(parent,child);
		_usrDataTree.expandPath( child );
	  } else  if( parent != null )  { 
		 try {
		   parent.addChild( child ); 
		} catch ( miiee.xml.XMLException err ) {  err.show( null, "Error adding Child: " );  }
	  }
	}

	
	public String getUserGroupName() { 	return _userGroup; }
	public XMLTreeModel getTreeModel() { return (XMLTreeModel) ((_usrDataTree == null) ? null : _usrDataTree.getModel()); }	  

   public  void dispose() { 
	 clear();
	 if( _dialog != null ) { _dialog.setVisible(false); _dialog.dispose(); }
	  _dialog = null; 
	  _usrDataTree = null;
   }
   

     
  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create ) {
	XMLComponent rv = null;
	try {
	  if( name.equals("user_group") ) {
		rv = _tree_root;
		_tree_root.addAttributes( atts );
		if( _debug ) { System.out.println( " Update user_group: " + rv.ID() ); }
	  }
	  else if( name.equals("user") ) {
		rv = new User( atts, (XMLContainer)parent, _ph );
		_current_User = (User) rv;
		if( _debug ) { System.out.println( " Created User: " + rv.ID() + ", parent: " + parent.ID() ); }
	  }
	  if( rv != null ) { 
		rv.stampComponent(); 
	  }
	} catch ( XMLException err ) {
	  System.out.println( "getComponentFromName: " + err.getMessage() );
	}
	return rv; 
  }

  public void write() {
	if( _sc != null ) {
	  _sc.setUsers( getUsers() );	
	} else {
	  switch(_write_mode) {
		case UH_XML:     writeXML();     break;
		case UH_SERIAL:  writeSerial();  break;
	  }
	}
  }
   
  public void read() {
	if( _sc != null ) {
	  setUsers( _sc.getUsers() );
	} else {
	  switch(_write_mode) {
		case UH_XML:     readXML();     break;
		case UH_SERIAL:  readSerial();  break;
	  }
	}
  }

  void readSerial() {
	String usersfile = SimIO.getWorkbenchDirectory()  +  "/userdata.hm";
	try {
	  FileInputStream os = new FileInputStream( usersfile );
	  ObjectInputStream ois = new ObjectInputStream(os);
	  setUsers( (HashMap) ois.readObject() );
	  ois.close();
	} catch ( Exception err ) {
	  System.out.println( "Error getting user data: " + err.getMessage() );
	}
  }
  
  void writeSerial() {
	String usersfile = SimIO.getWorkbenchDirectory() + "/userdata.hm";
	try {
	  FileOutputStream os = new FileOutputStream( usersfile );
	  ObjectOutputStream ois = new ObjectOutputStream(os);
	  ois.writeObject( getUsers() );
	  ois.close();
	} catch ( Exception err ) {
	  System.out.println( "Error setting user data: " + err.getMessage() );
	}
  }	

  public void readXML() {   
	String path = SimIO.getWorkbenchDirectory();
	System.out.println("\n  Reading Users file: " + path);
	if( path.startsWith("file:") ) {
	  path = path.substring(5);
	}
	String  fname = "userdata.xml";	
	File f = new File(path,fname);
	try {
	  if( f.canRead() ) {
		read( f.getAbsolutePath(), null, null, XMLComponent.DEFINITION, null  );
		return;
	  } else {
		System.out.println("\n  No Users file found: " + f.toString() );
	  }
	} catch(  java.lang.SecurityException err ) {
	  System.out.println("\n  Can't read Users file: " + f.toString() + " : " + err.getMessage() );
	}
  }
  	
  public void writeXML() { 
	String  xml_file = "userdata.xml";
	String path = SimIO.getWorkbenchDirectory();
 	String dtd_file = "user";
 	XMLContainer xc = getTreeRoot();
	xc.setNamespace(path);
	System.out.println("Writing Users file " + xml_file + " to " + path  );
 	xc.writeXML( xml_file, dtd_file, XMLComponent.DEFINITION );	  
  }
}

class UserDocListener extends Object implements TreeSelectionListener {
  JTextArea _text;
  UserDocListener( JTextArea ta ) {
	_text = ta;
  }
  public void valueChanged(TreeSelectionEvent e) {
	try {
	  XMLComponent doc = (XMLComponent)e.getPath().getLastPathComponent();
	  _text.setText( (String) doc.getProperty("doc") );
	} catch ( ClassCastException err ) { 
	  _text.setText("");
	} 
  }
  
}

