package miiee.tree;

import javax.swing.tree.*;
import javax.swing.event.*;
import miiee.xml.*;
 
/**
 * An abstract implementation of the TreeTableModel interface, handling 
 * the list of listeners. 
 *
 * @version %I% %G%
 *
 * @author Philip Milne
 */

public abstract class AbstractTreeTableModel extends XMLTreeModel implements TreeTableModel {
  
    public AbstractTreeTableModel( XMLContainer root ) {
		super(root);
    }
    
    //
    // Default impelmentations for methods in the TreeTableModel interface. 
    //

    public Class getColumnClass(int column) { return Object.class; }

   /** By default, make the column with the Tree in it the only editable one. 
    *  Making this column editable causes the JTable to forward mouse 
    *  and keyboard events in the Tree column to the underlying JTree. 
    */ 
    public boolean isCellEditable(Object node, int column) { 
         return getColumnClass(column) == TreeTableModel.class; 
    }

    public void setValueAt(Object aValue, Object node, int column) {}


    // Left to be implemented in the subclass:

    /* 
     *   public int getColumnCount() 
     *   public String getColumnName(Object node, int column)  
     *   public Object getValueAt(Object node, int column) 
     */

}
