package miiee.tree;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;
import javax.swing.border.*;
import javax.swing.JTextField;

import java.awt.Component;
import java.awt.Color;

import java.io.Serializable;

/**
 * The class for rendering (displaying) individual editable text cells
 * in a JTable.
 * <p>
 */
public class EditableTextTableCellRenderer extends JTextField
    implements TableCellRenderer, Serializable
{

    protected static Border noFocusBorder; 
    
    // We need a place to store the color the JLabel should be returned 
    // to after its foreground and background colors have been set 
    // to the selection background color. 
    // These ivars will be made protected when their names are finalized. 
    private Color unselectedForeground; 
    private Color unselectedBackground; 

    public EditableTextTableCellRenderer() {
	  super();
	  noFocusBorder = new EmptyBorder(1, 2, 1, 2);
	  setOpaque(true);
	  setEditable(true);
	  setBorder(noFocusBorder);
    }

    public void setForeground(Color c) {
        super.setForeground(c); 
        unselectedForeground = c; 
    }
    
    public void setBackground(Color c) {
        super.setBackground(c); 
        unselectedBackground = c; 
    }

    public void updateUI() {
        super.updateUI(); 
	setForeground(null);
	setBackground(null);
    }
    
    public Component getTableCellRendererComponent(JTable table, Object value,
                          boolean isSelected, boolean hasFocus, int row, int column) {

	if (isSelected) {
	   super.setForeground(table.getSelectionForeground());
	   super.setBackground(table.getSelectionBackground());
	}
	else {
	    super.setForeground((unselectedForeground != null) ? unselectedForeground 
	                                                       : table.getForeground());
	    super.setBackground((unselectedBackground != null) ? unselectedBackground 
	                                                       : table.getBackground());
	}
	
	setFont(table.getFont());

	if (hasFocus) {
	    setBorder( UIManager.getBorder("Table.focusCellHighlightBorder") );
	    if (table.isCellEditable(row, column)) {
	        super.setForeground( UIManager.getColor("Table.focusCellForeground") );
	        super.setBackground( UIManager.getColor("Table.focusCellBackground") );
	    }
	} else {
	    setBorder(noFocusBorder);
	}

        setValue(value); 
        
	return this;
    }
    
    protected void setValue(Object value) {
	setText((value == null) ? "" : value.toString());
    }


    /**
     * A subclass of DefaultTableCellRenderer that implements UIResource.
     * DefaultTableCellRenderer doesn't implement UIResource
     * directly so that applications can safely override the
     * cellRenderer property with DefaultTableCellRenderer subclasses.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class UIResource extends EditableTextTableCellRenderer 
        implements javax.swing.plaf.UIResource
    {
    }

}


