package miiee.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Vector;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import java.awt.Toolkit;

//---- Alarm ---------------------------------------------------------

public class Alarm extends Object {

  Vector _event_list = new Vector();
  private static Toolkit _toolkit = Toolkit.getDefaultToolkit(); 
  boolean _debug = false;
  
  public Alarm() { ; }
  
  public void addEvents(String times[]) {
	printCurrentTime();
	for( int i=0; i<times.length; i++ ) {
		String ts = times[i];
		Date d = parseTimeString( ts.toLowerCase() );
		System.out.println("Adding time: " + d.toString() );
		_event_list.add(d);
	}  
  }
  
  String chop_last_char( String s ) { return s.substring(0,s.length()-1); }
  
  public Date parseTimeString( String ts )  {
	int hour = 0, minute = 0, am_pm = Calendar.AM;
	if( ts.endsWith("p") ) {
	  am_pm = Calendar.PM;
	  ts = chop_last_char( ts );
	}
	if( ts.endsWith(".") ||  ts.endsWith(":") ) {
	  ts = chop_last_char( ts );
	}
	StringTokenizer st = new StringTokenizer( ts, ".: " );
	int field = 0;
	while( st.hasMoreTokens() ) {
	  String t = st.nextToken();
	  try {
		switch( field++ ) {
		  case 0: 
			hour = Integer.parseInt(t); 
		  break;
		  case 1: 
			if( Character.isDigit( t.charAt(0) ) ) {
			  minute = Integer.parseInt(t); 
			} else {
			  am_pm = getAMPM( t );
			  field++;
			}
		  break;
		  case 2: 
			am_pm = getAMPM( t );
		  break;
		}
	  } catch ( NumberFormatException err ) {
		System.out.println("Parse error: " + err.getMessage() + "\n" );
		System.exit(1);
	  }
	}
	return  getCurrentDate( hour, minute, am_pm );
  }
  
  int getAMPM( String t ) throws NumberFormatException {
	  int am_pm = Calendar.AM; 
	  if( t.charAt(0) == 'p' ) {
		 am_pm = Calendar.PM; 
	  } else if( t.charAt(0) == 'a' ) { 
		am_pm =  Calendar.AM; 
	  } else {
		throw new NumberFormatException( "Bad AM/PM field: " + t );
	  }
	  return am_pm;
  }

  void printCurrentTime() {
	 Date cd = getCurrentDate();
	 System.out.println("Current time: " + cd.toString() );
  }
  
  public void run() {
	while( checkEvents() ) { 
	  try {
		  Thread.sleep(60000L);
	  }
	  catch(InterruptedException ex) {}
	} 
  }
  
  Date getCurrentDate() {
	 Calendar current = Calendar.getInstance();
	 return current.getTime();
  }

  Date getCurrentDate( int hour, int minute, int am_pm ) {
	 Calendar current = Calendar.getInstance();
	 if( am_pm == Calendar.PM ) { hour += 12; }
	 current.set(Calendar.HOUR_OF_DAY, hour);
	 current.set(Calendar.MINUTE, minute);
	 return current.getTime();
  }
  
  boolean checkEvents() {
	 Date cd = getCurrentDate();
	 for( int i=0; i<_event_list.size(); i++ ) {
	   Date d = (Date) _event_list.get(i);
	   if( _debug ) {
		 System.out.println( "\nChecking Dates:" );
		 System.out.println( "\tCurrent: " + cd.toString() );
		 System.out.println( "\tEvent:   " + d.toString() );
	   }
	   if( cd.after(d) ) {
		 alarm(d);
		 _event_list.remove(i);
		 break;
	   }
	 }
	 return ( _event_list.size() > 0 );
  }
  
  void alarm ( int len ) {
	 for( int i=0; i<len; i++ ) { 
	    _toolkit.beep(); 
	 }
  }

  void alarm ( Date d ) {
	 System.out.println( "\nEvent alarm: " + d.toString() );
	 ContinuousAlarm alarm = new ContinuousAlarm(300);
	 alarm.start();
	 JOptionPane.showMessageDialog(null,"Event Notification");
	 alarm.stop();
  }

  public static void main(String args[]) {
	Alarm a = new Alarm();
	a.addEvents(args);
	a.run();
	System.exit(0);	
  }

  class ContinuousAlarm implements Runnable {
	boolean _alarm_on = true;
	long _delay = 0L;
	Thread _thread;

	public ContinuousAlarm( int delay ) { _delay = delay; }

	public void run() {
	 while( _alarm_on ) { 
		_toolkit.beep(); 
		System.out.print(".");
		try { _thread.sleep(_delay); }
		catch(InterruptedException ex) {}
	 }
	}

	public void start() {
	 _thread = new Thread((Runnable)this); 
	 _thread.start(); 	
	}

	public synchronized void stop() { _alarm_on = false; }
  }
}
