package miiee.util;

import java.util.Vector;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.*;

public class AnimationControlPanel extends JPanel implements Runnable {
    protected JFrame _frame;
    protected AttributeValuePair _timeDisplay;
	protected Thread _animThread;
	private static Vector _Panels = new Vector(16,16);
	private int _anim_control_mode = ANIM_RUN;
	private boolean _forward_step = true;
	private String _group_name;
    Vector _animations;
    float _time = 0.0f;
    float _dt = Float.MAX_VALUE;

    public static final int ANIM_EXIT	= 0;
    public static final int ANIM_RUN	= 1;
    public static final int ANIM_PAUSE	= 2;
    public static final int ANIM_STEP	= 3;

    private AnimationControlPanel(String group_name) { 
	  super(); 
	  _group_name = group_name;
	  _animations = new Vector(16,16);
	}
    
    public static AnimationControlPanel GetControlPanel( int group_index, String group_name ) {
	  AnimationControlPanel p = null; 
	  try {
		p = (AnimationControlPanel) _Panels.elementAt(group_index);
	  } catch ( ArrayIndexOutOfBoundsException err ) {;}
	  
	  if( p== null ) {
		p = new AnimationControlPanel(group_name);
		if( group_index >= _Panels.size() ) { _Panels.setSize(group_index+16); }
		_Panels.setElementAt(p, group_index);
	  }
	  return p;
    }

	public static void closeControlPanel( int group_index ) {
	  AnimationControlPanel p = null;
	  try {
		p = (AnimationControlPanel) _Panels.elementAt(group_index);
	  } catch ( ArrayIndexOutOfBoundsException err ) { return; }
	  if( p != null ) {
		p.dispose();
		_Panels.setElementAt( null, group_index);
	  }
	} 
	
    public synchronized void addAnimation( AnimationStepper s ) {
	  _animations.addElement(s);
	  float dt =  s.getTimestep(); 
	  if( dt < _dt ) _dt = dt;
    }

    public synchronized int closeAnimation( AnimationStepper s ) {  
	  _animations.removeElement(s);
	  float dt =  s.getTimestep(); 
	  if( dt < _dt ) _dt = dt;
	  return _animations.size();
    }
    
    void setup_panels() {
	  SimIO.print("setup panels  *** ");
	  
	  setLayout(new GridLayout(2,1));
	  
	  JPanel  buttonPanel = new JPanel(false);
	  buttonPanel.setLayout(new FlowLayout());
	  add(buttonPanel);

	  JButton aButton;

	  aButton = new JButton("step");
	  aButton.addActionListener( new StepAction() );
	  buttonPanel.add( aButton );

	  aButton = new JButton("reverse");
	  aButton.addActionListener( new ReverseAction() );
	  buttonPanel.add( aButton );

	  aButton = new JButton("stop");
	  aButton.addActionListener( new StopAction() );
	  buttonPanel.add( aButton );

	  aButton = new JButton("run");
	  aButton.addActionListener( new RunAction() );
	  buttonPanel.add( aButton );
	  
	  JPanel   infoPanel = new JPanel(false);
	  infoPanel.setLayout(new FlowLayout());
	  add(infoPanel);

	  _timeDisplay = AttributeValuePair.New( "time", false, 10 );
	  infoPanel.add(_timeDisplay);

    }
    
    public void showPanel() {
	  if( _timeDisplay == null ) { 
		setup_panels(); 
	  }
	  if( _frame == null ) {
		_frame  = new JFrame(_group_name );
		_frame.setBackground(Color.lightGray);
		_frame.setContentPane(this);	
		_frame.pack();
	  }
	  _frame.setVisible(true);	
	  start();
    }
    
    public void hidePanel() {
	  try {
		_frame.setVisible(false);	
	  } catch( NullPointerException err ) {;}
	  stop();
    }

    public void dispose() {
	  stop();
	  try {
		_frame.setVisible(false);	
		_frame.dispose();	
	  } catch( NullPointerException err ) {;}
    }
        
    class StepAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
        _anim_control_mode = ANIM_STEP;
	  }
    } 
    
    class ReverseAction extends Object implements ActionListener {  
	  public void actionPerformed(ActionEvent e) {
        _forward_step = !_forward_step;
	  }
    } 
    class StopAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
         _anim_control_mode = ANIM_PAUSE;
	  }
    } 
    class RunAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
        _anim_control_mode = ANIM_RUN;
	  }
    }

    public synchronized void start()  {
		if( _animThread == null ) {
		  _animThread= new Thread(((Runnable)this)); 
		  _animThread.start(); 
		}
    }
    
	public void stop() {
	  if( _animThread != null ) { 
		_anim_control_mode = ANIM_EXIT;
		_animThread = null;
	  }
	}

	public float getTimestep() {
	  Vector l;
	  synchronized(this)     {
		  l = (Vector)_animations.clone();
	  }
	  float tmp, dt = Float.MAX_VALUE;
	  for(int i = 0; i < l.size(); i++) {
		  tmp = ((AnimationStepper)l.elementAt(i)).getTimestep(); 
		  if( tmp < dt ) { dt = tmp; }
	  }
	  return dt;
	}

	public int setGlobalImageTime( float time, boolean forward ) {
	  Vector l;
	  int stmp, step_status = 2;
	  synchronized(this)     {
		  l = (Vector)_animations.clone();
	  }
	  for(int i = 0; i < l.size(); i++) {
		  int stat = ((AnimationStepper)l.elementAt(i)).setAnimationTime(time,forward); 
		  if( stat < 2 ) { step_status = 0; }
	  }
	  FormattedFloat fval = new FormattedFloat(time);
	  String t = fval.toJavaFormatString(4);
	  _timeDisplay.setValue(t);
	  return step_status;
	}
		  
    public void run() {
		boolean restart = true;
		boolean stop = false;
		Thread curr_thread = Thread.currentThread();
		curr_thread.setPriority( 4 );
        while ( _anim_control_mode != ANIM_EXIT ) {
			if( _dt == Float.MAX_VALUE ) { _dt = getTimestep(); }
            try {  Thread.sleep(200L);   }
            catch (InterruptedException e0) {  return;  }
            
            switch ( _anim_control_mode ) {
                case ANIM_PAUSE: 
					continue;
                case ANIM_STEP: case ANIM_RUN:
					if( _forward_step ) { 
					  if( restart ) {
						_time = 0.0f; 
						restart = false;
					  } else if( stop ) { 					  
						_anim_control_mode= ANIM_PAUSE;
						stop = false;
						restart = true;
					  } else if( _dt != Float.MAX_VALUE ) { _time += _dt; }
					}
					else {
					  if( _time == 0.0f ) { _anim_control_mode= ANIM_PAUSE; }
					  else if( _time >= _dt ) { _time -= _dt;  }
					  else {  _time = 0.0f; }
					}
					int step_status = setGlobalImageTime( _time, _forward_step );
					if(  step_status == 2 ) {
					  stop = true;
					}
                    if( _anim_control_mode == ANIM_STEP ) {
					  _anim_control_mode= ANIM_PAUSE;	
					} 
					continue;
            }
        }
    } 
  
}
