package miiee.util;

import java.awt.*;
import java.applet.Applet;
import javax.swing.*;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;

// Referenced classes of package miiee.util:
//            AppletController, SimIO

public class AppContainer extends javax.swing.JFrame {
    private static int kFrameSize = 15;
    private AppletKernel _app;
    protected AppletController _appc;

    public AppContainer(String title, AppletKernel app, AppletController appc) {
        super(title);

		// Force AnimationViewer to come up in the Cross Platform L&F
		try {
			UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
			// If you want the System L&F instead, comment out the above line and
			// uncomment the following:
			// UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception exc) {
			System.err.println("Error loading L&F: " + exc);
		}

		addWindowListener( 
			new WindowAdapter() {
			  public void windowOpened(WindowEvent e) { init(); }
			  public void windowClosing(WindowEvent e) {   dispose(); }
			}
		);
        
        _app = app;
        _appc = appc;
    }
    
    public void init() {
	  _app.setFrame( this );
	  _app.init();
	  getContentPane().add( "Center", _app.getContentPane() );
	  _app.start();
	  paintComponents(getGraphics());
    }

    public synchronized void dispose() {
		_app.stop();
		_app.destroy();
        if(_appc != null)  _appc.notifyDestroyed(_app);
        super.dispose();
    }

    public void dumpThreads()
    {
        int nthreads = Thread.activeCount();
        Thread tl[] = new Thread[nthreads];
        SimIO.print("Dump threads:");
        nthreads = Thread.enumerate(tl);
        for(int i = 0; i < nthreads; i++)
            SimIO.print(" Found thread: " + tl[i] + " isAlive: " + tl[i].isAlive());

    }

    public static void main(String args[])
    {
        AppContainer ac = new AppContainer("test", null, null);
        ac.setVisible(true);
    }

}
