package miiee.util;

import java.applet.*;
import java.lang.reflect.*;
import javax.swing.*;
import java.awt.Container;

public abstract class AppletWrapper extends JApplet {
    protected AppletKernel  _kernel;
    private boolean _debug = false;

	//  Generic parameters
	    
    public String _Mode;
    public String _Name;
    public String _ParameterPrefix;
	public int _Port = 10776;
    
    public  abstract AppletKernel  initializeKernel();
    public  abstract void  startSocketListener();
     
    public void start() { 
	  if( _kernel != null ) { 
		_kernel.start(); 
	  }
	}

    public void stop() { 
	   if( _kernel != null ) { 
		 _kernel.stop(); 
	  }
	}

    public void init() {
    
	  readParameters();
	  
	  try { 
		if ( _Mode.equals("demo") ) { 
		  _kernel = initializeKernel();

		  try { 
			_kernel.init(); 
			setContentPane( _kernel.getContentPane() );
			_kernel.initDemo(); 
		  } catch ( NullPointerException err ) {
			SimIO.print( " Kernel undefined " ); 
			return;
		  }

		} else if ( _Mode.equals("socket") ) { 

		  startSocketListener();
		
		}
	  } catch ( NullPointerException err ) {
		SimIO.print( " No Mode defined " ); 
	  }	  
	}

    public void destroy() { 
	  if( _kernel != null ) { _kernel.destroy(); }
	  _kernel = null;
	  super.destroy();
	}

    public void setFrame( JFrame f ) {;}
    
    public Container getContentPane() { 
	  return ( _kernel != null ) ? _kernel.getContentPane() : null; 
	}

    void readParameters() {
        Class metaclass = getClass();
        Field[] fields = metaclass.getFields();  
        String param = null;  
        if( _debug ) { SimIO.print( "Read Parameters, " + fields.length + " public fields" ); }

        for (int i = 0; i < fields.length; i++) {
            try {
                param = getParameter( fields[i].getName() );
                
                if( _debug ) { 
				  String result = (param == null) ? " -> not found" : " -> found";
				  SimIO.print( "Checking Parameter: " + fields[i].getName() + result ); 
				}

                if ( param == null ||  Modifier.isFinal(fields[i].getModifiers()) ||                
                    ((_ParameterPrefix != null) &&  !fields[i].getName().startsWith(_ParameterPrefix))
                   )                
                   continue;            

                Class fieldType = fields[i].getType();

                if (fieldType.equals(boolean.class)) {
                    fields[i].setBoolean(this, Boolean.valueOf(param).booleanValue());
                }

                else if (fieldType.equals(byte.class)) {
                    fields[i].setByte(this, Byte.valueOf(param).byteValue());
                }

                else if (fieldType.equals(char.class)) {
                    fields[i].setChar(this, param.charAt(0));
                }

                else if (fieldType.equals(double.class)) {
                    fields[i].setDouble(this, Double.valueOf(param).doubleValue());
                }

                else if (fieldType.equals(float.class)) {
                    fields[i].setFloat(this, Float.valueOf(param).floatValue());
                }

                else if (fieldType.equals(int.class)) {
                    fields[i].setInt(this, Integer.valueOf(param).intValue());
                }

                else if (fieldType.equals(long.class)) {
                    fields[i].setLong(this, Long.valueOf(param).longValue());
                }

                else if (fieldType.equals(short.class)) {
                    fields[i].setShort(this, Short.valueOf(param).shortValue());
                }
 
                else if (fieldType.equals(String.class)) {
                    fields[i].set(this, param);
                }
            }
            catch (Exception e) {
                System.err.println(e + " while initializing " + fields[i]);
            }
        }
    }    
}
