
package miiee.util;

import java.awt.*;
import java.awt.Dimension;
import javax.swing.*;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class AttributeValuePair extends JPanel
    implements KeyListener
{

    public AttributeValuePair(String attribute)
    {
        super();
        _listeners = new Vector(3);
        _attribute = attribute;
    }

    void init(boolean isEditable, int min_text_size)
    {
        setLayout(new FlowLayout());
        _label = new JLabel(_attribute, 0);
        add(_label);
        _value = new JTextField(min_text_size);
        _value.setEditable(isEditable);
        _label.setLabelFor(_value);
        if(isEditable) _value.addKeyListener(this);
        add(_value);
		_label.setHorizontalAlignment(_label.CENTER);
		_label.setVerticalAlignment(_label.BOTTOM);
        _label.setVerticalTextPosition(_label.BOTTOM);
        _label.setHorizontalTextPosition(_label.CENTER);
//        label.setFont(swing.boldFont);
//        label.setForeground(Color.red);
    }

	public void SetFont( Font f ) {
	  _value.setFont( f );
	  _label.setFont( f );
	}
	
	public void refresh() {
	  _value.repaint();
	}
	
	public void refreshImmediately() {
	  _value.paintImmediately(_value.getBounds());
	}
	
	public void SetMaximumSize( Dimension d ) {    
	  super.setMaximumSize( d );
	  _value.setMaximumSize( d );
	  _label.setMaximumSize( d );
	}
	
    public void setValue(String value)
    {
        _value.setText(value);
    }

    public String getValue()
    {
        return _value.getText();
    }
    
    public String toString() { return _value.getText(); }

    public static AttributeValuePair New(String attribute, boolean isEditable, int min_text_size)
    {
        AttributeValuePair avp = new AttributeValuePair(attribute);
        avp.init(isEditable, min_text_size);
        return avp;
    }

    public void keyTyped(KeyEvent e)
    {
        char kc = e.getKeyChar();
        if(kc == '\n' && !_listeners.isEmpty()) notifyTextInput(_value.getText());
    }

    public void keyPressed(KeyEvent keyevent)
    {
    }

    public void keyReleased(KeyEvent keyevent)
    {
    }

    protected void notifyTextInput(String text)
    {
        DataDisplayEvent dde = new DataDisplayEvent( this, text );
        Vector l;
        synchronized(this) 
        {
            l = (Vector)_listeners.clone();
        }
        for(int i = 0; i < l.size(); i++)
            ((DataDisplayListener)l.elementAt(i)).textInput(dde);

    }

    public synchronized void addDataDisplayListener( DataDisplayListener tl )
    {
        _listeners.addElement(tl);
    }

    public synchronized void removeDataDisplayListener( DataDisplayListener tl )
    {
        _listeners.removeElement(tl);
    }

    protected String _attribute;
    protected JTextField _value;
    protected Vector _listeners;
    protected JLabel _label;
}
