package miiee.util;

import java.math.BigInteger;

//---- ByteBuffer ---------------------------------------------------------

public class ByteBuffer extends Object {

  byte[] _buffer;
  int _buff_resize_inc = 256;
  int _buff_index = 0;

  public ByteBuffer( int initial_size, int size_inc ) {
	_buffer = new byte[initial_size];
	_buff_resize_inc = size_inc;
  }

  public ByteBuffer() {
	_buffer = new byte[ 256 ];
  }
  
  public void resizeBuffer(int size) {
	  if( _buffer.length <= size ) {
		 byte[] new_buff = new byte[ size + _buff_resize_inc ]; 
		 System.arraycopy(_buffer, 0, new_buff, 0, _buffer.length );
		 _buffer = new_buff;
	  }
  }
  
  public void clear() { _buff_index = 0; }
  
  public void add( byte b ) {
	resizeBuffer(_buff_index);
	_buffer[ _buff_index++ ] =  b;
  }
  
  public byte get( int index ) { 
	return _buffer[ index ];
  } 
  
  public int size() { return _buff_index; }
  
  public byte[] getData() { return _buffer; }
  
  public byte[] getByteArray( int offset ) {   // copies from offset (inclusive) to end of data into new array
	int size = _buff_index - offset;
	if( size <= 0 ) return null;
	byte[] new_buff =  new byte[size];
	System.arraycopy(_buffer, offset, new_buff, 0, size );
	return new_buff; 
  }

  public byte[] getByteArray( int offset, int end ) {   // copies from offset (inclusive) to end (exclusive) into new array
	if( end > _buff_index ) { end = _buff_index; }      // copy region truncated at end of data.
	int size = end - offset;
	if( size <= 0 ) return null;
	byte[] new_buff =  new byte[size];
	System.arraycopy(_buffer, offset, new_buff, 0, size );
	return new_buff; 
  }
  
  public String getString() {
	return new String(_buffer,0,_buff_index);
  }

  public String getString( int offset, int end ) {
	if( end > _buff_index ) { end = _buff_index; }      // copy region truncated at end of data.
	if( end <= offset ) return null;
	return new String( _buffer, offset, end - offset );
  }

  public String getString( int offset ) {
	if( _buff_index <= offset ) return null;
	return new String( _buffer, offset, _buff_index - offset );
  }
 
  public int compare ( byte[] arg ) {
	return compare ( arg, 0 );
  } 
  
  public int compare ( byte[] arg, int offset ) {
    byte[] rv = getByteArray( offset, offset + arg.length );
    BigInteger i = new BigInteger(rv);
    BigInteger j = new BigInteger(arg);
	return i.compareTo(j);
  } 
        
}
