/*
This class was borrowed from VisAD (http://www.ssec.wisc.edu/~billh/visad.html).  
Thanks, Bill;  Great work!
*/

package miiee.util;

import java.util.*;
import java.io.Serializable;

/** 
 * An event to be dispatched when the color widget has been changed
 *
 * @author Nick Rasmussen nick@cae.wisc.edu
 * @version $Revision: 1.1 $, $Date: 1999/09/13 20:38:29 $
 * @since Visad Utility Library, 0.5
 */

public class ColorChangeEvent extends EventObject implements Serializable {

	/** The starting location where the ColorMap has changed */
	private float start;
	/** The ending location where the ColorMap has changed */
	private float end;

	/** Construct a colorChangeEvent object to notify any ColorChangeListeners 
	 * @param object the map that generated the event
	 * @param start the start of the region of the map that has been modified
	 * @param end the end of the region of the map that has been modified
	 */
	public ColorChangeEvent(Object source, float start, float end) {
		super(source);
		this.start = start;
		this.end = end;
	}
	
	/** Get the start of the modified region of the map */
	public float getStart() {
		return start;
	}
	
	/** Get the end of the modified region of the map */
	public float getEnd() {
		return end;
	}
	
	/** Return a string representation of this object */
	public String toString() {
		return new String("Change: from " + start + " to " + end);
	}
}
