/*
This class was borrowed from VisAD (http://www.ssec.wisc.edu/~billh/visad.html).  
Thanks, Bill;  Great work!
*/

package miiee.util;

import java.awt.*;
import javax.swing.*;
import java.util.Vector;
import java.io.*;

/** 
 * The abstract class that all color-mapping widgets must extend.  This 
 * class manages all of the listener notification for the ColorMaps.
 *
 * @author Nick Rasmussen nick@cae.wisc.edu
 * @version $Revision 1.7 $, $Date: 1999/09/13 20:38:30 $
 * @since Visad Utility Library, 0.5
 */

public abstract class ColorMap extends JPanel {

	int _type = -1;	
	public static final int RGB_MAP = 0;
	public static final int RGBA_MAP = 1;
	
	/** Maps a floating point value (in the range 0 to 1) onto a Color, 
	 * returns Color.black if the number is out of range
	 */
	public Color getColor(float value) {
		if (value < 0 || value > 1) {
			return Color.black;
		}
		
		float[] rgb = getRGBTuple(value);
		
		if (rgb[0] < 0) rgb[0] = 0;
		if (rgb[1] < 0) rgb[1] = 0;
		if (rgb[2] < 0) rgb[2] = 0;
		if (rgb[0] > 1) rgb[0] = 1;
		if (rgb[1] > 1) rgb[1] = 1;
		if (rgb[2] > 1) rgb[2] = 1;
		
		return new Color(rgb[0], rgb[1], rgb[2]);
	}
	
	/** Maps a floating point value (in the range 0 to 1) onto an RGB
	 * triplet of floating point numbers in the range 0 to 1)
	 */
	public abstract float[] getRGBTuple(float value);
	
	public abstract int getRGB(float value);
	
	/** Maps a floating point value (in the range 0 to 1) into a tuple
	 * with dimension of the map */
	public abstract float[] getTuple(float value);
	
	/** Returns the current map resolution */
	public abstract int getMapResolution();
	
	/** Returns the dimension of the map */
	public abstract int getMapDimension();
	
	/** Returns a copy of the ColorMap */
	public abstract float[][] getColorMap();
	
	/** The vector containing the ColorChangeListeners */
	private Vector listeners = new Vector();
	
	/** Add a ColorChangeListener to the listeners list */
	public synchronized void addColorChangeListener(ColorChangeListener c) {
		if (!listeners.contains(c)) {
			listeners.addElement(c);
		}
	}
	
	/** Remove a ColorChangeListener from the listeners list */
	public synchronized void removeColorChangeListener(ColorChangeListener c) {
		if (listeners.contains(c)) {
			listeners.removeElement(c);
		}
	}
	
	/** Notify the ColorChangeListerers that the color widget has changed */
	protected synchronized void notifyListeners(ColorChangeEvent e) {
		for (int i = 0; i < listeners.size(); i++) {
			ColorChangeListener c = (ColorChangeListener) listeners.elementAt(i);
			c.colorChanged(e);
		}
	}

	public void write( String file ) throws IOException {
	  FileOutputStream os = new FileOutputStream( file );
	  write( os );
	  os.close();
	}
	
	public abstract void write( FileOutputStream out ) throws IOException ;

	public void read( FileInputStream in ) throws IOException  {
	  ObjectInputStream is = new ObjectInputStream(in);
	  byte type = is.readByte();
	  if( type != _type ) { 
	    SimIO.show_error( null, "Wrong ColorMap type." );
	    return;
	  }
	  try {
		setValues( (float[][]) is.readObject() );
	  } catch( ClassNotFoundException err ) {
	    System.out.println( err.getMessage() );
	  }    
	}
	
	public static ColorMap getMap( FileInputStream in ) throws IOException  {
	  ObjectInputStream is = new ObjectInputStream(in);
	  byte type = is.readByte();
	  try {
	    float[][] val = (float[][]) is.readObject();
	    switch( type) {
		case RGB_MAP: return new RGBMap(val);
		case RGBA_MAP: return new RGBAMap(val);
	    }
	  } catch( ClassNotFoundException err ) {
	    System.out.println( err.getMessage() );
	  }
	  return null;       
	}
	
	public int getType() { return _type; }	

	public abstract	void setValues( float[][] data );

}

