package miiee.util;
import java.io.*;

//---- DataEntry ---------------------------------------------------------

public	class  DataEntry extends Object implements Serializable {
	  private String _info;
	  private float _max;
	  private float _min;
	  private float _time;
	  private float _dt = 0.0f;
	  private final static float _short_max = 256*256;
	  private final static float _max_val = 256*256-2;
	  private short[] _data;
	  private float[] _scaled_data;
	  private float[] _normalized_data;
	  private byte _format = 0;
	  private DataSet _ds;

	  public DataEntry( short[] data, String info, float max, float min, float time )  {
		  _data= data; 
		  _info= info; 
		  _time = time;
		  _max = max;
		  _min = min;
	  }

	  public DataEntry( short[] data, String info, float max, float min, float time, float dt )  {
		  _data= data; 
		  _info= info; 
		  _time = time;
		  _max = max;
		  _min = min;
		  _dt = dt;
	  }

	  public DataEntry( float[] data, String info, byte format, float max, float min, float time )  {
		  _scaled_data= data; 
		  _info= info; 
		  _format = format;
		  _max = max;
		  _min = min;
		  _time = time;
	  }

	  public String toString() {
		return _info;
	  }

	  public void setInfo( String info ) { _info = info; }	  
	  public void setFormat( byte format ) { _format = format; }	  
	  public byte getFormat() { return _format; }	  
	  public int dataSize() { 
		  if( _data != null ) return _data.length; 
		  if( _scaled_data != null ) return _scaled_data.length;
		  return 0;  
	  }
	  public short[] getData() { return _data; }
	  public float[] getScaledData() { return _scaled_data; }
	  public boolean hasData() { return ( ( _data != null ) || (_scaled_data != null) ); }
	  public float max() { return _max; }
	  public float min() { return _min; }
	  public float time() { return _time; }
	  public float dt() { return _dt; }
	  public void setDataSet(DataSet d) { _ds = d; }
	  public DataSet getDataSet() { return _ds; }
	  
	 public  float getValue(int i) {
		if( _scaled_data == null ) { 
		  if( _data[i] == 0 ) { return Float.MAX_VALUE; }
		  float val = ( _data[i] < 0 ) ? _short_max + _data[i] : _data[i];
  //		SimIO.print("DataEntry Getting value(" + i + "): " + val + " -> " + _data[i] + " ( " + _max + " , " + _min + " ) "  );
		  return _min + ( (val-1)/_max_val )*( _max - _min );
		} else {
		  return _scaled_data[i];
		}
	  }

	 public  float getValue(int i0, int i1, int i2 ) {  
		int i = _ds.getArrayIndex(i0, i1, i2 );
		if( _scaled_data == null ) { 
		  if( _data[i] == 0 ) { return Float.MAX_VALUE; }
		  float val = ( _data[i] < 0 ) ? _short_max + _data[i] : _data[i];
  //		SimIO.print("DataEntry Getting value(" + i + "): " + val + " -> " + _data[i] + " ( " + _max + " , " + _min + " ) "  );
		  return _min + ( (val-1)/_max_val )*( _max - _min );
		} else {
		  return _scaled_data[i];
		}
	  }

	 public float getSourceValue(int i) {
		if( _scaled_data == null ) { 
		  return (float) ( ( _data[i] < 0 ) ? _short_max + _data[i] : _data[i] );
		} else {
		  return _scaled_data[i];
		}
	  }

	 public  void setValue( int i, float fval ) { 
	   if( _data == null ) {
		 if( i >= _scaled_data.length ) {;}
		 _scaled_data[i] = fval;
		 if(fval>_max) _max = fval;
		 if(fval<_min) _min = fval;
	   } else { 
		 if( _data.length == 1 ) {
		   _data[0] = (short)-1; _max = fval;
		 } 
		 else if( (fval>_max) || (fval<_min) ) { ; }
		 else {
		   float norm_val = 1 + (_max_val*(fval-_min))/( _max - _min );
		   _data[i] = (short)( ( norm_val > Short.MAX_VALUE ) ? norm_val - _short_max : norm_val); 
  //		 SimIO.print("DataEntry Setting value(" + i + "): " + fval + " -> " + _data[i] );
		  }
		}
	  }

	 public  float[] getValues() {
		if( _scaled_data == null ) { 
		  _scaled_data = new float[ _data.length ];
		  float val, s = ( _max - _min )/_max_val;
		  for( int i=0; i<_data.length; i++ ) {
			if( _data[i] == 0 ) { _scaled_data[i] = Float.MAX_VALUE; }
			else {
			  val = ( _data[i] < 0 ) ? _short_max + _data[i] : _data[i];
			  _scaled_data[i] =  _min + (val-1)*s;
			}
		  }
		}
		return _scaled_data;
	  }

	 public  float[] getNormalizedValues() {
		if( _normalized_data == null ) { 
		  _normalized_data = new float[ _data.length ];
		  float val, s = 1.0f/_max_val;
		  for( int i=0; i<_data.length; i++ ) {
			if( _data[i] == 0 ) { _scaled_data[i] = Float.MAX_VALUE; }
			else {
			  val = ( _data[i] < 0 ) ? _short_max + _data[i] : _data[i];
			  _normalized_data[i] =  (val-1)*s;
			}
		  }
		}
		return _normalized_data;
	  }

	 public  float getNormalizedValue( int i, float gmax, float gmin ) {
		if( _data[i] == 0 ) { return Float.MAX_VALUE; }
		float val = ( _data[i] < 0 ) ? _short_max + _data[i] : _data[i];
		return  ( ((( _max - _min ) * (val-1) ) / _max_val ) + (_min-gmin) ) / ( gmax - gmin );
	 }
	 

}
