package miiee.util;

import java.io.*;
import miiee.xml.*;

public class DirectoryCreator {
	
   File _targetDir;
   boolean _valid = true;
   
   public DirectoryCreator( File f ) {
	 _targetDir = f;
   }
   
   public boolean execute() { return create(_targetDir); }
   
   boolean create( File f ) {
	 File parent = f.getParentFile();
	 if( parent == null ) {
	   directory_creation_error("Parent does not exist: " + f.getPath() ); 
	 } else {
	   if( !parent.isDirectory() ) {
		 create(parent);
	   }
	   if( _valid ) {
		 ScriptExecutable ex = new ScriptExecutable( false ) {
			public void errorCallback( int returnValue, String stdout, String stderr ) {
			  if( returnValue != 0 ) { directory_creation_error( stderr + " : " + stdout ); }	
			}   
		 };
		 String script = "mkdir " + parent.getPath() + "/" + f.getName();
		 ex.execute( script, null );
	   }
	 }
	 return _valid;
   }

   void directory_creation_error(String messsage) {
	  System.out.println( "Directory creation error: " + messsage );
	  _valid = false;
   }
}

