package miiee.util;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.border.*;
import javax.swing.*;

//---- DocEditor ---------------------------------------------------------

public class DocEditor {

	AttributeValuePair _Label = AttributeValuePair.New( "Title:", true, 32 );	
	JTextArea  _Text = new JTextArea("", 25, 25);
 		
	public DocEditor( String label, String text ) {
	  if( label != null ) { _Label.setValue(label); }
	  if( text != null ) { _Text.setText(text); }
	  _Text.setEditable(true);
	}
	
	public String getLabel() { return _Label.getValue(); }
	public String getText() { return _Text.getText(); }
	
	public boolean show( String msg ) {	
	  JPanel mainPanel = new JPanel(false);
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	  Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );
	  _Label.setBorder(bb);
	  mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
	  JScrollPane textPane = new JScrollPane(_Text);
	  textPane.setBorder(new BevelBorder(BevelBorder.LOWERED));
	  JLabel doc_pane_label = new JLabel("Documentation:");

	  mainPanel.add(_Label);
	  mainPanel.add(doc_pane_label);
	  mainPanel.add(textPane);

	  Object[] options = { "Set", "Cancel" };      
	  int response = JOptionPane.showOptionDialog(null, mainPanel, msg, 
					JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                  null, options, options[0]);
	  return ( response == 0 );
	}		

}
