package miiee.util;

import java.lang.reflect.*;
import java.util.HashMap;
import java.util.StringTokenizer;
import miiee.mml.MMLException;

//---- VisadStubs ---------------------------------------------------------

public class ExternalClassStub {

 // name of stubbed class 
  private String _externalClassName;

  // stubbed class 
  private Class _externalClass;
    
  boolean _debug = true;
  HashMap _methods = new HashMap();
  HashMap _declarations = new HashMap();
  
  Object _instance;
  
  public ExternalClassStub( String className ) {
	_externalClassName = className;
	_externalClass = constructExternalClass();
  }
  
  public Method addMethod(String id, String declaration) throws MMLException {
	String decl = _externalClassName + "." + declaration;
	Method m = stringToMethod(decl);
	if (m == null) throw new MMLException("Method not found: " + decl );
	_methods.put(id,m); 
	_declarations.put(id,decl);
	return m;
  }
  
  private void instantiate() throws MMLException {
	if( _instance == null ) {
	  try {
		_instance = _externalClass.newInstance();
	  }
	  catch (NullPointerException exc) {
		if (_debug) exc.printStackTrace();
	  }
	  catch (IllegalAccessException exc) {
		if (_debug) exc.printStackTrace();
	  }
	  catch (InstantiationException exc) {
		if (_debug) exc.printStackTrace();
	  }
	  if ( _instance == null ) throw new MMLException("External class not found: " + _externalClassName);
	}
  }


  private Class constructExternalClass() {
    Class c = null;
    try {
      c = Class.forName(_externalClassName);
    }
    catch (ClassNotFoundException exc) {
      if (_debug) exc.printStackTrace();
    }
    return c;
  }

  public Object execMethod( String method_id, Object[] args ) throws MMLException {
	instantiate();
	Method m = (Method) _methods.get(method_id);
	Object o = null;
	if ( m == null ) throw new MMLException("Unrecognized method: " + method_id + " for class " + _externalClassName );
    try {
      o = m.invoke(_instance, args );
    }
    catch (IllegalAccessException exc) {
	  if (_debug) exc.printStackTrace();
      throw new MMLException(exc.toString());
    }
    catch (IllegalArgumentException exc) {
	  if (_debug) exc.printStackTrace();
      throw new MMLException(exc.toString());
    }
    catch (InvocationTargetException exc) {
	  if (_debug) exc.printStackTrace();
      throw new MMLException(exc.getTargetException().toString());
    }
    return o;
  }


//	  interp + ".eval(java.lang.String)",
//    interp + ".exec(java.lang.String)",
//    interp + ".execfile(java.lang.String)",
//    interp + ".set(java.lang.String, org.python.core.PyObject)",
//    interp + ".get(java.lang.String)"


  public Method stringToMethod(String declaration) throws MMLException {
	// remove spaces
	if( _debug ) { SimIO.print("parsing declaration: " + declaration ); }
	StringTokenizer t = new StringTokenizer(declaration, " ", false);
	String s = "";
	while (t.hasMoreTokens()) s = s + t.nextToken();

	// separate into two strings
	t = new StringTokenizer(s, "(", false);
	String pre = t.nextToken();
	String post = t.nextToken();

	// separate first string into class and method strings
	t = new StringTokenizer(pre, ".", false);
	String c = t.nextToken();
	int count = t.countTokens();
	for (int i=0; i<count-1; i++) c = c + "." + t.nextToken();
	String m = t.nextToken();

	// get argument array of strings
	t = new StringTokenizer(post, ",)", false);
	count = t.countTokens();
	String[] a;
	if (count == 0) a = null;
	else a = new String[count];
	int x = 0;
	while (t.hasMoreTokens()) a[x++] = t.nextToken();

	// convert result to Method object
	Class clas = null;
	try {
	  clas = Class.forName(c);
	}
	catch (ClassNotFoundException exc) {
		throw new MMLException(" Class " + c + " does not exist!" );
	}
	Class[] param;
	if (a == null) param = null;
	else param = new Class[a.length];
	for (int i=0; i<count; i++) {
	  // hack to convert array arguments to correct form
	  if (a[i].endsWith("[]")) {
		a[i] = "[L" + a[i].substring(0, a[i].length()-2);
		while (a[i].endsWith("[]")) {
		  a[i] = "[" + a[i].substring(0, a[i].length()-2);
		}
		a[i] = a[i] + ";";
	  }

	  try {
		param[i] = Class.forName(a[i]);
	  }
	  catch (ClassNotFoundException exc) {
		throw new MMLException("Class " + a[i] + " does not exist!");
	  }
	}
	Method method = null;
	try {
	  method = clas.getMethod(m, param);
	}
	catch (NoSuchMethodException exc) {
	  throw new MMLException("Method " + m + " does not exist!");
	}
    return method;
  }
}
