// Source file: FormattedFloat.java
// This program is generated by WingDis 2.12, a product from WingSoft
// For more information about WingSoft, please visit http://www.wingsoft.com

package miiee.util;

import java.lang.*;

class  FDBigInt
{
    int nWords;
    int[] data;
    private static boolean debugging;

    static 
    {
    }

    public static void setDebugging(
        boolean d)
    {
        debugging= d; 
    }

    public FDBigInt(
        int v)
    {
        nWords= 1; 
        data= new int[1]; 
        data[0]= ((int)v); 
    }

    public FDBigInt(
        long v)
    {
        data= new int[2]; 
        data[0]= ((int)v); 
        data[1]= ((int)(v >>> 32)); 
        nWords=  (data[1] == 0) ? 1 : 2 ; 
    }

    public FDBigInt(
        FDBigInt other)
    {
        nWords= other.nWords; 
        data= new int[other.nWords]; 
        System.arraycopy(other.data, 0, data, 0, nWords); 
    }

    private FDBigInt(
        int[] d, 
        int n)
    {
        data= d; 
        nWords= n; 
    }

    public void lshiftMe(
        int c) throws IllegalArgumentException
    {
        if (c > 0) 
        {
            int wordcount= c >> 5; 
            int bitcount= c & 0x1f; 
            int anticount= 32 - bitcount; 
            int[] t= data; 
            int[] s= data; 
            if (((nWords + wordcount) + 1) > t.length)
            {
                t= new int[((nWords + wordcount) + 1)]; 
            }
            int target= nWords + wordcount; 
            int src= nWords - 1; 
            if (bitcount != 0)
            {
                t[target--]= ((int)(s[src] >>> anticount)); 
                while (src >= 1)
                {

                    int dup4= (s[src] << bitcount);
                    src--; 
                    t[target--]= ((int)(dup4 | (s[src] >>> anticount))); 
                }

                t[target--]= ((int)(s[src] << bitcount)); 
            }
            else
            {
                System.arraycopy(s, 0, t, wordcount, nWords); 
                target= wordcount - 1; 
            }
            while (target >= 0)
            {
                t[target--]= ((int)0); 
                continue;
            }

            data= t; 
            for (nWords= nWords + (wordcount + 1);  ( !  ( (nWords <= 1) || (data[(nWords - 1)] != 0)) ) ; nWords--)
            {
            }

            return; 
        }
        if (c != 0)
        {
            throw new IllegalArgumentException("negative shift count"); 
        }
    }

    public int normalizeMe() throws IllegalArgumentException
    {
        int wordcount= 0; 
        int bitcount= 0; 
        int v= 0; 
        int src;
        for (src= nWords - 1; (src >= 0); src--)
        {
            v= data[src]; 
            if (v != 0)
            {
                break;
            }
            wordcount++; 
        }

        if (src >= 0)
        {
            nWords= nWords - wordcount; 
            if ((v & 0xf0000000) == 0)
            {
                while (v <= 1048575)
                {
                    v= v << 8; 
                    bitcount += 8; 
                }

                while (v <= 134217727)
                {
                    v= v << 1; 
                    bitcount++; 
                }

            }
            else
            {
                for (bitcount= 32; ((v & 0xf0000000) != 0); bitcount--)
                {
                    v= v >>> 1; 
                }

            }
            if (bitcount != 0)
            {
                lshiftMe(bitcount); 
            }
            return bitcount; 
        }
        throw new IllegalArgumentException("zero value"); 
    }

    public FDBigInt mult(
        int iv)
    {
        long v= (long)iv; 
        int[] r= new int[( (((v * (((long)data[(nWords - 1)]) & 4294967295L)) > 268435455L)) ? (nWords + 1) : nWords )]; 
        long p= (long)0; 
        int i;
        for (i= 0; (i < nWords); i++)
        {
            p= p + (v * (((long)data[i]) & 4294967295L)); 
            r[i]= ((int)p); 
            p= p >>> 32; 
        }

        if ((p != (long)0))
        {
            r[nWords]= ((int)p); 
            return new FDBigInt(r, (nWords + 1)); 
        }
        return new FDBigInt(r, nWords); 
    }

    public FDBigInt mult(
        FDBigInt other)
    {
        long v;
        long p;
        int j;
        int[] r= new int[(nWords + other.nWords)]; 
        int i;
        for (i= 0; (i < nWords); i++)
        {
            v= ((long)data[i]) & 4294967295L; 
            p= (long)0; 
            for (j= 0; (j < other.nWords); j++)
            {
                p= p + ((((long)r[(i + j)]) & 4294967295L) + (v * (((long)other.data[j]) & 4294967295L))); 
                r[(i + j)]= ((int)p); 
                p= p >>> 32; 
            }

            r[(i + j)]= ((int)p); 
        }

        for (i= r.length - 1;  ( !  (  ! (i > 0)  || (r[i] != 0)) ) ; i--)
        {
        }

        return new FDBigInt(r, (i + 1)); 
    }

    public FDBigInt add(
        FDBigInt other)
    {
        int[] a;
        int n;
        int[] b;
        int m;
        long c= (long)0; 
        if (nWords < other.nWords)
        {
            a= other.data; 
            n= other.nWords; 
            b= data; 
            m= nWords; 
        }
        else
        {
            a= data; 
            n= nWords; 
            b= other.data; 
            m= other.nWords; 
        }
        int[] r= new int[n]; 
        int i;
        for (i= 0; (i < n); i++)
        {
            c= c + (((long)a[i]) & 4294967295L); 
            if (i < m)
            {
                c= c + (((long)b[i]) & 4294967295L); 
            }
            r[i]= ((int)c); 
            c= c >> 32; 
        }

        if ((c == (long)0))
        {
            return new FDBigInt(r, i); 
        }
        int[] s= new int[(r.length + 1)]; 
        System.arraycopy(r, 0, s, 0, r.length); 
        s[i++]= ((int)c); 
        return new FDBigInt(s, i); 
    }

    public FDBigInt sub(
        FDBigInt other)
    {
        int[] r= new int[nWords]; 
        int n= nWords; 
        int m= other.nWords; 
        int nzeros= 0; 
        long c= (long)0; 
        int i;
        for (i= 0; (i < n); i++)
        {
            c= c + (((long)data[i]) & 4294967295L); 
            if (i < m)
            {
                c= c - (((long)other.data[i]) & 4294967295L); 
            }
            int dup5= ((int)c);
            r[i]= ((int)dup5); 
            if (dup5 != 0)
            {
                nzeros= 0; 
            }
            else
            {
                nzeros++; 
            }
            c= c >> 32; 
        }

        if ((c != (long)0))
        {
            throw new RuntimeException("Assertion botch: borrow out of subtract"); 
        }
        while (i < m)
        {
            if (other.data[i++] != 0)
            {
                throw new RuntimeException("Assertion botch: negative result of subtract"); 
            }
        }

        return new FDBigInt(r, (n - nzeros)); 
    }

    public int cmp(
        FDBigInt other)
    {
        int j;
        int i;
        if (nWords <= other.nWords)
        {
            if (nWords >= other.nWords)
            {
                i= nWords - 1; 
            }
            else
            {
                j= nWords - 1; 
                for (i= other.nWords - 1; (i > j); i--)
                {
                    if (other.data[i] != 0)
                    {
                        return -1; 
                    }
                }

            }
        }
        else
        {
            j= other.nWords - 1; 
            for (i= nWords - 1; (i > j); i--)
            {
                if (data[i] != 0)
                {
                    return 1; 
                }
            }

        }
        while (true)
        {
            if (i <= 0){
                break;
            }
            if (data[i] != other.data[i]){
                break;
            }
            i--; 
            continue;
        }

        j= data[i]; 
        int b= other.data[i]; 
        if (j >= 0)
        {
            if (b >= 0)
            {
                return (j - b); 
            }
            return -1; 
        }
        if (b >= 0)
        {
            return 1; 
        }
        return (j - b); 
    }

    public int quoRemIteration(
        FDBigInt S) throws IllegalArgumentException
    {
        long sum;
        int i1;
        if (nWords == S.nWords)
        {
            int n= nWords - 1; 
            long q= (((long)data[n]) & 4294967295L) / ((long)S.data[n]); 
            long diff= (long)0; 
            int i;
            for (i= 0; (i <= n); i++)
            {
                diff= diff + ((((long)data[i]) & 4294967295L) - (q * (((long)S.data[i]) & 4294967295L))); 
                data[i]= ((int)diff); 
                diff= diff >> 32; 
            }

            if ((diff != (long)0))
            {
                for (sum= (long)0; ((sum == (long)0)); q--)
                {
                    sum= (long)0; 
                    for (i1= 0; (i1 <= n); i1++)
                    {
                        sum= sum + ((((long)data[i1]) & 4294967295L) + (((long)S.data[i1]) & 4294967295L)); 
                        data[i1]= ((int)sum); 
                        sum= sum >> 32; 
                    }

                    if ((sum == (long)0))
                    {
                        continue;
                    }
                    if ((sum != (long)1))
                    {
                        throw new RuntimeException("Assertion botch: " + sum + " carry out of division correction"); 
                    }
                }

            }
            sum= (long)0; 
            for (i1= 0; (i1 <= n); i1++)
            {
                sum= sum + (10L * (((long)data[i1]) & 4294967295L)); 
                data[i1]= ((int)sum); 
                sum= sum >> 32; 
            }

            if ((sum == (long)0))
            {
                return ((int)q); 
            }
            throw new RuntimeException("Assertion botch: carry out of *10"); 
        }
        throw new IllegalArgumentException("disparate values"); 
    }

    public long longValue()
    {
        int i;
        for (i= nWords - 1; (i > 1); i--)
        {
            if (data[i] != 0)
            {
                throw new RuntimeException("Assertion botch: value too big"); 
            }
        }

        switch (i)
        {

            default:
                break;

            case 0:
                return (((long)data[0]) & 4294967295L); 

            case 1:
                if (data[1] >= 0)
                {
                    return ((((long)data[1]) << 32) | (((long)data[0]) & 4294967295L)); 
                }
                throw new RuntimeException("Assertion botch: value too big"); 
        }
        throw new RuntimeException("Assertion botch: longValue confused"); 
    }

    public String toString()
    {
        StringBuffer r= new StringBuffer(30); 
        r.append(((char)91)); 
        int i= Math.min((nWords - 1), (data.length - 1)); 
        if (nWords > data.length)
        {
            r.append("(" + data.length + "<" + nWords + "!)"); 
        }
        for (; (i > 0) ; i--)
        {
            r.append(Integer.toHexString(data[i])); 
            r.append(((char)32)); 
            continue;
        }

        r.append(Integer.toHexString(data[0])); 
        r.append(((char)93)); 
        return new String(r); 
    }
}

