// Source file: FormattedFloat.java
// This program is generated by WingDis 2.12, a product from WingSoft
// For more information about WingSoft, please visit http://www.wingsoft.com

package miiee.util;

import java.lang.*;

public class  FormattedFloat
{
    boolean isExceptional;
    boolean isNegative;
    boolean isINF = false;
    boolean isNaN = false;
    boolean _round = false;
    int decExponent;
    char[] digits;
    int nDigits;
    int fixedDigits = -1;
    static final long signMask= -9223372036854775808l;
    static final long expMask= 9218868437227405312l;
    static final long fractMask= 4503599627370495l;
    static final int expShift= 52;
    static final int expBias= 1023;
    static final long fractHOB= 4503599627370496l;
    static final long expOne= 4607182418800017408l;
    static final int maxSmallBinExp= 62;
    static final int minSmallBinExp= -21;
    static final long highbyte= -72057594037927936l;
    static final long highbit= -9223372036854775808l;
    static final long lowbytes= 72057594037927935l;
    static final int singleSignMask= -2147483648;
    static final int singleExpMask= 2139095040;
    static final int singleFractMask= 8388607;
    static final int singleExpShift= 23;
    static final int singleFractHOB= 8388608;
    static final int singleExpBias= 127;
    private static FDBigInt[] b5p;

    private static final int[] small5pow= {
        1,
        5,
        25,
        125,
        625,
        3125,
        15625,
        78125,
        390625,
        1953125,
        9765625,
        48828125,
        244140625,
        1220703125,
        };
     private static final long[] long5pow= {
        (long)1,
        5L,
        25L,
        125L,
        625L,
        3125L,
        15625L,
        78125L,
        390625L,
        1953125L,
        9765625L,
        48828125L,
        244140625L,
        1220703125L,
        6103515625L,
        30517578125L,
        152587890625L,
        762939453125L,
        3814697265625L,
        19073486328125L,
        95367431640625L,
        476837158203125L,
        2384185791015625L,
        11920928955078125L,
        59604644775390625L,
        298023223876953125L,
        1490116119384765625L,
        };
     private static final int[] n5bits= {
        0,
        3,
        5,
        7,
        10,
        12,
        14,
        17,
        19,
        21,
        24,
        26,
        28,
        31,
        33,
        35,
        38,
        40,
        42,
        45,
        47,
        49,
        52,
        54,
        56,
        59,
        61,
        };
    private static final char[] infinity= {
        73,
        110,
        102,
        105,
        110,
        105,
        116,
        121,
        };
     private static final char[] notANumber= {
        78,
        97,
        78,
        };
     private static final char[] zero= {
        48,
        48,
        48,
        48,
        48,
        48,
        48,
        48,
        };

    public FormattedFloat(
        boolean negSign, 
        int decExponent2, 
        char[] digits3, 
        int n, 
        boolean e)
    {
        isNegative= negSign; 
        isExceptional= e; 
        decExponent= decExponent2; 
        digits= digits3; 
        nDigits= n; 
    }

    private static int countBits(
        long v)
    {
        if ((v != (long)0))
        {
            while (((v & -72057594037927936L) == (long)0))
            {
                v= v << 8; 
            }

            while ((v > (long)0))
            {
                v= v << 1; 
            }

            int n;
            for (n= 0; (((v & 72057594037927935L) != (long)0)); n += 8)
            {
                v= v << 8; 
            }

            while ((v != (long)0))
            {
                v= v << 1; 
                n++; 
            }

            return n; 
        }
        return 0; 
    }

    private static FDBigInt big5pow(
        int p)
    {
        if (p >= 0)
        {
            if (b5p == null) 
            {
                b5p= new FDBigInt[(p + 1)]; 
            }
            else if (b5p.length <= p)
            {
                FDBigInt[] t= new FDBigInt[(p + 1)]; 
                System.arraycopy(b5p, 0, t, 0, b5p.length); 
                b5p= t; 
            }
            if (b5p[p] == null) 
            {
                if (p >= small5pow.length)
                {
                    if (p >= long5pow.length)
                    {
                        int q= p >> 1; 
                        int r= p - q; 
                        FDBigInt bigq= b5p[q]; 
                        if (bigq == null) 
                        {
                            bigq= big5pow(q); 
                        }
                        if (r >= small5pow.length)
                        {
                            FDBigInt bigr= b5p[r]; 
                            if (bigr == null) 
                            {
                                bigr= big5pow(r); 
                            }
                            FDBigInt dup0= bigq.mult(bigr);
                            b5p[p]= dup0; 
                            return dup0; 
                        }
                        FDBigInt dup1= bigq.mult(small5pow[r]);
                        b5p[p]= dup1; 
                        return dup1; 
                    }
                    FDBigInt dup2= new FDBigInt(long5pow[p]);
                    b5p[p]= dup2; 
                    return dup2; 
                }
                FDBigInt dup3= new FDBigInt(small5pow[p]);
                b5p[p]= dup3; 
                return dup3; 
            }
            return b5p[p]; 
        }
        throw new RuntimeException("Assertion botch: negative power of 5"); 
    }

    private void developLongDigits(
        int decExponent1, 
        long lvalue, 
        long insignificant)
    {
        int ndigits;
        char[] digits6;
        int digitno;
        int c;
        char[] result;
        int i;
        for (i= 0; ((insignificant >= 10L)); i++)
        {
            insignificant= insignificant / 10L; 
        }

        if (i != 0)
        {
            long pow10= long5pow[i] << i; 
            long residue= lvalue % pow10; 
            lvalue= lvalue / pow10; 
            decExponent1= decExponent1 + i; 
            if ((residue >= (pow10 >> 1)))
            {
                lvalue++; 
            }
        }
        if ((lvalue > 2147483647L))
        {
            ndigits= 20; 
            digits6= new char[20]; 
            digitno= ndigits - 1; 
            c= (int)(lvalue % 10L); 
            for (lvalue= lvalue / 10L; (c == 0); lvalue= lvalue / 10L)
            {
                decExponent1++; 
                c= (int)(lvalue % 10L); 
            }

            while ((lvalue != (long)0))
            {
                digits6[digitno--]= ((char)(c + 48)); 
                decExponent1++; 
                c= (int)(lvalue % 10L); 
                lvalue= lvalue / 10L; 
            }

            digits6[digitno]= ((char)(c + 48)); 
        }
        else
        {
            if ((lvalue <= (long)0))
            {
                throw new RuntimeException("Assertion botch: value " + lvalue + " <= 0"); 
            }
            int ivalue= (int)lvalue; 
            ndigits= 10; 
            digits6= new char[10]; 
            digitno= ndigits - 1; 
            c= ivalue % 10; 
            for (ivalue= ivalue / 10; (c == 0); ivalue= ivalue / 10)
            {
                decExponent1++; 
                c= ivalue % 10; 
            }

            while (ivalue != 0)
            {
                digits6[digitno--]= ((char)(c + 48)); 
                decExponent1++; 
                c= ivalue % 10; 
                ivalue= ivalue / 10; 
            }

            digits6[digitno]= ((char)(c + 48)); 
        }
        ndigits= ndigits - digitno; 
        if (digitno == 0)
        {
            result= digits6; 
        }
        else
        {
            result= new char[ndigits]; 
            System.arraycopy(digits6, digitno, result, 0, ndigits); 
        }
        digits= result; 
        decExponent= decExponent1 + 1; 
        nDigits= ndigits; 
    }

    private void roundup()
    {
        int i= nDigits - 1; 
        int q= digits[i]; 
        if (q == 57)
        {
            while (true)
            {
                if (q != 57){
                    break;
                }
                if (i <= 0){
                    break;
                }
                digits[i]= ((char)48); 
                i--; 
                q= digits[i]; 
            }

            if (q == 57)
            {
                decExponent++; 
                digits[0]= ((char)49); 
                return; 
            }
        }
        digits[i]= ((char)(q + 1)); 
    }

    public FormattedFloat( double d )  {
        int nSignificantBits;
        long dBits= Double.doubleToLongBits(d); 
        if (((dBits & -9223372036854775808L) == (long)0))   {
            isNegative= false; 
        }    else  {
            isNegative= true; 
            dBits= dBits ^ -9223372036854775808L; 
        }
        if( Double.isNaN(d) ) { isNaN = true; return; }
        if( (d == Double.MAX_VALUE)  || Double.isInfinite(d) ) { isINF = true; return; }
        int binExp= (int)((dBits & 9218868437227405312L) >> 52); 
        long fractBits= dBits & 4503599627370495L; 
        if (((short)binExp) != 2047)
        {
            isExceptional= false; 
            if (binExp != 0)
            {
                fractBits= fractBits | 4503599627370496L; 
                nSignificantBits= 53; 
            }
            else
            {
                if ((fractBits == (long)0))
                {
                    decExponent= 0; 
                    digits= zero; 
                    nDigits= 1; 
                    return; 
                }
                while (((fractBits & 4503599627370496L) == (long)0))
                {
                    fractBits= fractBits << 1; 
                    binExp--; 
                }

                nSignificantBits= 52 + binExp; 
                binExp++; 
            }
            binExp= binExp - 1023; 
            dtoa(binExp, fractBits, nSignificantBits); 
            return; 
        }
        isExceptional= true; 
        if ((fractBits == (long)0))
        {
            digits= infinity; 
        }
        else
        {
            digits= notANumber; 
            isNegative= false; 
        }
        nDigits= digits.length; 
    }

    public FormattedFloat(
        float f)
    {
        int nSignificantBits;
        int fBits= Float.floatToIntBits(f); 
        if ((fBits & 0x80000000) == 0)
        {
            isNegative= false; 
        }
        else
        {
            isNegative= true; 
            fBits= fBits ^ -2147483648; 
        }
        
        if( Float.isNaN(f) ) { isNaN = true; return; }
        if( (f == Float.MAX_VALUE)  || Float.isInfinite(f) ) { isINF = true; return; }
        int binExp= (fBits & 0x7f800000) >> 23; 
        int fractBits= fBits & 0x7fffff; 
        if (((short)binExp) != 255)
        {
            isExceptional= false; 
            if (binExp != 0)
            {
                fractBits= fractBits | 0x800000; 
                nSignificantBits= 24; 
            }
            else
            {
                if (fractBits == 0)
                {
                    decExponent= 0; 
                    digits= zero; 
                    nDigits= 1; 
                    return; 
                }
                while ((fractBits & 0x800000) == 0)
                {
                    fractBits= fractBits << 1; 
                    binExp--; 
                }

                nSignificantBits= 23 + binExp; 
                binExp++; 
            }
            binExp += -127; 
            dtoa(binExp, (((long)fractBits) << 29), nSignificantBits); 
            return; 
        }
        isExceptional= true; 
        if ((((long)fractBits) == (long)0))
        {
            digits= infinity; 
        }
        else
        {
            digits= notANumber; 
            isNegative= false; 
        }
        nDigits= digits.length; 
    }
    
	public void setFixedDigits( int nDigits ) { fixedDigits = nDigits; }
	
    private void dtoa(
        int binExp, 
        long fractBits, 
        int nSignificantBits)
    {
        long halfULP;
        int s;
        int q;
        boolean low;
        boolean high;
        long lowDigitDifference;
        int nFractBits= countBits(fractBits); 
        int nTinyBits= Math.max(0, ((nFractBits - binExp) - 1)); 
        if  ( (binExp > 62) ||  ( (binExp < -21) ||  ( (nTinyBits >= long5pow.length) ||  ( ((nFractBits + n5bits[nTinyBits]) >= 64) || (nTinyBits != 0)))))
        {
            double d2= Double.longBitsToDouble((4607182418800017408L | (fractBits & -4503599627370497L))); 
            int decExp= (int)Math.floor(((((d2 - 1.5d) * 0.289529654d) + 0.176091259d) + (((double)binExp) * 0.301029995663981d))); 
            int B5= Math.max(0, (-decExp)); 
            int B2= (B5 + nTinyBits) + binExp; 
            int S5= Math.max(0, decExp); 
            int S2= S5 + nTinyBits; 
            int M5= B5; 
            int M2= B2 - nSignificantBits; 
            fractBits= fractBits >>> (53 - nFractBits); 
            B2= B2 - (nFractBits - 1); 
            int common2factor= Math.min(B2, S2); 
            B2= B2 - common2factor; 
            S2= S2 - common2factor; 
            M2= M2 - common2factor; 
            if (nFractBits == 1)
            {
                M2--; 
            }
            if (M2 < 0)
            {
                B2= B2 - M2; 
                S2= S2 - M2; 
                M2= 0; 
            }
            digits= new char[18]; 
            char[] digits22= new char[18]; 
            int ndigit= 0; 
            int Bbits= (nFractBits + B2) + ( (B5 < n5bits.length) ? n5bits[B5] : (B5 * 3) ); 
            int tenSbits= (S2 + 1) + ( ((S5 + 1) < n5bits.length) ? n5bits[(S5 + 1)] : ((S5 + 1) * 3) ); 
            if  ( (Bbits >= 64) || (tenSbits >= 64))
            {
                FDBigInt Bval= new FDBigInt(fractBits); 
                if (B5 != 0)
                {
                    if (B5 >= small5pow.length)
                    {
                        Bval= Bval.mult(big5pow(B5)); 
                    }
                    else
                    {
                        Bval= Bval.mult(small5pow[B5]); 
                    }
                }
                if (B2 != 0)
                {
                    Bval.lshiftMe(B2); 
                }
                FDBigInt Sval= new FDBigInt(big5pow(S5)); 
                if (S2 != 0)
                {
                    Sval.lshiftMe(S2); 
                }
                FDBigInt Mval= new FDBigInt(big5pow(M5)); 
                if (M2 != 0)
                {
                    Mval.lshiftMe(M2); 
                }
                s= Sval.normalizeMe(); 
                Bval.lshiftMe(s); 
                Mval.lshiftMe(s); 
                FDBigInt tenSval= Sval.mult(10); 
                ndigit= 0; 
                q= Bval.quoRemIteration(Sval); 
                Mval= Mval.mult(10); 
                low= (boolean) ( (Bval.cmp(Mval) < 0) ? true : false ); 
                high= (boolean) ( (Bval.add(Mval).cmp(tenSval) > 0) ? true : false ); 
                if (q >= 10)
                {
                    throw new RuntimeException("Assertion botch: excessivly large digit " + q); 
                }
                if  ( !  ( (q != 0) || (high)) ) 
                {
                    decExp--; 
                }
                else
                {
                    digits22[ndigit++]= ((char)(48 + q)); 
                }
                if  ( (decExp <= -3) || (decExp >= 8))
                {
                    low= false; 
                    high= false; 
                }
                while (true)
                {
                    if (low){
                        break;
                    }
                    if (high){
                        break;
                    }
                    q= Bval.quoRemIteration(Sval); 
                    Mval= Mval.mult(10); 
                    if (q >= 10)
                    {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q); 
                    }
                    low= (boolean) ( (Bval.cmp(Mval) < 0) ? true : false ); 
                    high= (boolean) ( (Bval.add(Mval).cmp(tenSval) > 0) ? true : false ); 
                    digits22[ndigit++]= ((char)(48 + q)); 
                }

                if  ( (high == false) || (low == false))
                {
                    lowDigitDifference= (long)0; 
                }
                else
                {
                    Bval.lshiftMe(1); 
                    lowDigitDifference= (long)Bval.cmp(tenSval); 
                }
            }
            else
            {
                if  ( (Bbits >= 32) || (tenSbits >= 32))
                {
                    long b1= (fractBits * long5pow[B5]) << B2; 
                    long s1= long5pow[S5] << S2; 
                    long m1= long5pow[M5] << M2; 
                    long tens1= s1 * 10L; 
                    ndigit= 0; 
                    q= (int)(b1 / s1); 
                    b1= 10L * (b1 % s1); 
                    m1= m1 * 10L; 
                    low= (boolean) ( ((b1 < m1)) ? true : false ); 
                    high= (boolean) ( (((b1 + m1) > tens1)) ? true : false ); 
                    if (q >= 10)
                    {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q); 
                    }
                    if  ( !  ( (q != 0) || (high)) ) 
                    {
                        decExp--; 
                    }
                    else
                    {
                        digits22[ndigit++]= ((char)(48 + q)); 
                    }
                    if  ( (decExp <= -3) || (decExp >= 8))
                    {
                        low= false; 
                        high= false; 
                    }
                    while (true)
                    {
                        if (low){
                            break;
                        }
                        if (high){
                            break;
                        }
                        q= (int)(b1 / s1); 
                        b1= 10L * (b1 % s1); 
                        m1= m1 * 10L; 
                        if (q >= 10)
                        {
                            throw new RuntimeException("Assertion botch: excessivly large digit " + q); 
                        }
                        if ((m1 <= (long)0))
                        {
                            low= true; 
                            high= true; 
                        }
                        else
                        {
                            low= (boolean) ( ((b1 < m1)) ? true : false ); 
                            high= (boolean) ( (((b1 + m1) > tens1)) ? true : false ); 
                        }
                        digits22[ndigit++]= ((char)(48 + q)); 
                    }

                    lowDigitDifference= (b1 << 1) - tens1; 
                }
                else
                {
                    int b= (((int)fractBits) * small5pow[B5]) << B2; 
                    s= small5pow[S5] << S2; 
                    int m= small5pow[M5] << M2; 
                    int tens= s * 10; 
                    ndigit= 0; 
                    q= b / s; 
                    b= 10 * (b % s); 
                    m= m * 10; 
                    low= (boolean) ( (b < m) ? true : false ); 
                    high= (boolean) ( ((b + m) > tens) ? true : false ); 
                    if (q >= 10)
                    {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q); 
                    }
                    if  ( !  ( (q != 0) || (high)) ) 
                    {
                        decExp--; 
                    }
                    else
                    {
                        digits22[ndigit++]= ((char)(48 + q)); 
                    }
                    if  ( (decExp <= -3) || (decExp >= 8))
                    {
                        low= false; 
                        high= false; 
                    }
                    while (true)
                    {
                        if (low){
                            break;
                        }
                        if (high){
                            break;
                        }
                        q= b / s; 
                        b= 10 * (b % s); 
                        m= m * 10; 
                        if (q >= 10)
                        {
                            throw new RuntimeException("Assertion botch: excessivly large digit " + q); 
                        }
                        if ((((long)m) <= (long)0))
                        {
                            low= true; 
                            high= true; 
                        }
                        else
                        {
                            low= (boolean) ( (b < m) ? true : false ); 
                            high= (boolean) ( ((b + m) > tens) ? true : false ); 
                        }
                        digits22[ndigit++]= ((char)(48 + q)); 
                    }

                    lowDigitDifference= (long)((b << 1) - tens); 
                }
            }
            decExponent= decExp + 1; 
            digits= digits22; 
            nDigits= ndigit; 
            if (high)
            {
                if (low == false)
                {
                    roundup(); 
                }
                else if ((lowDigitDifference == (long)0))
                {
                    if ((digits22[(nDigits - 1)] & 0x1) != 0)
                    {
                        roundup(); 
                    }
                }
                else
                {
                    if ((lowDigitDifference > (long)0))
                    {
                        roundup(); 
                    }
                }
            }
            return; 
        }
        if (binExp <= nSignificantBits)
        {
            halfULP= (long)0; 
        }
        else
        {
            halfULP= (long)1 << ((binExp - nSignificantBits) - 1); 
        }
        if (binExp < 52)
        {
            fractBits= fractBits >>> (52 - binExp); 
        }
        else
        {
            fractBits= fractBits << (binExp - 52); 
        }
        developLongDigits(0, fractBits, halfULP); 
    }

    public String toString() {
	  if( _round ) {
		return Integer.toString( Math.round( floatValue() ) );
	  } else {
		return toFormattedString();
	  }
    }
    
    public String toFormattedString() {
 		if( isNaN ) {   return " ";   }       
		if( fixedDigits >= 0 ) return toJavaFormatString(fixedDigits);
        StringBuffer result= new StringBuffer((nDigits + 8)); 
        if (isNegative)
        {
            result.append(((char)45)); 
        }
        if( isINF ) {
		  result.append("INF"); 
		  return new String(result); 
        }
        if (isExceptional)
        {
            result.append(digits, 0, nDigits); 
        }
        else
        {
            result.append("0."); 
            result.append(digits, 0, nDigits); 
            result.append(((char)101)); 
            result.append(decExponent); 
        }
        return new String(result); 
    }
    
    public void setRounding( boolean round ) { _round  = round; }

    public String toJavaFormatString()
    {
 		if( isNaN ) {   return " ";   }       
        int charLength;
        char[] result= new char[(nDigits + 10)]; 
        int i= 0; 
        if (isNegative)
        {
            result[0]= ((char)45); 
            i= 1; 
        }
        if( isINF ) {
		  if (isNegative) return " -INF "; 
		  else return " INF "; 
        }
        if (isExceptional == false)
        {
            if  ( (decExponent <= 0) || (decExponent >= 8))
            {
                if  ( (decExponent > 0)  || (decExponent <= -3))
                {
                    result[i++]= ((char)digits[0]); 
                    result[i++]= ((char)46); 
                    if (nDigits <= 1)
                    {
                        result[i++]= ((char)48); 
                    }
                    else
                    {
                        System.arraycopy(digits, 1, result, i, (nDigits - 1)); 
                        i= i + (nDigits - 1); 
                    }
                    result[i++]= ((char)69); 
                    if (decExponent > 0) 
                    {
                        charLength= decExponent - 1; 
                    }
                    else
                    {
                        result[i++]= ((char)45); 
                        charLength= (-decExponent) + 1; 
                    }
                    if (charLength > 9)
                    {
                        if (charLength > 99)
                        {
                            result[i++]= (char) ((charLength / 100) + 48); 
                            charLength= charLength % 100; 
                            result[i++]= (char) ((charLength / 10) + 48); 
                            result[i++]= (char) ((charLength % 10) + 48); 
                        }
                        else
                        {
                            result[i++]= (char) ((charLength / 10) + 48); 
                            result[i++]= (char) ((charLength % 10) + 48); 
                        }
                    }
                    else
                    {
                        result[i++]= ((char)(charLength + 48)); 
                    }
                }
                else
                {
                    result[i++]= ((char)48); 
                    result[i++]= ((char)46); 
                    if (decExponent != 0)
                    {
                        System.arraycopy(zero, 0, result, i, (-decExponent)); 
                        i= i - decExponent; 
                    }
                    System.arraycopy(digits, 0, result, i, nDigits); 
                    i= i + nDigits; 
                }
            }
            else
            {
                charLength= Math.min(nDigits, decExponent); 
                System.arraycopy(digits, 0, result, i, charLength); 
                i= i + charLength; 
                if (charLength >= decExponent)
                {
                    result[i++]= ((char)46); 
                    if (charLength >= nDigits)
                    {
                        result[i++]= ((char)48); 
                    }
                    else
                    {
                        int t= nDigits - charLength; 
                        System.arraycopy(digits, charLength, result, i, t); 
                        i= i + t; 
                    }
                }
                else
                {
                    charLength= decExponent - charLength; 
                    System.arraycopy(zero, 0, result, i, charLength); 
                    i= i + charLength; 
                    result[i++]= ((char)46); 
                    result[i++]= ((char)48); 
                }
            }
        }
        else
        {
            System.arraycopy(digits, 0, result, i, nDigits); 
            i= i + nDigits; 
        }
        return new String(result, 0, i); 
    }

    public String toJavaFormatString(  int max_digits ) {
 		if( isNaN ) {   return " ";   }       
       int charLength;
        int n_digits= Math.min(max_digits, nDigits); 
        char[] result= new char[(n_digits + 10)]; 
        int i= 0; 
        if (isNegative)
        {
            result[0]= ((char)45); 
            i= 1; 
        }
        if( isINF ) {
		  if (isNegative) return " -INF "; 
		  else return " INF "; 
        }
        if (isExceptional == false)
        {
            if  ( (decExponent <= 0) || (decExponent >= 8))
            {
                if  ( (decExponent > 0)  || (decExponent <= -3))
                {
                    result[i++]= ((char)digits[0]); 
                    result[i++]= ((char)46); 
                    if (n_digits <= 1)
                    {
                        result[i++]= ((char)48); 
                    }
                    else
                    {
                        System.arraycopy(digits, 1, result, i, (n_digits - 1)); 
                        i= i + (n_digits - 1); 
                    }
                    result[i++]= ((char)69); 
                    if (decExponent > 0) 
                    {
                        charLength= decExponent - 1; 
                    }
                    else
                    {
                        result[i++]= ((char)45); 
                        charLength= (-decExponent) + 1; 
                    }
                    if (charLength > 9)
                    {
                        if (charLength > 99)
                        {
                            result[i++]= (char) ((charLength / 100) + 48); 
                            charLength= charLength % 100; 
                            result[i++]= (char) ((charLength / 10) + 48); 
                            result[i++]= (char) ((charLength % 10) + 48); 
                        }
                        else
                        {
                            result[i++]= (char) ((charLength / 10) + 48); 
                            result[i++]= (char) ((charLength % 10) + 48); 
                        }
                    }
                    else
                    {
                        result[i++]= ((char)(charLength + 48)); 
                    }
                }
                else
                {
                    result[i++]= ((char)48); 
                    result[i++]= ((char)46); 
                    if (decExponent != 0)
                    {
                        System.arraycopy(zero, 0, result, i, (-decExponent)); 
                        i= i - decExponent; 
                    }
                    System.arraycopy(digits, 0, result, i, n_digits); 
                    i= i + n_digits; 
                }
            }
            else
            {
                charLength= Math.min(n_digits, decExponent); 
                System.arraycopy(digits, 0, result, i, charLength); 
                i= i + charLength; 
                if (charLength >= decExponent)
                {
                    result[i++]= ((char)46); 
                    if (charLength >= n_digits)
                    {
                        result[i++]= ((char)48); 
                    }
                    else
                    {
                        int t= n_digits - charLength; 
                        System.arraycopy(digits, charLength, result, i, t); 
                        i= i + t; 
                    }
                }
                else
                {
                    charLength= decExponent - charLength; 
                    System.arraycopy(zero, 0, result, i, charLength); 
                    i= i + charLength; 
                    result[i++]= ((char)46); 
                    result[i++]= ((char)48); 
                }
            }
        }
        else
        {
            System.arraycopy(digits, 0, result, i, n_digits); 
            i= i + n_digits; 
        }
        return new String(result, 0, i); 
    }
    
    public boolean isExceptional() { return isExceptional; }
    public boolean isNegative() { return isNegative; }
    public boolean isINF() { return  isINF; }
    public boolean isNaN() { return  isNaN; }
    
    public float floatValue() { return Float.parseFloat( toFormattedString() ); }

}

