package miiee.util;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Canvas;
import java.awt.event.*;

public class MenuTest {

	public MenuTest() {
	  JMenuBar         menuBar = new JMenuBar();
	  JMenu            menu = new JMenu("File");
	  menu.getPopupMenu().setLightWeightPopupEnabled(false);
	  menuBar.add(menu);
	  JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
	  menuItem.addActionListener(
		  new ActionListener() {
			public void actionPerformed(ActionEvent e) { System.exit(0); }
		  }
	  );

	  JPanel panel = new JPanel(true);
	  panel.setLayout(new BorderLayout());
	  Canvas c = new Canvas();
	  c.setBackground(Color.black);
	  c.setSize( 200,200 );
	  panel.add( "Center", c );
	  
	  JFrame frame = new JFrame("MenuTest");
	  frame.getContentPane().add("Center", panel);
	  frame.setJMenuBar(menuBar);
	  frame.setBackground(Color.lightGray);
	  frame.addWindowListener( 
		new WindowAdapter() {
		  public void windowClosing(WindowEvent e) {System.exit(0);}
		}
	  );
	  frame.pack();
	  frame.show();
	}


    static public void main(String args[]) {
	  MenuTest mt = new MenuTest();
    }

}
