package miiee.util;

import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.util.Vector;
import java.util.HashMap;
import java.awt.font.TextAttribute;
import javax.help.*;
import java.awt.*;

class Message extends Object {
  public String _label;
  public StringVector _messages;
  public Message( String label, StringVector messages ) {
	_label = label;
	_messages = messages;
  }
}

//---- MessageReader ---------------------------------------------------------

public class MessageReader extends Object {

	protected JTextArea _infoText;
	protected JPanel _mainPanel;	
	protected Vector _messages = new Vector(64,64);
	
    protected boolean _is_showing = false;
	protected JFrame _frame;
	protected String _title;
	protected int _current_message_frame = 0;
	protected AttributeValuePair _indexValue;
	protected JTextField _labelField;
	private Font _font;    	
	
	public MessageReader(String title) {
	  _title = title;
	  setFontSize( 10f );
	  _mainPanel = createPanel();
	}
		
	public boolean isShowing() {
	  return _is_showing;
	}
	
	public void addMessages( String label, StringVector messages ) {
	  if( messages==null ) return;
	  _messages.add( new Message(label, messages ) );
	  _current_message_frame = _messages.size() - 1;
	  refresh_text();
	  SimIO.print( "Adding messages: " + _current_message_frame );
	}
	
	public void showFrame() {
	  create();
	  _frame.setVisible(true);
	  _is_showing = true;
	}
		  
	public void hideFrame() {
	  if( _frame != null ) {
		_frame.setVisible(false);
	  }
	  _is_showing = false;
	}	  

	public JPanel getPanel() { return _mainPanel; }
	
	JPanel createPanel() {
	  JPanel top = new JPanel(false);
	  top.setLayout(new BorderLayout());
	  CSH.setHelpIDString( top, "MessagePanel" );
	  
	  EmptyBorder eb2 = new EmptyBorder( 2, 2, 2, 2 );	
	  Border bb = new BevelBorder(BevelBorder.LOWERED);
	  Border cb = BorderFactory.createCompoundBorder( eb2, new BevelBorder(BevelBorder.LOWERED) ); 
	  
	  JPanel msg_panel = new JPanel( true );
	  BoxLayout bl = new BoxLayout( msg_panel, BoxLayout.X_AXIS );	  
	  msg_panel.setLayout( bl ); 	   
	  top.add( "Center", msg_panel );

	  JPanel info_panel = new JPanel( true );
	  BoxLayout bl1 = new BoxLayout( info_panel, BoxLayout.X_AXIS );	 
	  info_panel.setLayout( bl1 ); 	   
	  
	  JLabel label = new JLabel("Page Label");
	  label.setBorder( new EmptyBorder( 0, 6, 0, 6 ) );
	  info_panel.add( label );
	  _labelField = new JTextField(512);
	  JScrollPane scrollPane = new JScrollPane();
	  scrollPane.getViewport().setView(_labelField);
	  if( _font != null ) { _labelField.setFont(_font); }
	  scrollPane.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  scrollPane.setPreferredSize( new Dimension( 600, 35) );
	  scrollPane.setMinimumSize( new Dimension( 500, 35) );
	  info_panel.add(scrollPane);
	  top.add( "North", info_panel );

	  _infoText = new JTextArea();
	  _infoText.setBackground(Color.black);
	  _infoText.setForeground(Color.white); 
	  scrollPane = new JScrollPane();
	  scrollPane.getViewport().setView(_infoText);
	  scrollPane.setBorder( cb );
	  scrollPane.setMaximumSize( new Dimension( Short.MAX_VALUE, Short.MAX_VALUE ) );
	  msg_panel.add(scrollPane);
	  
	  JPanel buttons_panel = new JPanel( new FlowLayout() );
	  top.add( "South", buttons_panel );
	  
	  JButton  cancelButton = new JButton("close");
	  cancelButton.addActionListener( new CancelAction() );
	  buttons_panel.add(cancelButton);

	  JButton  prevButton = new JButton("prev");
	  prevButton.addActionListener( new PrevAction() );
	  buttons_panel.add(prevButton);

	  JButton  nextButton = new JButton("next");
	  nextButton.addActionListener( new NextAction() );
	  buttons_panel.add(nextButton);
	  
	  _indexValue = AttributeValuePair.New( "index:", true, 6 );
	  _indexValue.setValue( Integer.toString( _current_message_frame ) );
	  buttons_panel.add(_indexValue);

	  JButton  setButton = new JButton("set");
	  setButton.addActionListener( new SetAction() );
	  buttons_panel.add(setButton);
	  return top;
	}
	
	public synchronized JFrame create() {
	  if( _frame != null ) return _frame;
	  _frame = new JFrame(_title);
	  WindowListener l = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) { _is_showing = false; }
	  };
	  _frame.addWindowListener( l );
	  _frame.getContentPane().add( _mainPanel );
           
	  _frame.setSize(500,500);

	  Dimension         paneSize = _frame.getSize();
	  Dimension         screenSize = _frame.getToolkit().getScreenSize();
	  _frame.setLocation( screenSize.width/2, screenSize.height/5 );
	  return _frame;	  
	}

    class CancelAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) { hideFrame(); }
    }
    class PrevAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) { setCurrentMessageFrame( _current_message_frame - 1 ); }
    }
    class NextAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) { setCurrentMessageFrame( _current_message_frame + 1 ); }
    }
    class SetAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) { 
		String val =  _indexValue.getValue();
		int index = Integer.valueOf(val).intValue(); 
		setCurrentMessageFrame( index );
	  }
    }
    
    public void dispose() {
	  if( _frame != null ) {
		_frame.setVisible(false);
		_frame.dispose();
		_frame = null;
	  }
    }
    
    public int setCurrentMessageFrame( int frame ) {
	  int cur_index = _current_message_frame;
	  if( frame <= 0 ) {
		_current_message_frame = 0;
	  } else if( frame >= _messages.size() ) {
		_current_message_frame = _messages.size() - 1;
	  } else {
		_current_message_frame = frame;
	  }	  
	  if( cur_index != _current_message_frame ) {
		refresh_text();
	  } 
	  return _current_message_frame;   
    }
    
    void refresh_text() {
	  Message m = null;
	  try {
		m = (Message) _messages.elementAt( _current_message_frame );
	  } catch ( ArrayIndexOutOfBoundsException err ) {;}
	  if( m == null ) { SimIO.beep(); return; }
	  
	  String text = ( m._messages == null ) ? null : m._messages.toString();
	  _infoText.setText( text );
	  
//	  setLineColor( text, "warning", Color.yellow );
//	  setLineColor( text, "error", Color.red );
	  
	  _indexValue.setValue( Integer.toString( _current_message_frame ) );
	  _labelField.setText( m._label );
	  _infoText.repaint(); _labelField.repaint();
    }
    
    void setLineColor( String text, String prefix, Color line_color ) {
	  int startp, endp=0; 
	  String suffix = "\n";
	  System.out.print("\nSet line color: " + prefix );
	  while(true) {
		startp = text.indexOf(prefix, endp);
		if( startp < 0 ) return;
		endp = text.indexOf(suffix, startp);
		if( endp < 0 ) { endp = text.length(); }
        _infoText.setCaretPosition(startp);
        _infoText.moveCaretPosition(endp);
        _infoText.setSelectedTextColor(line_color);
        System.out.print(" pos: " + startp );
	  }
	}
	 
    public void setFontSize( float font_size ) {
	  HashMap font_attr = new HashMap();
	  font_attr.put( TextAttribute.SIZE, new Float(font_size) );
	  _font = new Font(font_attr);
    }
	 

}

