package miiee.util;

import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.awt.Dimension;;

//---- ProgressDialog ---------------------------------------------------------

public class ProgressDialog extends Object
{
	JProgressBar _progressBar;
	String _label;
    static final int _min_value = 0;
    static final int _max_value = 1000;
    boolean _block = true;
    boolean _return_value = false;
    boolean _is_showing = false;
	JFrame _frame;
	
	public ProgressDialog(String label) {
	  _progressBar = new JProgressBar( _min_value, _max_value );
	  _progressBar.setValue(_min_value);
	  _label = label;
	}
	
	public synchronized void setValue(float val ) {   // 0f <= val <= 1f
	  if( val >= 1f ) { 
		finalize();
	  } else {
		val = (val < 0f ) ? 0f : val;
		_progressBar.setValue( (int) (val*_max_value) ); 
	  }
	}

	public void finalize() {  
	  _return_value = true;
	  _progressBar.setValue( _max_value ); 
	  dispose(); 
	}
	
	public boolean isFinished() {
	  return _return_value;
	}
	public boolean isShowing() {
	  return _is_showing;
	}
	
	public synchronized boolean show( boolean block ) {
	  _is_showing = true;	  
	  _frame = new JFrame("Progress");
	  WindowListener l = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) { _is_showing = false; }
	  };
	  _frame.addWindowListener( l );
	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  JPanel progress_panel = (JPanel)_frame.getContentPane();	

	  JLabel msgLabel = new JLabel(_label, JLabel.CENTER);
	  msgLabel.setBorder( eb7 );
	  Border bb = BorderFactory.createCompoundBorder( eb7, new BevelBorder(BevelBorder.LOWERED) ); 
	  _progressBar.setBorder( bb );

	  JButton  cancelButton = new JButton("cancel");
	  cancelButton.addActionListener( new CancelAction() );
            
	  progress_panel.add( "North", msgLabel );
	  progress_panel.add( "Center", _progressBar );
	  progress_panel.add( "South", cancelButton );
	  _frame.pack();
	  _frame.setResizable(false);

	  Dimension         paneSize = _frame.getSize();
	  Dimension         screenSize = _frame.getToolkit().getScreenSize();
	  _frame.setLocation((screenSize.width - paneSize.width) / 2,
				  (screenSize.height - paneSize.height) / 2);
	  _frame.setVisible(true);
	  
	  _block = isFinished() ? false : block;
	  while( _block ) {
		try {  Thread.sleep(200L);   }
		catch (InterruptedException e0) {  return _return_value; }	  
	  }
	  return _return_value;
	}

    class CancelAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) { dispose();  }
    }
    
    public void dispose() {
	  _block = false;
	  _is_showing = false;
	  if( _frame != null ) {
		_frame.setVisible(false);
		_frame.dispose();
		_frame = null;
	  }
    }
    
    
	 

}

