package miiee.util;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.EventObject;

class  QueuedExecutableRunnable implements Runnable {
    private Thread _cmdThread;
    private boolean _run_cmd_thread;
    private Queue _cmdStack;

    QueuedExecutableRunnable() {
        _run_cmd_thread= true; 
        _cmdStack= new Queue(); 
    }

    public void add(Runnable ex) {
        _cmdStack.push(ex); 
    }

    public void run() {
        while (_run_cmd_thread){
            try {
                Thread.sleep(200L); 
            }
            catch (InterruptedException InterruptedException0)  {
                return; 
            }
            Runnable ex= (Runnable)_cmdStack.pop(); 
            if (ex == null)   {
                try   {
                    Thread.sleep(600L); 
                }
                catch (InterruptedException InterruptedException0)  {
                    return; 
                }
                continue;
            }
            ex.run(); 
            continue;
        }

    }

    public void start() {
		stop(); 
        _cmdThread= new Thread(((Runnable)this)); 
        _run_cmd_thread= true; 
        _cmdThread.setPriority(3); 
        _cmdThread.start(); 
    }

    public void stop() {
        if (_cmdThread != null) {
            _run_cmd_thread= false; 
            _cmdThread= null; 
        }
    }
}


public abstract class QueuedExecutable extends AbstractAction implements Runnable, ChangeListener, TreeExpansionListener {
   
  protected Object _source;
  protected EventObject _event;
  boolean _useEventDispachTread = false;
  static QueuedExecutableRunnable _runnable= new QueuedExecutableRunnable(); 
  
  static {
	_runnable.start(); 
  }
  
  public QueuedExecutable( ) { 
	super();
  }

  public QueuedExecutable( Object source ) { 
	super(); 
	_source = source; 
  }
  
  
  public QueuedExecutable( String name, Icon icon ) { 
	super(name,icon); 
  }
   
  public void stateChanged(ChangeEvent e) { 
	_event = e;
	if( _useEventDispachTread ) {
	  SwingUtilities.invokeLater(this);
	} else {
	  _runnable.add(this); 
	}
  }

  public void processEvent(EventObject e) { 
	_event = e;
	if( _useEventDispachTread ) {
	  SwingUtilities.invokeLater(this);
	} else {
	  _runnable.add(this); 
	}
  }
 
  public abstract void execute();
  
  public void useEventDispachTread() {  _useEventDispachTread = true; }
    
  public void actionPerformed(ActionEvent e) {
	_event = e;
	if( _useEventDispachTread ) {
	  SwingUtilities.invokeLater(this);
	} else {
	  _runnable.add(this); 
	}
  }
  
  public void executeOnEventDispatchTread() {
	SwingUtilities.invokeLater(this);
  }
  
  public void run() { 
	try {
	  execute(); 
	} catch ( Exception err ) {
	  SimIO.show_error( null, "Execution error: ", err );	
	  err.printStackTrace();
	}
  }

  public static void start() {
	  _runnable.start(); 
  }

  public static void stop() {
	  _runnable.stop(); 
	  _runnable= null; 
  } 
  
  public void treeCollapsed(TreeExpansionEvent event) {;}
  public void treeExpanded(TreeExpansionEvent event) {
	_event = event;
	if( _useEventDispachTread ) {
	  SwingUtilities.invokeLater(this);
	} else {
	  _runnable.add(this); 
	}
  }
} 

