package miiee.util;

import java.util.Vector;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.ListIterator;

public class RepairedMutableTreeNode extends DefaultMutableTreeNode {

    public RepairedMutableTreeNode(Object userObject) {
	  super(userObject, true);
    }
    public RepairedMutableTreeNode() {
	  super(null, true);
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
	if (!allowsChildren) {
	    throw new IllegalStateException("node does not allow children");
	} else if (newChild == null) {
	    throw new IllegalArgumentException("new child is null");
	} else if (isNodeAncestor(newChild)) {
	    throw new IllegalArgumentException("new child is an ancestor");
	}

	    MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();

	    if (oldParent != null) {
		oldParent.remove(newChild);
	    }
	    newChild.setParent(this);
	    if (children == null) {
		  children = new Vector();
	    }
		if ( childIndex >= (children.size() + 1) ) {
		  for( int i=children.size(); i<=childIndex; i++ ) {
			children.add(null);
		  }
		}
	    children.insertElementAt(newChild, childIndex);
    }
}

