package miiee.util;

import java.awt.FlowLayout;
import javax.swing.*;
import  miiee.wizard.DirectoryModel;
import javax.swing.event.*;
import java.util.Vector;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.GridLayout;
import miiee.util.*;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;
import java.io.File;

class FormatData {
	static ButtonGroup _bg = new  ButtonGroup();
	static JPanel _buttonPanel;
	static int _count = 0;
	static Vector _formatData = new Vector(16,16); 
	JRadioButton _rButton;
	int _index;
	String _name;

	private FormatData( String n, int index, boolean enabled, boolean selected, ItemListener iL ) {
	   _name = n;
	   _index = index;
	   _rButton = new JRadioButton(n);
	   _rButton.setAlignmentX(Component.LEFT_ALIGNMENT);
	   _rButton.addItemListener(iL);
	   _rButton.setEnabled(enabled);
	   _rButton.setSelected(selected);
	   _bg.add( _rButton );
	   _buttonPanel.add( _rButton );
	}

	static public void NewFormatData( String n, boolean enabled, boolean selected, ItemListener iL ) {
	  if( _buttonPanel == null ) {
		_buttonPanel = new JPanel(true);
		BoxLayout bl = new BoxLayout(_buttonPanel, BoxLayout.Y_AXIS );  _buttonPanel.setLayout( bl );
		_buttonPanel.setBorder( 
		   BorderFactory.createCompoundBorder( 
			  BorderFactory.createEtchedBorder(),	   
			  new EmptyBorder( 12, 12, 12, 12 ) 
		   )  
		); 
	  }	
	  FormatData vd = new FormatData( n, _count++, enabled, selected, iL );
	  _formatData.addElement(vd);
	}

	static boolean empty() { return ( _formatData.size() == 0 ); }
	
	static public JPanel getPanel() {
	  return _buttonPanel;
	}
	
	public static int getSelectionIndex() {
	  ListIterator li = _formatData.listIterator();
	  for( Object o = li.next(); li.hasNext(); o = li.next() ) {
		FormatData vd = (FormatData)o;
		AbstractButton b = vd._rButton;
		if( b.isSelected() && b.isEnabled() ) { return vd._index; }
	  }
	  return -1;
	}

	public static void setActivation( int dim, boolean singleDataset ) {
	  boolean rv = true;
	  ListIterator li = _formatData.listIterator();
	  for( Object o = li.next(); li.hasNext(); o = li.next() ) {
		FormatData vd = (FormatData)o;
		vd.setLocalActivation( dim, singleDataset );
	  }
	}

	private boolean setLocalActivation( int dim, boolean singleDataset ) {
	  boolean rv = true;
	  try {
		/*   add conditions */
	  } catch ( ArrayIndexOutOfBoundsException err ) { rv = false; }
	  _rButton.setEnabled(rv);
	  return rv;		
	}
};

public class SaveFileControlPanel extends JComponent implements ItemListener, DataDisplayListener {

    protected AttributeValuePair _pathChoosen;
    protected JList _directoryList;
	protected AttributeValuePair _fileName;
	protected JFrame _frame; 
	protected DirectoryModel _dir_model = new DirectoryModel( false );
	private boolean _saveSingleFrame = true;
	protected IOController _ac;
	protected ButtonGroup _SaveFrameButtonGroup = new  ButtonGroup();
	protected ButtonModel _saveAllFrames;
	protected int _dataType = IMAGES;

    public static final int IMAGES	= 0;
    public static final int DATASETS	= 1;
	 

	private SaveFileControlPanel( ) { super(); }
		
	public static SaveFileControlPanel fetchPanel( IOController ac, String fileName, String path, SimulationData sd ) {
	  SaveFileControlPanel controlPanel = new SaveFileControlPanel();
	  controlPanel.init(sd);
	  controlPanel.setDefaults(ac,fileName,path);
	  return controlPanel;
	}
	
	public void setDefaults( IOController ac, String fileName, String path ) {
	  _ac = ac;
	  if( fileName != null ) { _fileName.setValue(fileName); }
	  if ( path != null ) {
		_dir_model.setCurrentDirectory( new File(path) );
		_pathChoosen.setValue(path);
	  }	  
	}
	
	void init( SimulationData sd ) {
		setLayout( new BorderLayout() );

		JPanel info_panel = new JPanel(true);
		Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	info_panel.setBorder( bb );
		add(info_panel,"North");

		_pathChoosen = AttributeValuePair.New( "path:", true, 35 );
		_pathChoosen.addDataDisplayListener( this );
		_pathChoosen.setValue( " (no data) " );
		info_panel.add(_pathChoosen);

		JPanel status_panel = new JPanel(true);
		bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	status_panel.setBorder( bb );
		add(status_panel, "South" );
		
		JButton  aButton = new JButton("Close");
		aButton.addActionListener( new CloseAction() );
		status_panel.add( aButton );

		aButton = new JButton("Save");
		aButton.addActionListener( new SaveAction(sd) );
		status_panel.add( aButton );
		
		add( create_data_panel( sd ), "Center" );
		setBorder( BorderFactory.createEtchedBorder() );
	} 

	JPanel create_data_panel( SimulationData sd ) {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );	
	  JPanel pH  = new JPanel(true);
	  BoxLayout bl = new BoxLayout(pH, BoxLayout.X_AXIS );	  pH.setLayout( bl ); 	   

	  JPanel pV0  = new JPanel(true);
	  bl = new BoxLayout(pV0, BoxLayout.Y_AXIS );  pV0.setLayout( bl ); 	   
	  Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	pV0.setBorder( bb );
	  pV0.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  pH.add(pV0);

	  JPanel pV1  = new JPanel(true);
	  bl = new BoxLayout(pV1, BoxLayout.Y_AXIS );  pV1.setLayout( bl ); 	   
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );   pV1.setBorder( bb );
	  pV1.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  pH.add(pV1);
	  	  
	  JLabel title = new JLabel("Choose Directory:");
//	  title.setBorder(eb7);
//	  title.setAlignmentX(Component.LEFT_ALIGNMENT);
	  pV0.add(title);
	  _directoryList =  new JList( _dir_model );
	  _directoryList.setBorder( BorderFactory.createEtchedBorder() );
	  JScrollPane scrollPane = new JScrollPane();
	  scrollPane.getViewport().setView(_directoryList);
	  scrollPane.setBorder( eb7 );
	  MouseListener mouseListener = new MouseAdapter() {
		 public void mouseClicked(MouseEvent e) {
			 if (e.getClickCount() == 2) {
				 int index = _directoryList.locationToIndex(e.getPoint());
				 setDirectorySelection(index);
			  }
		 }
	  };
	  _directoryList.addMouseListener(mouseListener);
 	  pV0.add(scrollPane);
 	  
 	  JPanel dirPanel = new JPanel( new FlowLayout() );

	  JButton  button = new JButton("Up");
	  button.addActionListener( new UpAction() );
	  dirPanel.add( button );

	  _fileName = AttributeValuePair.New( "Base File Name:", true, 25 );
	  _fileName.addDataDisplayListener( this );
	  _fileName.setAlignmentX( Component.CENTER_ALIGNMENT );
	  dirPanel.add(_fileName);
	  pV0.add(dirPanel);

	  if( sd == null ) { createImageDataPanel( pV1 ); }
	  else { createDataSetPanel( pV1, sd ); } 
	  
	  _pathChoosen.setValue( _dir_model.getCurrentDirectory().getAbsolutePath() );	 
	   	  
	  return pH;
	}

	private void createImageDataPanel( JPanel pV ) {
	  JLabel title = new JLabel("Available Formats:");
//	  title.setBorder(eb7);
//	  title.setAlignmentX( Component.CENTER_ALIGNMENT );
	  pV.add(title);

	  if( FormatData.empty() ) {
		FormatData.NewFormatData( "PPM", true, true, this );
		FormatData.NewFormatData( "GIF", false, false, this  );
		FormatData.NewFormatData( "JPEG", true, true, this  );
		FormatData.NewFormatData( "Map II", false, false,  this  );
	  }
	  pV.add( FormatData.getPanel() );

	  JRadioButton rButton = new JRadioButton("Save Current Frame");
	  rButton.setAlignmentX(Component.LEFT_ALIGNMENT);
	  _SaveFrameButtonGroup.add( rButton );
	  pV.add( rButton );

	  JRadioButton rButton1 = new JRadioButton("Save All Frames");
	  rButton1.setAlignmentX(Component.LEFT_ALIGNMENT);
	  _saveAllFrames = rButton1.getModel();
	  _SaveFrameButtonGroup.add( rButton1 );
	  
	  pV.add( rButton1 );	  
	}

	private void createDataSetPanel( JPanel pV, SimulationData sd ) {
	  _dataType = DATASETS;
	  JLabel title = new JLabel("Save DataSets:");
//	  title.setBorder(eb7);
	  title.setAlignmentX( Component.CENTER_ALIGNMENT );
	  pV.add(title);

	  JList dataList = new JList( sd );
	  dataList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	  dataList.setBorder( BorderFactory.createEtchedBorder() );
	  pV.add( dataList );

	  JButton  button = new JButton("Delete");
	  button.addActionListener( new DataListAction(dataList,sd) );
	  button.setMaximumSize( new Dimension( Short.MAX_VALUE, button.getMaximumSize().height ) );
	  button.setAlignmentX( Component.CENTER_ALIGNMENT );
	  pV.add( button );	  
	}
	
    public void itemStateChanged(ItemEvent e) {
//	  _creationButton.setEnabled( FormatData.getSelectionIndex() >= 0 );
    }

	public synchronized void setDirectorySelection( int selection_index ) {
	  try {
		File dir = _dir_model.getFileAt(selection_index);
		if( dir != null ) {
		  SimIO.print( "Setting dir to " + dir );
		  _pathChoosen.setValue( dir.getAbsolutePath() );
		  _dir_model.setCurrentDirectory(dir);
		}
	  } catch( ArrayIndexOutOfBoundsException err ) { return; }
	}
	
	class CloseAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		dispose();
	  }
    }
    
    public void dispose() { 
	  if( _frame != null ) {
		_frame.setVisible(false);
		_frame.dispose();
		_frame = null;
	  }
	}

	class UpAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		  _pathChoosen.setValue( _dir_model.setParentDirectory() );
	  }
    } 

	class DataListAction extends Object implements ActionListener  {
	  JList _list;
	  Vector _v;
	  DataListAction( JList list, Vector v ) { super(); _list = list; _v = v; }
	  public void actionPerformed(ActionEvent e) {
		  int[] svals = _list.getSelectedIndices();
		  if( svals.length == 0 ) return;
		  int imin = svals[0], imax = svals[svals.length-1];
		  for( int i=0; i<svals.length; i++ ) {
			_v.setElementAt( null, svals[i] ); 
		  }
		  boolean more = true;
		  while( more ) {
			more = false;
			for( int i=0; i<_v.size(); i++ ) {
			  Object o = _v.get(i);
			  if( o == null ) { 
				_v.removeElementAt(i);
				more = true;
				break;
			  }
			}
		  }
		  _list.repaint();
//		  AbstractListModel lm = (AbstractListModel)_list.getModel();
//		  lm.fireIntervalRemoved( lm, imin, imax );
	  }
    } 

	class SaveAction extends Object implements ActionListener  {
	  SimulationData _sd;
	  public SaveAction( SimulationData sd ) { super();  _sd = sd; }
	  public void actionPerformed(ActionEvent e) {
		if( _ac != null ) {
		  switch( _dataType ) {
			case IMAGES: {
			  int format_index = FormatData.getSelectionIndex();
			  boolean saveAllFrames = (_SaveFrameButtonGroup.getSelection() == _saveAllFrames);
			  _ac.saveData(_pathChoosen.getValue(), _fileName.getValue(), format_index, saveAllFrames ); 
			  dispose();
			  break;
			}
			case DATASETS: {
			   _ac.saveData(_pathChoosen.getValue(), _fileName.getValue(), _sd ); 
			   dispose();
			   break;
			}
		  }
		} 
	  }
    } 
		
	public  void  set_pathChoosen( String path ) {
	  try {
		_pathChoosen.setValue( path );
	  } catch ( NullPointerException err ) { return; }
	  repaint();
	}

	static JFrame createFrame( SaveFileControlPanel cp ) {
		WindowListener l = new WindowAdapter() {
			public void windowClosing(WindowEvent e) { super.windowClosing(e); }
			public void windowClosed(WindowEvent e) { super.windowClosed(e); }
		};
		JFrame frame = new JFrame("Choose Path");
		cp.setFrame(frame);
		frame.addWindowListener(l);
		frame.setContentPane( cp );
		frame.pack();
		frame.show();
		return frame; 
	}
	
    public static SaveFileControlPanel showControlPanel( IOController ac, String baseName, String path, SimulationData sd ) {
		SaveFileControlPanel cp = SaveFileControlPanel.fetchPanel(ac,baseName,path,sd);
		createFrame( cp );
		return cp;      
    }  

    public void setFrame( JFrame f ) {
	  _frame = f;
    }  
 
	public  void pointSelected(DataDisplayEvent datadisplayevent) {;}

    public  void regionSelected(DataDisplayEvent datadisplayevent) {;}

    public  void scrollScaleChanged(DataDisplayEvent datadisplayevent) {;}

    public  void scaleChanged(DataDisplayEvent datadisplayevent) {;}

    public  void textInput(DataDisplayEvent datadisplayevent) {
	  AttributeValuePair s = (AttributeValuePair) datadisplayevent.getSource();
	  if( s == _pathChoosen ) {
		String text = _pathChoosen.getValue();
		File dir = new File(text);
		SimIO.print( "Setting dir to " + text );
		if( dir != null ) { SimIO.print( "File: " + dir ); }
		_dir_model.setCurrentDirectory(dir);
	  } else {
	  
	  }
    }

    public  void timeChanged(DataDisplayEvent datadisplayevent) {;}
   
	static public void main(String args[]) { 
	  SaveFileControlPanel.showControlPanel(null,"test","/flock/Java",null);
	}
}
