package miiee.util;
import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import java.lang.ref.SoftReference;
import javax.help.*;
import java.net.*;
import javax.swing.border.*;
import java.security.*;
import miiee.xml.ScriptExecutable;
import miiee.xml.XMLComponent;
import miiee.xml.LocalResolver;
import java.io.*;

import java.io.PrintStream;

public class SimIO {

	private static final String kSimulationID = "miiee sme";

    private static Calendar staticCal = null;
    private static Calendar utcCal = null;
    private static int defaultCenturyStart = 0;
    private static TimeZone cachedDefaultZone;
    private static SoftReference simpleFormatter = null;
    private static SoftReference gmtFormatter = null;
    private static Toolkit _toolkit = Toolkit.getDefaultToolkit();
    private static JApplet _applet = null;  
    private static HashMap _helpBrokers = new HashMap();
    private static String _codebase;
    private static String _workbenchRootDir;
   private static String _winPath;
    private static HashMap _icons = new HashMap();


    public static void print(String msg)
    {
        System.out.print("\nJAVA: " + msg);
    }

    public static void print(StringBuffer msg)
    {
        System.out.print("\nJAVA: " + msg);
    }

    public static void setCodebase( String val ) {
	  if( val == null ) return;
//	  if( val.startsWith("/") ) { val = "file:" + val; }
	  _codebase = val;
	  print( " Setting codebase to " + _codebase + "\n" );
	}

    public static void setWorkbenchDirectory( String val ) {
	  if( val == null ) return;
	  _workbenchRootDir = val;
	  print( " Setting Workbench Root Dir to " + _workbenchRootDir + "\n" );
	}
    public static String getCodebase() { return _codebase; }

    public static String getLocalHostAddress() {
	   String lhost = "unknown";
	   try {
		 InetAddress lhost_addr = InetAddress.getLocalHost();
		 try {
		   lhost = lhost_addr.getHostName();
		 } catch ( SecurityException err ) {
		   lhost = lhost_addr.getHostAddress();
		 }
	   } catch ( java.net.UnknownHostException err ) {;}
	   return lhost;
	}

	public static void set_centered_location( Component component, float loc_x, float loc_y ) {
	  Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
	  int x = (int) ((screenDim.width - component.getSize().width) * loc_x);
	  int y = (int) ((screenDim.height - component.getSize().height) * loc_y);
	  component.setLocation(x, y);
	}


    public static void show_error( Component parentComponent, String msg ) {
		JOptionPane.showMessageDialog( parentComponent, msg, "JST error", JOptionPane.ERROR_MESSAGE );
    }

    public static void show_error( Component parentComponent, String msg, Throwable err ) {
		err.printStackTrace();
		JOptionPane.showMessageDialog( parentComponent, msg + err.toString(), "JST error", JOptionPane.ERROR_MESSAGE );
    }

   public static void show_error( Component parentComponent, Throwable err ) {
		err.printStackTrace();
		JOptionPane.showMessageDialog( parentComponent, err.getMessage(), "JST error", JOptionPane.ERROR_MESSAGE );
    }

    public static void show_warning( Component parentComponent, String msg ) {
		JOptionPane.showMessageDialog( parentComponent, msg, "JST warning", JOptionPane.WARNING_MESSAGE );
    }

    public static void show_info( Component parentComponent, String msg ) {
		JOptionPane.showMessageDialog( parentComponent, msg, "JST info", JOptionPane.INFORMATION_MESSAGE );
    }

   public static void show_text( Component parentComponent, String msg ) {
	   JTextPane tp = new JTextPane();
	   tp.setText(msg);
	  JOptionPane.showMessageDialog( parentComponent, tp, "JST info", JOptionPane.INFORMATION_MESSAGE );
    }

    public static int show_confirm2( Component parentComponent, String msg ) {
		int rv = JOptionPane.showConfirmDialog( parentComponent, msg, "JST confirm", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE );
		switch( rv ) {
		  case  JOptionPane.YES_OPTION: return 1;
		  case  JOptionPane.NO_OPTION: return 0;
		}
		return 0;
    }


    public static int show_confirm3( Component parentComponent, String msg ) {
		int rv = JOptionPane.showConfirmDialog( parentComponent, msg, "JST confirm", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE );
		switch( rv ) {
		  case  JOptionPane.YES_OPTION: return 1;
		  case  JOptionPane.NO_OPTION: return 0;
		  case  JOptionPane.CANCEL_OPTION: return -1;
		}
 		return 0;
   }

   public static void beep() {   _toolkit.beep(); }

    SimIO() {
        super();
    }

    public static String getWindowsPath( String source ) {
      String current_script = "cygpath --windows " + source;
      InputStream stdout = null, stderr = null;
      try {
        Process p = Runtime.getRuntime().exec( current_script );
        stdout = p.getInputStream();
        stderr = p.getErrorStream();
        p.waitFor();
      } catch ( InterruptedException err ) {
        SimIO.show_error( null, "Interrupted while waiting for script execution!\n" + err.getMessage() );
      } catch ( IOException ierr ) {
        SimIO.show_error( null, "Error in script execution!\n" + ierr.getMessage() );
      }

/*
      String cygroot = getProperty("CYGROOT");
      if( cygroot != NULL ) {
         _winPath = cygroot;
      }
*/
      String s = collect( stdout );
      String err = collect( stderr );
      return  (s == null ) ? source : s;
    }

    static String collect( InputStream istr ) {
	StringBuffer s = new StringBuffer();
	if( istr != null ) {
	  int ch = '\n';
	  try {
	    while ( (ch = istr.read()) > -1 ) {
		s.append((char)ch);
	    }
	  } catch ( IOException err ) {;}
	}
/*@@*/ 	print( "Collected string: " + s + ", stream: " + istr );
	return s.toString();
     }

	public static void setApplet(JApplet applet) { _applet = applet; }
	public static JApplet getApplet() { return _applet; }
	public static String getApplicationID() { return kSimulationID; }

	public static String getBaseURL() {
	  String path = null;
	  if( _applet != null ) {
		URL url = _applet.getCodeBase();
		path = url.toString();
/*@@*/	print("Applet CodeBase: " + path  + "\n"  );
	  } else {
		path = getCodebase();
	  }
	  return path;
	}

    public static String getWorkbenchDirectory() {
	  if( _workbenchRootDir != null ) {
		  return _workbenchRootDir;
	  }
	  String path = null;
	  if( _codebase != null ) {
		String cbase = _codebase;
		if( _applet == null ) {
		  if( cbase.startsWith("file:") ) {
			cbase = cbase.substring(5);
		  }
		}
		return cbase;
	  }
		try {
			path = System.getProperty("portal.dir");
		} catch ( AccessControlException err ) {;}
		if( path == null ) {
			try {
			  path = System.getProperty("user.home") + "/.sme/";
			} catch ( AccessControlException err ) {
			  path = getBaseURL();
			}
		  }
		return path;
	}

    public static String getXMLUsrDirectory() {
	  String path = null;
	  if( _codebase == null ) {
		try {
		  path = System.getProperty("user.home") + "/.sme/";
		} catch ( AccessControlException err ) {
		  path = getBaseURL() + "/xml/";
		}
	  } else {
		return _codebase + "/xml/";
	  }
	  return path;
	}

    public static String getXMLSysDirectory() {
	  String path = null;
	  if( _codebase == null ) {
		try {
		  path = System.getProperty("LIBDIR") + "/xml/";
		} catch ( AccessControlException err ) {
		  path = getBaseURL() + "/xml/";
		}
	  } else {
/*@@*/	print("SimIO CodeBase: " + _codebase  + "\n"  );
		return _codebase + "/xml/";
	  }
/*@@*/ print("getXMLUsrDirectory: " + path  + "\n"  );
	  return path;
	}

    public static String getXMLInternalDirectory() {
	  String path = System.getProperty("LIBDIR") + "/xml/";
	  return path;
	}

   public static Icon loadIcon( String name ) {

	  Icon icon = (Icon) _icons.get(name);

	  if( icon == null ) {
	      URL image_resource = null;
	      if( _applet == null ) {
		LocalResolver LR = new LocalResolver();
		image_resource = LR.loadResource( name );
	      } else {
		ClassLoader cl = _applet.getClass().getClassLoader();
		if( cl != null ) { image_resource = cl.getResource(name); }
	      }
	      if(image_resource != null) {
	        icon = new ImageIcon(image_resource);
	      }
	  }
/*
		if( _applet != null ) {
		  URL url = _applet.getClass().getResource(name);
		  if( url != null ) {
			try {
			  Image im = _toolkit.createImage((ImageProducer)url.getContent());
			  if( im != null ) {
				icon =  new ImageIcon (im);
			  }
			  SimIO.print("Create icon from resource: " + name );
			} catch ( Exception err0 ) {
			  show_error( null, "Error creating image from resource:", err0 );
			}
		  }
		}
*/
	  if( icon == null ) {
		String file = null;
		boolean useURL = false;
		URL url = null;

		String libDir = null;
		try {
		  libDir = System.getProperty("LIBDIR");
		} catch( AccessControlException err ) {;}

		if( libDir == null ) {
		  file = getBaseURL() + "/lib/images/" + name;
		  useURL = true;
		} else {
		  file = libDir + "/images/" + name;
		}
		try {
		  if( useURL ) {
			try {
			  url = new URL( file );
			  icon = new ImageIcon( url );
			} catch( java.net.MalformedURLException mue ) {
			  SimIO.print("Error loading Icon " + name + ", bad URL:" + url);
			}
		  } else {
			 icon = new ImageIcon( file );
		  }
		} catch ( Exception err ) {
		  SimIO.print("Can't access Icon " + name + ", file:" + file);
		}
	  }
	  if( icon != null ) { _icons.put(name,icon); }
	  return icon;
	}

    public static String dateString() {
        if (staticCal == null) makeStaticCalendars();

	  DateFormat formatter = null;
	  if (simpleFormatter != null) {
		  formatter = (DateFormat)simpleFormatter.get();
	  }
	  if (formatter == null) {
		  /* No cache yet, or cached formatter GC'd */
		  formatter = new SimpleDateFormat("yy.MM.dd.HH:mm",  Locale.US);
		  simpleFormatter = new SoftReference(formatter);
	  }
	  synchronized (formatter) {
		  TimeZone defaultZone = TimeZone.getDefault();
		  if (!defaultZone.equals(cachedDefaultZone)) {
			  staticCal.setTimeZone(defaultZone);
			  cachedDefaultZone = defaultZone;
		  }
		  formatter.setTimeZone(defaultZone);
		  Date d = new Date();
		  return formatter.format(d);
	  }
    }

    private static void makeStaticCalendars() {
        cachedDefaultZone = TimeZone.getDefault();
		staticCal = new GregorianCalendar();
        utcCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        defaultCenturyStart = staticCal.get(Calendar.YEAR) - 80;
    }


    public static String showTextInputDialog( Frame parentFrame, String message, String title, String initialTextValue ) {
        TextInputDialog tid = new TextInputDialog( parentFrame, title );
        tid.show(message,initialTextValue);
        return tid.getValue();
    }
/*
    public static void showHelp( String helpsetName ) {
	  try {
		JFrame helpViewer = (JFrame) _JHelpViewers.get(helpsetName);
		if( helpViewer == null ) {
//		  String helpSetFile= "file:/" + System.getProperty("LIBDIR") + "/docs/help/" + helpSet + ".hs";
		  try {
			ClassLoader cl = SimIO.class.getClassLoader();
			URL url = HelpSet.findHelpSet(cl, helpsetName);
			HelpSet hs = new HelpSet(cl, url);
			JHelp jh = new JHelp(hs);
			helpViewer  = new JFrame( helpsetName + " Help" );
			_JHelpViewers.put(helpsetName,helpViewer);
			helpViewer.setContentPane( jh );
			helpViewer.pack();
			Dimension         paneSize = helpViewer.getSize();
			Dimension         screenSize = helpViewer.getToolkit().getScreenSize();
			helpViewer.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
		  }  catch ( javax.javahelp.HelpSetException err ) {
			print("Unknown or malformed helpset: " + helpsetName  + "\n" + err );  return;
		  }
		}
		helpViewer.setVisible(true);
	  } catch ( NoClassDefFoundError ex ) {
		return;
	  }
	}
*/

    public static HelpBroker getHelpBroker( String helpsetName, String topicID ) {
	  HelpBroker hb = null;
	  try {
		hb = (HelpBroker) _helpBrokers.get(helpsetName);
		if( hb == null ) {
		  LocalResolver LR = new LocalResolver();
		  hb = LR.loadHelpBroker( helpsetName );
		  if( hb != null ) {
			_helpBrokers.put(helpsetName,hb);
			hb.getHelpSet().setHomeID(topicID);
		  } else {
			print( "Can't find HelpSet: " + helpsetName );
		  }
		}
	  }  catch ( Exception err ) {
		print("Unknown or malformed helpset: " + helpsetName  + ":\n\t" + err.getMessage() );
	  }
	  return hb;
	}

}

class TextInputDialog {

	JDialog _dialog;
	String _result = "";
	AttributeValuePair 	_InputTextField;
	JButton _defaultButton;
	Frame _parent;

	public TextInputDialog( Frame parent, String title ) {
	  _dialog = new JDialog( _parent = parent, title, true );
	}

	public String getValue()  { return _result; }

	public void show( String message,  String initialTextValue ) {
	  if( _dialog == null ) return;
	  if( initialTextValue != null ) { _result = initialTextValue; }

	  Container c = _dialog.getContentPane();
	  BoxLayout bl = new BoxLayout(c, BoxLayout.Y_AXIS );  c.setLayout( bl );
	  EmptyBorder eb5 = new EmptyBorder( 5, 5, 5, 5 );
	  Border bb = BorderFactory.createCompoundBorder( eb5, BorderFactory.createLoweredBevelBorder() );

	  _InputTextField = AttributeValuePair.New( message, true, 40 );
	  _InputTextField.setValue(_result);
	  c.add(_InputTextField);
	  c.add(constructButtonPanel());
	   JRootPane rp = _dialog.getRootPane();
	   rp.setDefaultButton( _defaultButton );

	  _dialog.pack();
	  if( _parent == null ) {
		SimIO.set_centered_location( _dialog, 0.5f, 0.2f );
	  }
	  _dialog.show();
	}

	JPanel constructButtonPanel() {
	  JPanel buttonPanel = new JPanel(false);
	  buttonPanel.setLayout(new FlowLayout());

	  JButton aButton = new JButton("cancel");
	  aButton.addActionListener( new CancelAction() );
	  buttonPanel.add( aButton );

	  aButton = new JButton("revert");
	  aButton.addActionListener( new RevertAction() );
	  buttonPanel.add( aButton );

	  aButton = new JButton("OK");
	  aButton.addActionListener( new OKAction() );
	  buttonPanel.add( aButton );
	  _defaultButton = aButton;

	  return buttonPanel;
	}

    class CancelAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		  _result = null;
		 _dialog.dispose();
		 _dialog = null;
	  }
    }
    class RevertAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		 _InputTextField.setValue(_result);
	  }
    }
    class OKAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		_result = _InputTextField.getValue();
		_dialog.dispose();
		_dialog = null;
	  }
    }

}

