package miiee.util;
import java.util.Vector;
import java.util.ListIterator;

public class SimulationData extends Vector {
  protected static int _simulation_index = 0;
  protected String _proj_name;
  protected String _model_name;
  protected String _proj_path;
  protected String _sim_name;
  protected int _index;

  public SimulationData( int index, String sim_name ) { 
	super(0,10);
	_index = index;  
	_sim_name = sim_name;
  }

  public SimulationData( String proj_name, String model_name, String proj_path ) { 
	super(16,16);
	_proj_name = proj_name;
	_model_name = model_name;
	_proj_path = proj_path;	
	_index = _simulation_index++;  
	_sim_name = _proj_name + "." + _model_name + "." +  _index;
  }

  public SimulationData( SimulationData sd ) { 
	this( sd._proj_name, sd._model_name, sd._proj_path );
  }

  public SimulationData( SimulationData sd, String sim_name ) { 
	this( sd );
	_sim_name = sim_name;
  }
  
  public void setSimName( String sim_name ) {
	_sim_name = sim_name;
  }

  public void setSimIndex( int simIndex ) {
	_index = simIndex;
  }
  
  public String toString() {
	return _sim_name;
  }

  public int simIndex() {
	return _index;
  }
  
  public String getProjPath() { return _proj_path; }
  public String getProjName() { return _proj_name; }
  public String getModelName() { return _model_name; }
  
  public boolean addDataSet( int dsetIndex, Object ds )  {
	boolean rv = true;
	if( dsetIndex >= size() ) { setSize(dsetIndex+16); }
	if( getDataSet(dsetIndex) != null ) { rv = false; }
	setElementAt(ds, dsetIndex);  
	SimIO.print( "SimulationData " + _index + ": Adding DataSet at index " + dsetIndex + ", ds: " + ds );
	return rv;
  }

  public Object getDataSet(int dsetIndex) {
	Object ds = null;
	try {
	  ds = elementAt(dsetIndex);
	} catch ( ArrayIndexOutOfBoundsException err ) {
	  SimIO.print( "SimulationData " + _index + ": No DataSet at index " + dsetIndex );
	}
	return ds;
  }

  public ListIterator getDatasetIterator() {
	ListIterator l = null;
	try {
	  l =  listIterator();
	} catch( NullPointerException err ) {;}
	return l;
  }

};

