package miiee.util;

import java.util.Vector;

//---- ConfigCommand  ---------------------------------------------------------

public class StringVector extends Vector  {
	protected StringBuffer _buffer = new StringBuffer(128);
	protected boolean isValid = true;
	
	public StringVector( int size, int incr ) { super(size,incr); }

	public StringVector() { super(16,16); }
			
	public void clear() { setSize(0); }
	  
	public int addArg( String arg ) {
	  add(arg);
	  return elementCount - 1;
	}

	public int addArgs( Vector args ) {
	  for( int i=0; i<elementCount; i++ ) {
		Object o = get(i);
		if( o != null ) { addArg( o ); }
	  }
	  return elementCount - 1;
	}
	
	public int addArg( int iarg ) {
	  add( Integer.toString(iarg) );
	  return elementCount - 1;
	}

	public int addArg( float farg ) {
	  add( Float.toString(farg) );
	  return elementCount - 1;
	}

	public int addArg( double d ) {
	  add( Double.toString(d) );
	  return elementCount - 1;
	}

	public int addArg( Object o ) {
	  add( o.toString() );
	  return elementCount - 1;
	}
	
	public String getArg( int index ) {
	  return (String) get(index);
	}

	private void refresh_buffer() {
	  _buffer.setLength(0);
	  _buffer.append( getPrefix() );
	  for( int i=0; i< size(); i++ ) {
		String arg = (String) get(i);
		if( arg != null ) {
		  _buffer.append( getPreSeparator(i) );
		  _buffer.append( arg );
		  _buffer.append( getPostSeparator(i) );
		}
	  }
	  _buffer.append( getSuffix() );
	}
	
	public String toString() {
	  refresh_buffer();
	  String rv = ( isValid ) ? _buffer.toString() : "";
	  return (rv == null) ? "" : rv;
	}
	
	public String toUnpaddedString() {
	  _buffer.setLength(0);
	  for( int i=0; i< size(); i++ ) {
		String arg = (String) get(i);
		if( arg != null ) {
		  _buffer.append( arg );
		}
	  }
	  String rv = ( isValid ) ? _buffer.toString() : "";
	  return (rv == null) ? "" : rv;
	}
	
	protected String getPrefix() { return "";}
	protected String getPreSeparator( int i ) { return " "; }
	protected String getPostSeparator( int i ) { return ""; }
	protected String getSuffix() { return ""; }
	public void invalidate() { isValid = false; }
	
	public byte[] getBytes() {
	  String s = toString();
	  return s.getBytes();
	}
}
