package miiee.util;

import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.Vector;

public class TextFrame extends Frame
    implements ActionListener, KeyListener
{

    public TextFrame(String title, String text, boolean disposable, AppletController ac)
    {
        super(title);
        _listeners = new Vector();
        _Text = new TextArea(text);
        _Text.setEditable(false);
        _Text.addKeyListener(this);
        _disposable = disposable;
        _ac = ac;
    }

    public TextFrame(String title, String cursor, boolean disposable, OutputStream os, AppletController ac)
    {
        super(title);
        _listeners = new Vector();
        _Text = new TextArea();
        _Text.setEditable(true);
        _Text.addKeyListener(this);
        _ostream = os;
        _cursor = cursor;
        _disposable = disposable;
        _ac = ac;
    }

    void init(boolean twoTextAreas)
    {
        _Bclose = new Button("Close");
        _Bclose.addActionListener(this);
        GridBagLayout gb = new GridBagLayout();
        setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.anchor = 11;
        c.weightx = 1.0D;
        c.weighty = 1.0D;
        c.insets = new Insets(5, 2, 1, 2);
        gb.setConstraints(_Text, c);
        add(_Text);
        if(twoTextAreas)
        {
            c.gridy = 1;
            _Text2 = new TextArea();
            _Text2.setEditable(false);
            gb.setConstraints(_Text2, c);
            add(_Text2);
            c.gridy = 2;
            c.weighty = 0.01D;
            c.fill = 2;
            c.anchor = 15;
            gb.setConstraints(_Bclose, c);
            add(_Bclose);
        }
        else
        {
            c.gridy = 1;
            c.weighty = 0.01D;
            c.fill = 2;
            c.anchor = 15;
            gb.setConstraints(_Bclose, c);
            add(_Bclose);
        }
        pack();
        Post(_cursor);
    }

    public void processFocusEvent(FocusEvent event)
    {
        _Bclose.requestFocus();
    }

    public void actionPerformed(ActionEvent e)
    {
        Object b = e.getSource();
        if(b == _Bclose)  {
            setVisible(false);
            if(_disposable)   {
                notifyTextInput("X");
                dispose();
                if(_ac != null)  _ac.notifyDisposed(this);
            }
            else   if(_ac != null)  _ac.notifyHidden(this);
        }
    }

    public void windowClosing(WindowEvent e)
    {
        setVisible(false);
        dispose();
        if(_ac != null)
            _ac.notifyDisposed(this);
    }

    public static TextFrame New(String title, String text, AppletController ac)
    {
        TextFrame tf = new TextFrame(title, text, false, ac);
        tf.init(false);
        return tf;
    }

    public static TextFrame NewShell(String title, String cursor, OutputStream os, AppletController ac)
    {
        TextFrame tf = new TextFrame(title, cursor, true, os, ac);
        tf.init(false);
        return tf;
    }

    public static TextFrame NewShell2(String title, String cursor, OutputStream os, AppletController ac)
    {
        TextFrame tf = new TextFrame(title, cursor, true, os, ac);
        tf.init(true);
        return tf;
    }

    public void Post(String text)
    {
        if(text != null)  _Text.append(text);
        if(_cursor != null) _Text.append("\n" + _cursor);
        _lastPosition = _Text.getText().length();
        _Text.setCaretPosition(_lastPosition);
    }

    public void Post2(String text)
    {
        if(_Text2 == null) return;
        if(text != null) _Text2.append(text);
        _lastPosition = _Text2.getText().length();
        _Text2.setCaretPosition(_lastPosition);
        Post(null);
    }

    public static TextFrame NewDisposable(String title, String text, AppletController ac)
    {
        TextFrame tf = new TextFrame(title, text, true, ac);
        tf.init(false);
        return tf;
    }

    public static void main(String args[])
    {
        TextFrame tf = New("About the TextFrame object", "This is a Demo!", null);
        tf.init(false);
        tf.setVisible(true);
    }

    public String getText()
    {
        return _Text.getText();
    }

    public void keyTyped(KeyEvent e)
    {
        char kc = e.getKeyChar();
        if(kc == '\n')
            try
            {
                _input_text = _Text.getText().substring(_lastPosition);
                if(_ostream != null) _ostream.write(_input_text.getBytes());
                _lastPosition = _Text.getText().length();
                _Text.setCaretPosition(_lastPosition);
                if(!_listeners.isEmpty())
                    notifyTextInput(_input_text);
            }
            catch(IOException ioex)
            {
                SimIO.print("Problem reading IO streams: " + ioex.getMessage());
            }
        else
        if(kc == '\b')
        {
            int kp = _Text.getCaretPosition();
            if(kc < _lastPosition)
                _lastPosition = kc;
        }
    }

    public void keyPressed(KeyEvent keyevent)
    {
    }

    public void keyReleased(KeyEvent keyevent)
    {
    }

    protected void notifyTextInput(String text)
    {
        DataDisplayEvent dde = new DataDisplayEvent(this, text);
        Vector l;
        synchronized(this) 
        {
            l = (Vector)_listeners.clone();
        }
        for(int i = 0; i < l.size(); i++)
            ((DataDisplayListener)l.elementAt(i)).textInput(dde);

    }

    public synchronized void addDataDisplayListener(DataDisplayListener ddl)
    {
        _listeners.addElement(ddl);
    }

    public synchronized void removeDataDisplayListener(DataDisplayListener ddl)
    {
        _listeners.removeElement(ddl);
    }

    private Button _Bclose;
    private TextArea _Text;
    private TextArea _Text2;
    private boolean _disposable;
    private String _cursor;
    private String _input_text;
    private Vector _listeners;
    private int _lastPosition;
    protected OutputStream _ostream;
    protected AppletController _ac;
}
