package miiee.util;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;
import javax.swing.text.*;
import java.util.HashMap;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.Component;
import java.awt.Color;

import java.io.Serializable;

public class TextPaneTableCellRenderer extends JTextArea implements TableCellRenderer {

    protected static Border _noFocusBorder; 
    Color _selectedeBG = new Color( 220, 220, 220 );
    Color _unSelectedeBG = new Color( 192, 192, 192 );
	private Font _font;    

    public TextPaneTableCellRenderer(  ) {
	  super();
	  _noFocusBorder = new EmptyBorder(1, 2, 1, 2);
	  setOpaque(true);
	  setLineWrap(true);
	  setWrapStyleWord(true);
	  setBorder(_noFocusBorder);
    }
    
    public void setFontSize( float font_size ) {
	  HashMap font_attr = new HashMap();
	  font_attr.put( TextAttribute.SIZE, new Float(font_size) );
	  _font = new Font(font_attr);
    }
    
    public Component getTableCellRendererComponent(JTable table, Object value,
                          boolean isSelected, boolean hasFocus, int row, int column) {

	  if (isSelected) {
		 super.setBackground( _selectedeBG );
	  }
	  else {
		  super.setBackground( _unSelectedeBG );
	  }

	  setFont( ( _font == null ) ? table.getFont() : _font );

	  if (hasFocus) {
		  setBorder( UIManager.getBorder("Table.focusCellHighlightBorder") );
		  if (table.isCellEditable(row, column)) {
			  super.setForeground( UIManager.getColor("Table.focusCellForeground") );
			  super.setBackground( UIManager.getColor("Table.focusCellBackground") );
		  }
	  } else {
		  setBorder(_noFocusBorder);
	  }

	  setValue(value); 

	  return this;
    }
    
    protected void setValue(Object value) {
	  setText((value == null) ? "" : value.toString());
    }


//    public static class UIResource extends TextPaneTableCellRenderer  implements javax.swing.plaf.UIResource {}

}


