package miiee.util;

import javax.swing.*;
import java.awt.event.*;
import java.util.Vector;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.border.*;
import java.util.ListIterator;
import java.awt.FlowLayout;

public class ViewerData {
	static ButtonGroup _bg = new  ButtonGroup();
	static JPanel _buttonPanel;
	static int _count = 0;
	static Vector _viewersData = new Vector(16,16); 
	boolean[] _displaysData = new boolean[4];
	JRadioButton _rButton;
	int _index;
	String _name;

	private ViewerData( String n, int index, boolean displays0D, boolean displays1D, boolean displays2D, boolean displays3D, ItemListener iL ) {
	   _name = n;
	   _index = index;
	   _displaysData[0] =  displays0D;
	   _displaysData[1] =  displays1D;
	   _displaysData[2] =  displays2D;
	   _displaysData[3] =  displays3D;
	   _rButton = new JRadioButton(n);
	   _rButton.setAlignmentX(Component.LEFT_ALIGNMENT);
	   _rButton.addItemListener(iL);
	   _rButton.setEnabled(false);
	   _bg.add( _rButton );
	   _buttonPanel.add( _rButton );
	}

	static public JPanel NewViewerData( String n, boolean displays0D, boolean displays1D, boolean displays2D, boolean displays3D, ItemListener iL ) {
	  if( _buttonPanel == null ) {
		_buttonPanel = new JPanel(true);
		BoxLayout bl = new BoxLayout(_buttonPanel, BoxLayout.Y_AXIS );  _buttonPanel.setLayout( bl );
		_buttonPanel.setBorder( 
		   BorderFactory.createCompoundBorder( 
//			  new BevelBorder( BevelBorder.LOWERED ), 
			  BorderFactory.createEtchedBorder(), 
			  new EmptyBorder( 7, 12, 7, 12 ) 
		   )  
		); 
	  }	
	  ViewerData vd = new ViewerData(n, _count++,displays0D, displays1D, displays2D,displays3D,iL);
	  _viewersData.addElement(vd);
	  return _buttonPanel;
	}

	public static int getSelectionIndex() {
	  ListIterator li = _viewersData.listIterator();
	  for( Object o = li.next(); li.hasNext(); o = li.next() ) {
		ViewerData vd = (ViewerData)o;
		AbstractButton b = vd._rButton;
		if( b.isSelected() && b.isEnabled() ) { return vd._index; }
	  }
	  return -1;
	}

	public static void setActivation( boolean[] hasData ) {
	  ListIterator li = _viewersData.listIterator();
	  for( Object o = li.next(); li.hasNext(); o = li.next() ) {
		ViewerData vd = (ViewerData)o;
		vd.setLocalActivation( hasData );
	  }
	}

	private boolean setLocalActivation( boolean[] hasData ) {
	  boolean rv = false;
	  try {
		rv =  ( hasData[0] && _displaysData[0] ) || ( hasData[1] && _displaysData[1] ) || ( hasData[2] && _displaysData[2] ) || ( hasData[3] && _displaysData[3] ); 
	  } catch ( ArrayIndexOutOfBoundsException err ) { rv = false; }
	  _rButton.setEnabled(rv);
	  return rv;		
	}
	
	public static boolean checkDataValidity( int viewer_index, int dim ) {
	  if( viewer_index < 0 ) return true;
	  try {
		ViewerData vd = (ViewerData) _viewersData.elementAt(viewer_index);
		return vd._displaysData[dim];
	  } catch ( ArrayIndexOutOfBoundsException err ) { return false; }
	}
};
