package miiee.visad;

import visad.*;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.util.VisADSlider;
import java.rmi.RemoteException;
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.image.*;
import java.io.*;
import java.awt.geom.AffineTransform;
import miiee.util.DataDisplayListener;
import miiee.util.DataDisplayEvent;
import miiee.util.AnimationStepper;
import miiee.util.SimIO;

public class AnimationImage3D extends JPanel implements  AnimationStepper {

  CoordinateSystem _coords;
  AnimationControl _anim_controller;
  boolean _slave_process = false;
  Cell _range_cell;
//  VisADSlider _range_slider;
  private int _anim_control_mode = ANIM_WAIT;
  javax.swing.plaf.basic.BasicArrowButton _stepButton;
  FunctionType _grid_type;
  Integer2DSet _domain_set;	 
  DisplayImplJ3D _display;
  boolean _forward_anim = true;	 
   boolean _debug = true;	 
 FieldImpl _animation_sequence;
  ScalarMap _range_map;	 
  ScalarMap _color_map;	
  int _num_images;
  static RealType _row_type;
  static RealType _col_type;
  static RealType _range_type;

    public static final int ANIM_EXIT	= 0;
    public static final int ANIM_RUN	= 1;
    public static final int ANIM_PAUSE	= 2;
    public static final int ANIM_STEP	= 3;
    public static final int ANIM_WAIT	= 4;
  
  int pow2( int exp ) {
	int rv = 1;
	while( exp-- > 0 ) { rv *= 2; }
	return rv;
  }
      
  public AnimationImage3D( int length1, int length2, int max_images, boolean flat ) 																
																throws VisADException, RemoteException {
	  try { 
		RealType time = RealType.Time;
		RealTupleType time_type = new RealTupleType(time);
	  
		Set time_set = new Linear1DSet(time_type, 0.0, 1.0, max_images);	  
		_domain_set = new Integer2DSet(length1,length2);

		if( _row_type == null ) {  _row_type = new RealType("row",null,null); }
		if( _col_type == null ) {  _col_type = new RealType("col",null,null); }
		if( _range_type == null ) {  _range_type = new RealType("range",null,null); }

		RealType[] types2d = { _row_type, _col_type };
		RealTupleType domain_type = new RealTupleType( types2d, null, _domain_set );
		
		_grid_type =  new FunctionType( domain_type, _range_type );
		FunctionType animation_type =  new FunctionType( time_type, _grid_type );
		_animation_sequence = new FieldImpl( animation_type, time_set );
				
		_display = new DisplayImplJ3D("image display");
		_display.addMap(new ScalarMap( _row_type, Display.XAxis));
		_display.addMap(new ScalarMap( _col_type, Display.YAxis));
		
		if( !flat ) { 
		   ScalarMap _range_map = new ScalarMap( _range_type, Display.ZAxis );
		   _display.addMap( _range_map ); 
		} 
		
		_color_map = new ScalarMap( _range_type, Display.RGB );
		_display.addMap( _color_map );

		ScalarMap map1animation = new ScalarMap(RealType.Time, Display.Animation);
		_display.addMap(map1animation);

		_anim_controller = (AnimationControl) map1animation.getControl();
		_anim_controller.setStep(500);

		final DataReference _image_ref =  new DataReferenceImpl("image");
		_image_ref.setData( _animation_sequence );
		_display.addReference( _image_ref );
		
	  } catch ( java.lang.NoClassDefFoundError err ) { 
		print( "error: can't find VisAD or Java3D class: " + err.getMessage() ); 
		err.printStackTrace();
	  }

	  setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	  setAlignmentY(JPanel.TOP_ALIGNMENT);
	  setAlignmentX(JPanel.LEFT_ALIGNMENT);

	  if( _display != null ) { add(_display.getComponent()); }
	  print( "Completed AnimationImage3d setup." );
  }
    
  public void SetRange( double fmin, double fmax ) throws VisADException, RemoteException {
	  if( _range_map != null ) { _range_map.setRange(fmin,fmax); }
	  _color_map.setRange(fmin,fmax);
  }
  																		
  public void CreateImage(  float[] data, float min_data_val, float max_data_val, int nbytes, boolean copy )  throws VisADException, RemoteException  {
	Linear1DSet[] range_sets = new Linear1DSet[1];
	int length = pow2( 8*nbytes )-1;
	range_sets[0] = new Linear1DSet( min_data_val, max_data_val, length );
	FlatField f = new FlatField( _grid_type, _domain_set, _coords, range_sets, null );
	float[][] range_data = new float[1][];
	range_data[0] = data;
	f.setSamples(range_data,copy);
	print( " add image " + _num_images );
	_animation_sequence.setSample( _num_images++, f );
  }

  public void CreateImage(  float[] data, boolean copy )  throws VisADException, RemoteException  {
	FlatField f = new FlatField( _grid_type, _domain_set );
	float[][] range_data = new float[1][];
	range_data[0] = data;
	f.setSamples(range_data,copy);
	print( " add image " + _num_images );
	_animation_sequence.setSample( _num_images++, f );
  }
/*
    public synchronized void start()  {
		if( _animThread == null ) {
//		  addMouseListener(this);
//		  addMouseMotionListener(this);
		  if( !_slave_process ) {
			_animThread= new Thread(((Runnable)this)); 
			_animThread.start(); 
			SimIO.print(" Starting " + _animThread ); 
		  }
		}
    }
	public void stop() {
	  if( _animThread != null ) { 
		_anim_control_mode = ANIM_EXIT;
		_animThread = null;
	  }
	}
	   
    public void run() {
        while ( _anim_control_mode != ANIM_EXIT ) {
            try {  Thread.sleep(200L);   }
            catch (InterruptedException e0) {  return;  }
            
            switch ( _anim_control_mode ) {
                case ANIM_PAUSE: 
					continue;
                case ANIM_STEP:
                    stepVisAD();
                    repaint();
                    _anim_control_mode= ANIM_PAUSE; 
                    continue;
                case ANIM_RUN:
					stepVisAD();
					repaint();
					continue;
                case ANIM_WAIT:
					repaint();
					continue;
            }
        }
    } 
    
	public void stepAnimation() { 
	  SimIO.print("Stepping animation.");
	  _anim_control_mode = ANIM_STEP;
	}

	public void pauseAnimation() { 
	  _anim_control_mode = ANIM_PAUSE;
	}

	public void runAnimation() { 
	  _anim_control_mode = ANIM_RUN;
	}
 */
     
  public void runAnimation() {
	 if( _debug ) SimIO.print("Run Animation");	  
	 try { 
	  _anim_controller.setOn(true);
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	} catch( VisADException err ) {
	  print(err);
	} catch( RemoteException err ) {
	  print(err);
	}
  } 

  public void pauseAnimation() {
 	  
	 try { 
	  _anim_controller.setOn(false);
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	} catch( VisADException err ) {
	  print(err);
	} catch( RemoteException err ) {
	  print(err);
	}
  } 


  public void stepAnimation() {
	 if( _debug ) SimIO.print("Step Animation");	  
	 try { 
	  _anim_controller.takeStep();
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	} catch( VisADException err ) {
	  print(err);
	} catch( RemoteException err ) {
	  print(err);
	}
	if( _debug ) SimIO.print("done");	  
  } 

  public int setAnimationTime( float time, boolean forward ) {
	int max_index = _num_images - 1;
	_forward_anim = forward;
	int index = Math.round( time / getTimestep() );
	index = ( index > max_index ) ? max_index : index;
	setAnimationIndex( index );
	if( forward ) {
	  if ( index == max_index ) return 2;
	  else return 1;
	} else {
	  if ( index == 0 ) return 2;
	  else return 1;
	}
  }

	public void setBoundingBox( boolean box_on ) {
		try {
		   _display.getDisplayRenderer().setBoxOn(box_on);
		} catch ( java.lang.NullPointerException err ) { 
		  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
		  err.printStackTrace();
		} catch( VisADException err ) {
		  print(err);
		} catch( RemoteException err ) {
		  print(err);
		}
	}

  public float getTime() { return 1.0f; }

  public float getTimestep() { return 1.0f; }
  public float getBaseTimestep() { return 1.0f; }
  
  public void reverse()  throws VisADException, RemoteException {
 	  
	 try { 
	  _anim_controller.setDirection(_forward_anim = !_forward_anim );
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	}
  } 
  
  public void setAnimationIndex(int c){
 	   
	 try { 
	  _anim_controller.setCurrent(c);
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	} catch( VisADException err ) {
	  print(err);
	} catch( RemoteException err ) {
	  print(err);
	}
  } 
   

  public static void main(String args[])
         throws VisADException, RemoteException, IOException {

	int length1 = 64;
	int length2 = 64;
	int max_images = 5;
	
  // create JFrame (i.e., a window) for display and slider
    JFrame frame = new JFrame("Simple VisAD Image Animator");
    frame.addWindowListener(
		new WindowAdapter() {
		  public void windowClosing(WindowEvent e) {System.exit(0);}
		}
	);

	// Add image display to Frame.
	
	AnimationImage3D iDisplay = new AnimationImage3D( length1, length2, max_images, false );
	frame.getContentPane().add(iDisplay);

    // set size of JFrame and make it visible
    frame.setSize(500, 600);
    frame.setVisible(true);
	
	for( int i=0; i<max_images; i++ ) {
	  float min_value = Float.MAX_VALUE, max_value = Float.MIN_VALUE;
	  float[] data = new float[length1*length2];
	  for( int i2 = 0; i2<length2; i2++ ) {
		for( int i1 = 0; i1<length1; i1++ ) {
		  int index = i1 + i2*length1;
		  int a = max_images - i;
		  int b = i+1;
		  float value = (i2*i2/a) + (i1*i1/b);
		  min_value = (value < min_value) ? value : min_value;
		  max_value = (value > max_value) ? value : max_value;
		  data[index] = value;
		  if( value > max_value ) max_value = value;
		}
	  }
	  iDisplay.CreateImage( data, false );
	}
		
	iDisplay.stepAnimation();
	
  }
  
  void print(String msg) {
	System.out.print("\nJAVA: " + msg);
  }
  void print(VisADException e) {
	System.out.print("\nJAVA VisADException: " + e);
  }
  void print(RemoteException e) {
	System.out.print("\nJAVA RemoteException: " + e);
  }

}
