package miiee.visad;

import javax.swing.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.rmi.RemoteException;
import java.applet.Applet;
import visad.VisADException;
import miiee.util.*;
import java.util.Vector;

class Create3dViewerAction extends QueuedExecutable  {
  Vector _datasets; 
  public Create3dViewerAction( Vector datasets ) { _datasets = datasets;  }
  public void execute() {
	  if( _datasets.size() == 0 ) { SimIO.beep(); return; }
	  DataSet d = (DataSet) _datasets.elementAt(0);
	  SimulationData sd = d.getSimulationData();
	  if( _datasets.size() == 1 ) {
		AnimationViewer3DV av = new AnimationViewer3DV( d, sd.simIndex(), d.size() );
		AppContainer ac = new AppContainer( d.toString(), av, null);
		ac.setVisible(true);

//		d.addEntryDataListener(av);

		int dsize = d.size();
		float gmax = d.getDataMax( );
		float gmin = d.getDataMin( );
		for( int i=0; i<dsize; i++ ) {		
			DataEntry de = d.getEntry(i);
			float[] fdata = av.createDataArray( de, gmax, gmin );	
			av.addDataArray( fdata, d.toString(), de.time() );
		}

	  } else {
//		showDataSetSelectionDialog( dataSets );
	  }
	}
} 

public class AnimationViewer3DV extends JPanel implements AppletKernel
{
    /** Animation. */
    protected AnimationImage3D       _animation;
    protected JFrame _frame;
    protected DataSet _dataset;
    
    protected AttributeValuePair _time;
    protected AttributeValuePair _value;
    protected AttributeValuePair _scale;
    protected AnimationControlPanel _controlPanel;
    protected int _max_images;
    protected int _width;
    protected int _height;
    protected String _name;
    protected int _group_index = 0;
	protected boolean _debug = true;
	protected boolean _internal_button_panel = false;

    /**
      * Constructs a new instance of AnimationViewer.
      */

    public AnimationViewer3DV( int width, int height, int max_images, String name, byte region_map[] ) {
		try {
		   _animation = new AnimationImage3D( width, height, max_images, false );
		} 
		catch ( VisADException ve ) { print(ve);}
		catch ( RemoteException re ) { print(re);}
	
		_max_images = max_images;
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = height;
		_width = width;
    }

    public AnimationViewer3DV( DataSet d, int group_index, int max_images ) {
		_group_index = group_index;
		try {
		   _animation = new AnimationImage3D( d.size(0), d.size(1), max_images, false );
		} 
		catch ( VisADException ve ) { print(ve);}
		catch ( RemoteException re ) { print(re);}
		
		_max_images = max_images;
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = d.size(0);
		_width = d.size(1);
		_name = d.toString();
		_dataset = d;
    }
    
    public DataSet getDataSet() { return _dataset; }

    public void init() {
		if( _frame != null ) { 
		  _frame.setBackground(Color.lightGray);	
		  _frame.setSize(400,400);
		  _frame.show();
		}		
		setLayout(new BorderLayout());
		add( "Center", _animation );
		add( "South", constructOptionsPanel());
		
		if( _controlPanel == null ) {
		  _controlPanel = AnimationControlPanel.GetControlPanel( _group_index, "3D control" );
		  _controlPanel.addAnimation(_animation);
		}
		_controlPanel.showPanel();		
    }
    
    public void start() { ; }

    /** Constructs a JPanel containing check boxes for the different
      * options that tree supports. */
    private JPanel constructOptionsPanel() {
	JCheckBox               aCheckbox;
	JPanel           borderPane = new JPanel(false);

	borderPane.setLayout(new GridLayout(3,1));

	JButton aButton;
	JPanel           buttonPanel = new JPanel(false);
	buttonPanel.setLayout(new FlowLayout());

	if( _internal_button_panel ) {	
		aButton = new JButton("step");
		aButton.addActionListener( new StepAction() );
		buttonPanel.add( aButton );

		aButton = new JButton("stop");
		aButton.addActionListener( new StopAction() );
		buttonPanel.add( aButton );

		aButton = new JButton("run");
		aButton.addActionListener( new RunAction() );
		buttonPanel.add( aButton );

		aButton = new JButton("rescale");
		aButton.addActionListener( new ScaleAction() );
		buttonPanel.add( aButton );
	}
	
	aCheckbox = new JCheckBox("box");
	aCheckbox.setSelected(true);
	aCheckbox.addChangeListener(new BoundingBoxChangeListener());
	buttonPanel.add(aCheckbox);
	borderPane.add(buttonPanel);

	JPanel   infoPanel = new JPanel(false);
	infoPanel.setLayout(new FlowLayout());

	_time = AttributeValuePair.New( "time", false, 8 );
	infoPanel.add(_time);

	borderPane.add(infoPanel);

	JPanel   infoPanel1 = new JPanel(false);
	infoPanel1.setLayout(new FlowLayout());

	_scale = AttributeValuePair.New( "scale", false, 18 );
	infoPanel1.add(_scale);
	
	borderPane.add(infoPanel1);

	return borderPane;
    }

    /** Construct a menu

    private JMenuBar constructMenuBar() {
	JMenu            menu;
	JMenuBar         menuBar = new JMenuBar();
	JMenuItem        menuItem;

	menu = new JMenu("File");
	menu.setBackground(Color.lightGray);
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("Save"));
	menuItem.addActionListener(new SaveAction());

	menuItem = menu.add(new JMenuItem("Quit"));
	menuItem.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		   _frame.dispose();
	    }});

	menu = new JMenu("View");
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("1"));
//	menuItem.addActionListener(new InsertAction());

	menuItem = menu.add(new JMenuItem("2"));
//	menuItem.addActionListener(new ReloadAction());

	menuItem = menu.add(new JMenuItem("3"));
//	menuItem.addActionListener(new RemoveAction());

	_value = AttributeValuePair.New( "value:", false, 15 );
	menuBar.add(_value);

	return menuBar;
    }
*/
    /**
      * SaveAction is used to add a new item after the selected item.
      */
    class SaveAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
//		try {
//			_animation.SaveJPEG();
//		} catch( java.io.IOException ioex ) { SimIO.print( "Error saving jpeg file: " + ioex); } 
	  }
    } // End of SaveAction


    class StepAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		  _animation.stepAnimation();
	  }
    } 
    class StopAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		  _animation.pauseAnimation();
	  }
    } 
    class RunAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		  _animation.runAnimation();
	  }
    } 
    class ScaleAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
//		_animation.SetAutoscale(true);
	  }
    } 

   /**
      * SmmothImagesChangeListener implements the ChangeListener interface
      * to toggle the state of showing the handles in the tree.
      */
    class BoundingBoxChangeListener extends Object implements ChangeListener {
	  public void stateChanged(ChangeEvent e) {
		  _animation.setBoundingBox(((JCheckBox)e.getSource()).isSelected());
	  }
    } 
	
    public  void timeChanged( float time, int index ) { 
	  _time.setValue( Float.toString(time) );
	  _time.refreshImmediately();
	}

    public  void pointSelected( int row, int col, float value ){
	  FormattedFloat fval = new FormattedFloat(value);
	  String val = "(" + Integer.toString(row) + "," + Integer.toString(col) + "): " + fval.toJavaFormatString(4);
	  _value.setValue(val);
   }

    public  void regionSelected( int row0, int col0, int row1, int col1 ) {;}

    public void scaleChangedSO( float scale, float offset ) {
	  FormattedFloat fscale = new FormattedFloat(scale);
	  FormattedFloat foffset = new FormattedFloat(offset);
	  String val = "s: " + fscale.toJavaFormatString(4) + ", o: " + foffset.toJavaFormatString(4);
	  _scale.setValue(val);
    }

    public void scaleChangedMM( float max, float min ) {
	  FormattedFloat fmax = new FormattedFloat(max);
	  FormattedFloat fmin = new FormattedFloat(min);
	  String val = "max: " + fmax.toJavaFormatString(4) + ", min: " + fmin.toJavaFormatString(4);
	  _scale.setValue(val);
    }

	public void initDemo() {
		float scale[] = { 0.0f, 1.0f };
	   
		for( int i=0; i<_max_images; i++ ) {
		  float[] data = new float[_height*_width];  
		  for( int i1 = 0; i1<_height; i1++ ) {
			for( int i2 = 0; i2<_width; i2++ ) {
			  int index = i2 + i1*_width;
			  float a = _max_images - i;
			  float b = i+3;
			  float value =  (float) ( 2 + Math.sin((a*i1)/_height) + Math.cos((b*i2)/_width) );
			  data[index] = value;
			}
		  }
		  addDataArray( data, " ", i );
		}	
	}

	 public float[] createDataArray( DataEntry de, float gmax, float gmin ) {	
		boolean isBackground = false;
		byte[] activation_map= _dataset.getActiveRegion();
		int height = _dataset.size(0);
		int width = _dataset.size(1);
		byte data_format = _dataset.format();	
		int mi0 = 0;
		float[] fdata = new float[ width * height ];

		for(int i=0; i<height; i++ ) {
		  for(int j=0; j<width; j++ ) {	  
			int index0 = j + i*width;
			if( activation_map != null ) {
			  isBackground = ( activation_map[index0] == 0 );
			}			
			if( isBackground ) { 
				fdata[index0] = 0f;
			} else {
			  int mindex = ( data_format == 0 ) ?  index0 : mi0++;
			  float z = de.getNormalizedValue( mindex, gmax, gmin );
			  if( z == Float.MAX_VALUE ) { z = 0f; } 
			  fdata[index0] = z;
			}
		}
	  }
	  return fdata;
	}
	  
    static public void create3dViewer( Vector dataSets ) {
		Create3dViewerAction va = new Create3dViewerAction(dataSets);
		va.actionPerformed(null);
    }

    static public void main(String args[]) {  
		int width = 75, height = 60;
		int max_images = 3;
		AnimationViewer3DV av = new AnimationViewer3DV(width,height,max_images,"test animator",null);
		AppContainer ac = new AppContainer("test animator", av, null);
		ac.setVisible(true);

		float scale[] = { 0.0f, 1.0f };
	   
		for( int i=0; i<max_images; i++ ) {
		  float[] data = new float[height*width];
		  for( int i1 = 0; i1<height; i1++ ) {
			for( int i2 = 0; i2<width; i2++ ) {
			  int index = i2 + i1*width;
			  int a = max_images - i;
			  int b = i+1;
			  data[index] = (float) Math.sin( ((i2/a) + (i1/b)) );
			}
		  }
		  av.addDataArray( data, "test" + i, i );
		}
    }
    
    public synchronized int addDataArray( float[] data, String info, float time ) {
		try {		  
		  _animation.CreateImage(data,false);		  
		} 
		catch ( VisADException ve ) { print(ve);}
		catch ( RemoteException re ) { print(re);}
		
		SimIO.print("Animation3D: adding data array: " + info + " for time " + time );

        return 0; 
    }
    
    public void stop() { 
	  if( _animation != null ) {
//		_animation.stop();  
	  }
	}
    
    public void destroy() {  
		if( _controlPanel != null ) {
		  int na = _controlPanel.closeAnimation(_animation); 
		  if( na == 0 ) {
			AnimationControlPanel.closeControlPanel( _group_index );
			_controlPanel = null;
		  }
		}
	  _animation = null;
	}
	
    public void dispose() {  
	  if( _frame != null )  {
		_frame.setVisible(false);
		_frame.dispose();
	  }
	}
	
    synchronized public void intervalAdded(ListDataEvent e) {;}   

    public void intervalRemoved(ListDataEvent e){;}
    public void contentsChanged(ListDataEvent e){;}

	void print(String msg) {
	  System.out.print("\nJAVA: " + msg);
	}
	void print(VisADException e) {
	  System.out.print("\nJAVA VisADException: " + e);
	  if( _debug ) e.printStackTrace();
	}
	void print(RemoteException e) {
	  System.out.print("\nJAVA RemoteException: " + e);
	  if( _debug ) e.printStackTrace();
  }
  
  public void setFrame(JFrame f) {  _frame = f; }
  public Container getContentPane() { return this; }
/*
    synchronized public void intervalAdded(ListDataEvent e) {
	  DataSet d = (DataSet) e.getSource();
	  int index_added = e.getIndex1();

	  for( int i= _animation.Size(); i <= index_added; i++ ) { 
		DataEntry de = d.getEntry(i);
		if( de != null ) { CreateImage( de ); }
	  }

    }   

    public void intervalRemoved(ListDataEvent e){;}
    public void contentsChanged(ListDataEvent e){;}
*/
}
