package miiee.visad;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.image.*;
import java.io.*;
import visad.*;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.util.VisADSlider;
import java.rmi.RemoteException;
import java.util.Vector;
import miiee.util.DataDisplayListener;
import miiee.util.DataDisplayEvent;

public class ContourImage3D extends javax.swing.JPanel implements ControlListener {

  CoordinateSystem _coords;
  AnimationControl _anim_controller;
  ContourControl _contour_controller;
  Cell _range_cell;
  int _current_index = 0;
  ScalarMap _range_map;	 
  ScalarMap _color_map;	
  ScalarMap _map1animation;
  RealType _range_type;
//  VisADSlider _range_slider;
  javax.swing.plaf.basic.BasicArrowButton _stepButton;
  FunctionType _grid_type;
  Set _domain_set;	 
  DisplayImplJ3D _display;
  boolean _forward_anim = true;	
  FieldImpl _animation_sequence;
  int _num_images;
  float _contour_level = 0.5f;
  protected Vector _imageData;

	class  Scale {
		public float _max;
		public float _min;

		public Scale()
		{
			_min= (float) 3.4028235E38; 
			_max= (float) -3.4028235E38; 
		}
	}

	class  ImageData {
		public String _info;
		public Scale _scale;
		public float[] _data;
		public int _data_size;
		public float _time;

		public ImageData( String info, float[] data, int data_size, float time )  {
			_scale= new Scale(); 
			_data= data; 
			_info= info; 
			_data_size = data_size;
			_time = time;
		}

		public final void SetScale( float max, float min) {
		  if( max < min ) CalcScaling();
		  else {
			_scale._max= max; 
			_scale._min= min; 
		  }
		}
		
		public final void CalcScaling() {
		  float d;
		  for (int i=0; i<_data_size; i++ ) {
			d = _data[i];
			if( d > _scale._max ) _scale._max = d;
			if( d < _scale._min ) _scale._min = d;
		  }
		}

	}
        
  public ContourImage3D( int length1, int length2, int length3, int n_images )  throws VisADException, RemoteException {
	  try { 
		RealType time = RealType.Time;
		RealTupleType time_type = new RealTupleType(time);
	  
		Set time_set = new Linear1DSet(time_type, 0.0, 1.0, n_images);	  
		_domain_set = new Integer3DSet(length1,length2,length3);

		RealType x_type = new RealType("x",null,null);
		RealType y_type = new RealType("y",null,null);
		RealType z_type = new RealType("z",null,null);
		_range_type = new RealType("range",null,null);

		RealType[] types3d = { x_type, y_type, z_type };
		RealTupleType domain_type = new RealTupleType( types3d, null, _domain_set );
		
		_grid_type =  new FunctionType( domain_type, _range_type );
		FunctionType animation_type =  new FunctionType( time_type, _grid_type );
		_animation_sequence = new FieldImpl( animation_type, time_set );
				
		_display = new DisplayImplJ3D("image display");
		_display.addMap(new ScalarMap( x_type, Display.XAxis));
		_display.addMap(new ScalarMap( y_type, Display.YAxis));
		_display.addMap(new ScalarMap( z_type, Display.ZAxis));
		
//		_color_map = new ScalarMap( _range_type, Display.RGB );
//		_display.addMap( _color_map );
		
		ScalarMap contour_map = new ScalarMap( _range_type, Display.IsoContour );
		_display.addMap(contour_map);
		_contour_controller = (ContourControl) contour_map.getControl();
		_contour_controller.setSurfaceValue(0f);
		_contour_controller.enableContours(true);
		
		_map1animation = new ScalarMap(RealType.Time, Display.Animation);
		_display.addMap(_map1animation);

		_anim_controller = (AnimationControl) _map1animation.getControl();
		_anim_controller.setStep(3000);
		((Control)_anim_controller).addControlListener(this);


		final DataReference _image_ref =  new DataReferenceImpl("image");
		_image_ref.setData( _animation_sequence );
		_display.addReference( _image_ref );
		
	  } catch ( java.lang.NoClassDefFoundError err ) { 
		print( "error: can't find VisAD or Java3D class: " + err.getMessage() ); 
		err.printStackTrace();
	  }

	  setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	  setAlignmentY(JPanel.TOP_ALIGNMENT);
	  setAlignmentX(JPanel.LEFT_ALIGNMENT);

	  if( _display != null ) { add(_display.getComponent()); }
	  _imageData = new Vector(16,16);
	  print( "Completed ContourImage3d setup." );
  }

  public ContourImage3D( int length1, int length2, int n_images )  throws VisADException, RemoteException {  
	  try { 
		RealType time = RealType.Time;
		RealTupleType time_type = new RealTupleType(time);
	  
		Set time_set = new Linear1DSet(time_type, 0.0, 1.0, n_images);	  
		_domain_set = new Integer2DSet(length1,length2);

		RealType x_type = new RealType("x",null,null);
		RealType y_type = new RealType("y",null,null);
		RealType z_type = new RealType("z",null,null);
		_range_type = new RealType("range",null,null);

		RealType[] types2d = { x_type, y_type  };
		RealTupleType domain_type = new RealTupleType( types2d, null, _domain_set );
		
		_grid_type =  new FunctionType( domain_type, _range_type );
		FunctionType animation_type =  new FunctionType( time_type, _grid_type );
		_animation_sequence = new FieldImpl( animation_type, time_set );
				
		_display = new DisplayImplJ3D("image display");
		_display.addMap(new ScalarMap( x_type, Display.XAxis));
		_display.addMap(new ScalarMap( y_type, Display.YAxis));
		
		_range_map = new ScalarMap( _range_type, Display.ZAxis);
		_display.addMap( _range_map );
				
//		_color_map = new ScalarMap( _range_type, Display.RGB );
//		_display.addMap( _color_map );

		_map1animation = new ScalarMap(RealType.Time, Display.Animation);
		_display.addMap(_map1animation);

		_anim_controller = (AnimationControl) _map1animation.getControl();
		_anim_controller.setStep(3000);
		((Control)_anim_controller).addControlListener(this);

		final DataReference _image_ref =  new DataReferenceImpl("image");
		_image_ref.setData( _animation_sequence );
		_display.addReference( _image_ref );
		
	  } catch ( java.lang.NoClassDefFoundError err ) { 
		print( "error: can't find VisAD or Java3D class: " + err.getMessage() ); 
		err.printStackTrace();
	  } catch ( Exception err1 ) { 
		print( "ContourImage definition error: " + err1.getMessage() ); 
		err1.printStackTrace();
	  }

	  setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	  setAlignmentY(JPanel.TOP_ALIGNMENT);
	  setAlignmentX(JPanel.LEFT_ALIGNMENT);

	  if( _display != null ) { add(_display.getComponent()); }
	  _imageData = new Vector(16,16);
	  print( "Completed ContourImage3d setup." );
  }

  public void CreateImage(  float[] data, float min_val, float max_val, float time, String info, boolean copy )  throws VisADException, RemoteException  {
  
	ImageData id = new ImageData(info,data,_domain_set.getLength(),time);
	id.SetScale(min_val,max_val);
	if( _num_images >= _imageData.size() ) { _imageData.setSize(_num_images+16); }
	_imageData.set( _num_images, id ); 
	
	FlatField f = new FlatField( _grid_type, _domain_set );
	float[][] range_data = new float[1][];
	range_data[0] = data;
	f.setSamples(range_data,copy);
	print( " add image " + _num_images );
	_animation_sequence.setSample( _num_images++, f );
  }
  
  public void SetRange( double fmin, double fmax ) throws VisADException, RemoteException {
	  if( _range_map != null ) { _range_map.setRange(fmin,fmax); }
	  _color_map.setRange(fmin,fmax);
  }

  public void setContourLevelProportional( float contour_proportion )  throws VisADException, RemoteException {   
	  _contour_level = contour_proportion;                        // contour_proportion E [0,1] -> [min_val,max_val]
	  ImageData id =  null;
	  try {
		id = (ImageData) _imageData.elementAt( _current_index );
	  } catch ( IndexOutOfBoundsException ab_ex ) { 
		print("attempt to rescale unknown image"); 
		return;
	  } catch ( java.lang.NullPointerException err ) { 
		return;
	  }
	  try {
		 float max = id._scale._max; 
		 float min = id._scale._min; 
		 float clevel = min + contour_proportion * ( max - min );
		 _contour_controller.setSurfaceValue( clevel );
	  } catch ( java.lang.NullPointerException err ) { 
		print( " no info on image : " + _current_index ); 
	  }
  }
        
  public void RunAnimation()  throws VisADException, RemoteException {
	 try { 
	  _anim_controller.setOn(true);
	  _anim_controller.run();
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	}
  } 

  public void PauseAnimation()  throws VisADException, RemoteException {
 	  
	 try { 
	  _anim_controller.setOn(false);
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	}
  } 

  public void StepAnimation()  throws VisADException, RemoteException {
 	  
	 try { 
	  _anim_controller.takeStep();
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	}
  } 
  
  public void Reverse()  throws VisADException, RemoteException {
 	  
	 try { 
	  _anim_controller.setDirection(_forward_anim = !_forward_anim );
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	}
  } 
  
  public void setCurrent(int c)  throws VisADException, RemoteException {
 	   
	 try { 
	  _anim_controller.setCurrent(c);
	} catch ( java.lang.NullPointerException err ) { 
	  print( "error: incomplete VisAD setup: " + err.getMessage() ); 
	  err.printStackTrace();
	}
  } 
   

  public static void main(String args[])
         throws VisADException, RemoteException, IOException {

	int ndim = 3;		
	int length1 = 16;
	int length2 = 16;
	int length3 = (ndim==3) ? 16 : 1;
	int max_images = 3;
	
  // create JFrame (i.e., a window) for display and slider
    JFrame frame = new JFrame("Simple VisAD Image Animator");
    frame.addWindowListener(
		new WindowAdapter() {
		  public void windowClosing(WindowEvent e) {System.exit(0);}
		}
	);

	// Add image display to Frame.

	ContourImage3D iDisplay = (ndim == 3) ? new ContourImage3D( length1, length2, length3, max_images ) : 
											new ContourImage3D( length1, length2, max_images );
											
	frame.getContentPane().add(iDisplay);

    // set size of JFrame and make it visible
    frame.setSize(500, 600);
    frame.setVisible(true);
	int a = 2, b = 5, c = 3;
	float pi = (float)Math.PI;
	float l1 = length1, l2 = length2, l3 = length3;

	for( int i=0; i<max_images; i++ ) {	    
	  int index = 0; 
	  float min_value = Float.MAX_VALUE, max_value = Float.MIN_VALUE;
	  float[] data = new float[length1*length2*length3];
	  for( int i3 = 0; i3<length3; i3++ ) {
		for( int i2 = 0; i2<length2; i2++ ) {
		  for( int i1 = 0; i1<length1; i1++ ) {
			float value = (float) ( Math.sin((i1/l1)*a*pi) + Math.sin((i2/l2)*b*pi) + Math.sin((i3/l3)*c*pi) );
			min_value = (value < min_value) ? value : min_value;
			max_value = (value > max_value) ? value : max_value;
			data[index++] = value;
		  }
		}
	  }
	  iDisplay.CreateImage( data, min_value, max_value, i, " ", false );  
	  a++; b++; c++;
	}
  }
		
  
  void print(String msg) {
	System.out.print("\nJAVA: " + msg);
  }
  void print(VisADException e) {
	System.out.print("\nJAVA VisADException: " + e);
  }
  void print(RemoteException e) {
	System.out.print("\nJAVA RemoteException: " + e);
  }

  public void controlChanged(ControlEvent e)  throws VisADException, RemoteException {
	AnimationControl ac = (AnimationControl) e.getControl();
	_current_index = ac.getCurrent();
	print("Current index: " + _current_index  );
	setContourLevelProportional( _contour_level );
  }

}
