package miiee.visad;

import visad.*;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.util.VisADSlider;
import java.rmi.RemoteException;
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ContourImageTest extends JPanel {

  CoordinateSystem _coords;
  AnimationControl _anim_controller;
  ContourControl _contour_controller;
  Cell _range_cell;
  ScalarMap _range_map;	 
  ScalarMap _color_map;	
  RealType _range_type;
  FunctionType _grid_type;
  Set _domain_set;	 
  DisplayImplJ3D _display;
  boolean _forward_anim = true;	
  FieldImpl _animation_sequence;
  int _num_images;
        
  public ContourImageTest( int length1, int length2, int length3, int n_images )  throws VisADException, RemoteException {
	  try { 
		RealType time = RealType.Time;
		RealTupleType time_type = new RealTupleType(time);
	  
		Set time_set = new Linear1DSet(time_type, 0.0, 1.0, n_images);	  
		_domain_set = new Integer3DSet(length1,length2,length3);

		RealType x_type = new RealType("x",null,null);
		RealType y_type = new RealType("y",null,null);
		RealType z_type = new RealType("z",null,null);
		_range_type = new RealType("range",null,null);

		RealType[] types3d = { x_type, y_type, z_type };
		RealTupleType domain_type = new RealTupleType( types3d, null, _domain_set );
		
		_grid_type =  new FunctionType( domain_type, _range_type );
		FunctionType animation_type =  new FunctionType( time_type, _grid_type );
		_animation_sequence = new FieldImpl( animation_type, time_set );
				
		_display = new DisplayImplJ3D("image display");
		_display.addMap(new ScalarMap( x_type, Display.XAxis));
		_display.addMap(new ScalarMap( y_type, Display.YAxis));
		_display.addMap(new ScalarMap( z_type, Display.ZAxis));
		
		_color_map = new ScalarMap( _range_type, Display.RGB );
		_display.addMap( _color_map );
		
		ScalarMap contour_map = new ScalarMap( _range_type, Display.IsoContour );
		_display.addMap(contour_map);
		_contour_controller = (ContourControl) contour_map.getControl();
		_contour_controller.setSurfaceValue(0f);
		_contour_controller.enableContours(true);
		
		ScalarMap map1animation = new ScalarMap(RealType.Time, Display.Animation);
		_display.addMap(map1animation);

		_anim_controller = (AnimationControl) map1animation.getControl();
		_anim_controller.setStep(3000);


		final DataReference _image_ref =  new DataReferenceImpl("image");
		_image_ref.setData( _animation_sequence );
		_display.addReference( _image_ref );
		
	  } catch ( java.lang.NoClassDefFoundError err ) { 
		print( "error: can't find VisAD or Java3D class: " + err.getMessage() ); 
		err.printStackTrace();
	  }

	  setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	  setAlignmentY(JPanel.TOP_ALIGNMENT);
	  setAlignmentX(JPanel.LEFT_ALIGNMENT);

	  if( _display != null ) { add(_display.getComponent()); }
	  print( "Completed ContourImage3d setup." );
  }


  public void CreateImage(  float[] data, boolean copy )  throws VisADException, RemoteException  {
	FlatField f = new FlatField( _grid_type, _domain_set );
	float[][] range_data = new float[1][];
	range_data[0] = data;
	f.setSamples(range_data,copy);
	print( " add image " + _num_images );
	_animation_sequence.setSample( _num_images++, f );
  }

  public static void main(String args[])
         throws VisADException, RemoteException, IOException {

	int length1 = 16;
	int length2 = 16;
	int length3 = 16;
	int max_images = 3;
	boolean debug = true;
	
  // create JFrame (i.e., a window) for display and slider
    JFrame frame = new JFrame("Simple VisAD Image Animator");
    frame.addWindowListener(
		new WindowAdapter() {
		  public void windowClosing(WindowEvent e) {System.exit(0);}
		}
	);

	// Add image display to Frame.

	ContourImageTest iDisplay = new ContourImageTest( length1, length2, length3, max_images );
	frame.getContentPane().add(iDisplay);

    // set size of JFrame and make it visible
    frame.setSize(500, 600);
    frame.setVisible(true);
	int a = 2, b = 5, c = 3;
	float pi = (float)Math.PI;
	float l1 = length1, l2 = length2, l3 = length3;

	for( int i=0; i<max_images; i++ ) {	    
	  int index = 0; 
	  float[] data = new float[length1*length2*length3];
	  if( debug ) System.out.print( "\nData Dump, Surface Value = 0.0, slice at z=8 :" );
	  for( int i3 = 0; i3<length3; i3++ ) {
		for( int i2 = 0; i2<length2; i2++ ) {
		  if( debug && (i3==8) ) System.out.println();
		  for( int i1 = 0; i1<length1; i1++ ) {
			float value = (float) ( Math.sin((i1/l1)*a*pi) + Math.sin((i2/l2)*b*pi) + Math.sin((i3/l3)*c*pi) );
			data[index++] = value;
			if( debug && (i3==8) ) System.out.print(  ( value > 0.0 ) ? "*" : "_" );
		  }
		}
	  }
	  iDisplay.CreateImage( data, false );
	  a++; b++; c++;
	}
  }
		  
  void print(String msg) {
	System.out.print("\nJAVA: " + msg);
  }
  void print(VisADException e) {
	System.out.print("\nJAVA VisADException: " + e);
  }
  void print(RemoteException e) {
	System.out.print("\nJAVA RemoteException: " + e);
  }

}
