package miiee.visad;

import java.awt.Dimension;
import java.awt.event.*;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.*;
import visad.*;
import miiee.util.*;
import java.util.ListIterator;
import java.util.Vector;

/**
 * A collection of methods for working with SME, callable from the
 * JPython editor.
 */
 
public class SME extends Object {

  private static final String DEFAULT_NAME = "JPython";

  private static final String ID = SME.class.getName();

  /**
   * Displays the given data onscreen.
   *
   * @param   data            VisAD data object to plot
   *
   * @throws  VisADException  invalid data
   * @throws  RemoteException part of data and display APIs, shouldn't occur
   */
  
  public SME() { ; }
  
  public void list_datasets() {
	  ListIterator li = DataSet.getDatasetIterator(); 
	  Object o = null;
	  int cnt = 0;
	  while( (o = li.next()) != null ) { 
		System.out.println( "\t[" + (cnt++) + "] " + o.toString() );
	  }
  }
  
  public DataSet get_dataset( String name ) {
	  ListIterator li = DataSet.getDatasetIterator(); 
	  Object o = null;
	  while( (o = li.next()) != null ) { 
		if( o.toString().equals(name) ) { return (DataSet)o; }
	  }
	  return null;
  }
  
  public void plot(DataSet ds) {
	Vector datasets = new Vector();
	datasets.addElement(ds);
	AnimationViewer3DV.create3dViewer(datasets);  
  }
  
  public void create_demo() {
	  int width = 75, height = 60;
	  int max_images = 3;
	  DataSet ds = DataSet.create2DDemo( max_images, height, width );	
  }

  static public void main(String args[]) {  
	  SME sme = new SME();
	  sme.create_demo();	  
	  sme.list_datasets();	  
  }

//	ViewserverControlPanel vp = JPythonShell.getViewserverControlPanel();

}
