package miiee.visad;

import visad.*;
import miiee.util.*;
import java.io.*;
import miiee.mml.MMLException;

//---- JPythonShell ---------------------------------------------------------

public class SPythonEditor extends visad.python.JPythonEditor {

  private static ExternalClassStub _python_interface;
  private static boolean _debug = true;
  
  /** text to be prepended to all JPython documents */
  private static final String PREPENDED_TEXT = "from miiee.python.SPyMethods import *";

  public  static ExternalClassStub  getPythonInterface() throws MMLException {
	  if( _python_interface == null ) {
		_python_interface = new ExternalClassStub( "miiee.python.SPyStubs" );
		_python_interface.addMethod("exec",    "exec( java.lang.String, java.lang.String )" );
		_python_interface.addMethod("compile", "compile( java.lang.String, java.lang.String  )" );
	  } 
	  return _python_interface;
  }
 
  public SPythonEditor( String file ) throws VisADException { 
	super(file); 
	if( file == null ) {
	  try {
		String driver_dir = System.getProperty("user.dir");
		File dir = new File(driver_dir,"../UserCode/");
		fileChooser.setCurrentDirectory(dir);
	  } catch ( Exception err ) {;}
	} else {
	  File dir = new File(file);
	  fileChooser.setCurrentDirectory(dir);
	}
  }

  public String getText() {
    return PREPENDED_TEXT +
      System.getProperty("line.separator") + super.getText();
  }

  /** sets the text of the document to the current string */
  public void setText(String text) {
	
    if (text.startsWith(PREPENDED_TEXT)) {
      // strip off prepended text
      text = text.substring(PREPENDED_TEXT.length()).trim();
    }
    super.setText(text);
  }
   
  public void run() throws VisADException {
	try {
	  String script = getText();
	  String filename = null;
	  if( hasChanged() ) { filename = saveTempFile(); } 
	  if( filename == null ) { filename = getFilename(); }
	  ExternalClassStub  python = getPythonInterface();
	  python.execMethod("exec", new Object[] { script, filename }  );
	} catch ( Exception err ) {
	  if( _debug ) {
		System.out.println( "\n Can't run script: " + err.getMessage() );
		err.printStackTrace();
	  }
	  throw new VisADException("Run Error:" + err.getMessage() );
	}
  }
  
  String saveTempFile() {
	String file_name = getFile().getName();
	int pindex = file_name.indexOf('.');
	String prefix = ( pindex > 0 ) ? file_name.substring(0,pindex) : file_name;
	try {
	  File f = File.createTempFile(prefix,"py");
	  byte[] bytes = getText().getBytes();
	  FileOutputStream out = new FileOutputStream(f);
	  out.write(bytes);
	  out.close();
	  return f.getPath();
    } catch( IOException err ) {
	  System.out.println( "\n Can't save Temp File: " + err.getMessage() );
	  return null;
	}
  }
  
  public void compile() throws VisADException {
	try {
	  String script = getText();
	  String filename = null;
	  if( hasChanged() ) { filename = saveTempFile(); } 
	  if( filename == null ) { filename = getFilename(); }
	  ExternalClassStub  python = getPythonInterface();
	  python.execMethod("compile", new Object[] { script, filename }  );
	} catch ( Exception err ) {
	  if( _debug ) {
		System.out.println( "\n Can't compile script: " + err.getMessage() );
		err.printStackTrace();
	  }
	  throw new VisADException("Compile error: " + err.getMessage() );
	}
  }
  
}
