package miiee.visad;

import miiee.util.DataSet;
import visad.VisADException;
import visad.python.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Vector;
import miiee.dataview.ViewserverControlPanel;

//---- stub_interface ---------------------------------------------------------

public class stub_interface {

	public stub_interface() {
	}
	
	public void create3dViewer( Vector datasets ) {
	  AnimationViewer3DV.create3dViewer(datasets);
	}
	
	public JFrame createPythonEditor( String file ) {
	  try {	  
		SPythonEditor editor = new SPythonEditor(file);
		if( file == null ) {
		  boolean file_found = editor.openDialog();
		  if( !file_found ) { ; }
		} 		

		return SPythonFrame.getInstance(editor);
	  }
	  catch (VisADException exc) {
		exc.printStackTrace();
		return null;
	  }
	}
}

class SPythonFrame extends visad.python.JPythonFrame {

  static SPythonFrame _instance;
  
  /** constructs a JPythonFrame from the given JPythonEditor object */
  public SPythonFrame(SPythonEditor editor) throws VisADException {
    super(editor);
  }

  public void fileExit() {
    if (textPane.hasChanged()) { askSaveChanges(false); }
    textPane.newFile();
    setVisible(false);
  }
  
  static SPythonFrame getInstance(SPythonEditor editor) throws VisADException {
	if( _instance == null ) { 
	  _instance = new SPythonFrame(editor); 
		// close program if frame is closed
	  _instance.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		  _instance.fileExit();
		}
	  });
	  _instance.setBounds(100, 100, 500, 800);
	}
	return _instance;
  }
}
