package miiee.wizard;

import java.awt.FlowLayout;
import javax.swing.*;
import javax.swing.event.*;
import java.util.Vector;
import java.awt.Toolkit;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.GridLayout;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;
import java.io.File;
import miiee.util.*;      

public class DirectoryChooser extends Object implements DataDisplayListener {

    protected AttributeValuePair _pathChoosen;
    protected JList _directoryList;
	protected JDialog _dialog; 
    protected EventListenerList listenerList = new EventListenerList();
	protected DirectoryModel _dir_model = new DirectoryModel( false );
	protected JPanel _content_pane = new JPanel();

	private DirectoryChooser( ) { super(); }
		
	public static DirectoryChooser create(  String default_path ) {
	  DirectoryChooser controlPanel = new DirectoryChooser();
	  controlPanel.init();
	  if( default_path != null ) {
		controlPanel.setDefaults(default_path);
	  } else {
		String path = System.getProperty("user.home");
		controlPanel.setDefaults(path);
	  }
	  return controlPanel;
	}
	
	public void setDefaults( String path ) {
	  if( path.equals("~") ) {
		path = System.getProperty("user.home");
	  }
	  if ( path != null ) {
		_dir_model.setCurrentDirectory( new File(path) );
		_pathChoosen.setValue(path);
	  }	  
	}
	
	void init() {
		_content_pane.setLayout( new BorderLayout() );

		JPanel info_panel = new JPanel(true);
		Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	info_panel.setBorder( bb );
		_content_pane.add(info_panel,"North");

		_pathChoosen = AttributeValuePair.New( "path:", true, 35 );
		_pathChoosen.addDataDisplayListener( this );
		_pathChoosen.setValue( " (no data) " );
		info_panel.add(_pathChoosen);

		JPanel status_panel = new JPanel(true);
		bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	status_panel.setBorder( bb );
		_content_pane.add(status_panel, "South" );

		JButton  aButton = new JButton("Up");
		aButton.addActionListener( new UpAction() );
		status_panel.add( aButton );
		
		aButton = new JButton("Choose");
		aButton.addActionListener( new ChooseAction() );
		status_panel.add( aButton );

		aButton = new JButton("Close");
		aButton.addActionListener( new CloseAction() );
		status_panel.add( aButton );
		
		_content_pane.add( create_data_panel(), "Center" );
		_content_pane.setBorder( BorderFactory.createEtchedBorder() );
	} 

	JPanel create_data_panel() {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );	

	  JPanel pV  = new JPanel(true);
	  BoxLayout bl = new BoxLayout(pV, BoxLayout.Y_AXIS );  pV.setLayout( bl ); 	   
	  Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	pV.setBorder( bb );
	  pV.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  	  
	  JLabel title = new JLabel("Choose Directory:");
	  pV.add(title);
	  _directoryList =  new JList( _dir_model );
	  _directoryList.setBorder( BorderFactory.createEtchedBorder() );
	  JScrollPane scrollPane = new JScrollPane();
	  scrollPane.getViewport().setView(_directoryList);
	  scrollPane.setBorder( eb7 );
	  MouseListener mouseListener = new MouseAdapter() {
		 public void mouseClicked(MouseEvent e) {
			 if (e.getClickCount() == 2) {
				int index = _directoryList.locationToIndex(e.getPoint());
				setDirectorySelection(index);
//				fireActionPerformed( _pathChoosen.getValue() );
			 }
		 }
	  };
	  _directoryList.addMouseListener(mouseListener);
 	  pV.add(scrollPane);	  
	  	  
	  _pathChoosen.setValue( _dir_model.getCurrentDirectory().getAbsolutePath() );	 
	   	  
	  return pV;
	}

	public synchronized void setDirectorySelection( int selection_index ) {
	  try {
		File dir = _dir_model.getFileAt(selection_index);
		if( dir != null ) {
		  System.out.println( "Setting dir to " + dir );
		  _pathChoosen.setValue( dir.getAbsolutePath() );
		  _dir_model.setCurrentDirectory(dir);
		}
	  } catch( ArrayIndexOutOfBoundsException err ) { ; }
	}
	
	class CloseAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		dispose();
	  }
    }
 
 	class ChooseAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		String rv = null;
		int selindex = _directoryList.getSelectedIndex();
		if( selindex == -1 ) {
		  rv = _pathChoosen.getValue();
		} else {
		  File dir = _dir_model.getFileAt(selindex);
		  if( dir != null ) {
			rv = dir.getAbsolutePath();
		  }
		}
		if( rv != null ) {
		  fireActionPerformed( rv );
		  dispose();
		} else {
		  SimIO.beep();
		}
	  }
    }
    
     public void destroy() { ; }
  
    public void dispose() { 
	  if( _dialog != null ) {
		_dialog.setVisible(false);
		_dialog.dispose();
		_dialog = null;
	  }
	}

	class UpAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		  _pathChoosen.setValue( _dir_model.setParentDirectory() );
	  }
    } 

	String getDirectory() { return _pathChoosen.getValue(); }
		
	public  void  set_pathChoosen( String path ) {
	  try {
		_pathChoosen.setValue( path );
	  } catch ( NullPointerException err ) { return; }
	  _content_pane.repaint();
	}

  public void show( boolean modal ) {
	dispose(); 
	JFrame frame = new JFrame();
		
	_dialog = new JDialog( frame, "Directory Chooser", modal ); // Modal
//	_dialog.addKeyListener(this);

	WindowListener l = new WindowAdapter() {
		public void windowClosing(WindowEvent e) { destroy(); }
	};
	_dialog.addWindowListener( l );
	_dialog.setContentPane( _content_pane );
	_dialog.pack();
	
    Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (screenDim.width - _dialog.getSize().width) / 2;
    int y = (screenDim.height - _dialog.getSize().height) / 2;
    _dialog.setLocation(x, y);	   
    _dialog.setVisible(true);
  }   
     /**
     * adds an ActionListener to the button
     */
     
    public void addActionListener(ActionListener l) {
        listenerList.add(ActionListener.class, l);
    }
 
    /**
     * removes an ActionListener from the button
     */
    public void removeActionListener(ActionListener l) {
        listenerList.remove(ActionListener.class, l);
    }
 
    protected void fireActionPerformed(String path) {
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        ActionEvent e = null;
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==ActionListener.class) {
                // Lazily create the event:
                if (e == null) {
                    e = new ActionEvent(this, ActionEvent.ACTION_PERFORMED, path);
                }
                ((ActionListener)listeners[i+1]).actionPerformed(e);
            }
        }
    }

 	public  void pointSelected(DataDisplayEvent datadisplayevent) {;}

    public  void regionSelected(DataDisplayEvent datadisplayevent) {;}

    public  void scrollScaleChanged(DataDisplayEvent datadisplayevent) {;}

    public  void scaleChanged(DataDisplayEvent datadisplayevent) {;}

    public  void textInput(DataDisplayEvent datadisplayevent) {
	  AttributeValuePair s = (AttributeValuePair) datadisplayevent.getSource();
	  if( s == _pathChoosen ) {
		String text = _pathChoosen.getValue();
		File dir = new File(text);
		System.out.println( "Setting dir to " + text );
		if( dir != null ) { System.out.println( "File: " + dir ); }
		_dir_model.setCurrentDirectory(dir);
	  } else {
	  
	  }
    }

    public  void timeChanged(DataDisplayEvent datadisplayevent) {;}
  
	static public void main(String args[]) { 
	  DirectoryChooser dc = DirectoryChooser.create( "/flock/Java/"  );
	  dc.show( true );
	}
}
