package miiee.wizard;

import org.xml.sax.Attributes;
import java.util.Vector;
import javax.swing.*;
import java.awt.*;
import java.io.BufferedWriter;
import java.io.IOException;
import javax.swing.event.*;
import java.awt.event.*;
import javax.swing.border.*;
import org.xml.sax.*;
import miiee.xml.*;

public class Field extends XMLData {

  JComponent _tooltipComponent;
  String _toolTipText;
  
  public Field( String id, String name, String help, String type, boolean required, String default_value ) {
	this( id, name, type, required );
	if( help != null ) { addProperty( "help", help, XMLComponent.kMutable, "string" ); }
	if( default_value != null ) { addProperty( "value", default_value, XMLComponent.kMutable, type ); }
  }

  public Field( String id, String name, String type, boolean required ) {
	super( id );
	if( name != null ) { addAttribute( "name", name ); }
	if( type != null ) { addAttribute( "type", type ); }
	addAttribute( "required", required ? "true" : "false" );	
  }
  
  public Field( Attributes atts )  { 
	super(atts);
 }

  public Field( Attributes atts,  XMLComponent parent )  { 
	super( atts, parent );
 }
  
  public boolean required() {
	String req = (String) getProperty("required");
	if( req != null ) { return req.equals("true"); }	 
	return false; 
  }
  
  public String getElementType( int format ) { return "field"; }

  public void setToolTipComponent( JComponent c ) {
	_tooltipComponent = c;
	if( _toolTipText != null ) { c.setToolTipText( _toolTipText ); }	
  }
  public void setToolTipText( String text ) {
	_toolTipText = text;
	if( _tooltipComponent != null ) { _tooltipComponent.setToolTipText( text ); }	
  }

}
