package miiee.wizard;

import org.xml.sax.Attributes;
import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import org.xml.sax.*;
import miiee.xml.*;
import miiee.util.*;

public class Wizard extends XMLData /* WindowListener, KeyListener */ {

  JFrame _frame = null;
  Vector _panels = new Vector(16);
  JScrollPane _scrollPane = new JScrollPane();
  WizardPanel _current_wizard_panel;
  JButton _execute_button;
  int _current_panel = 0;
  protected String[] _scriptArgs; 
  JDialog _dialog;
  ScriptExecutable _scriptExecutable;
  protected boolean _saveData = true;
  protected boolean _executed = false;

  public Wizard( String id ) { 
	super(id); 
  } 
  
  public Wizard( String id, String name ) { 
	super(id); 
	addAttribute("name",name);	
  } 

  public  Wizard( Attributes atts )  { 
	super(atts); 
  }	 

  public  Wizard( Attributes atts, XMLContainer parent )  { 
	super(atts,parent); 
  }	 

  public void addData( XMLData obj ) throws XMLException {
	super.addData( obj );
	_panels.add(obj);
  }  
     
  public void close() {
	if( _dialog != null ) {	
	  _dialog.setVisible(false);
	  _dialog.dispose();
	  _dialog = null;
	}
  }
  
  public Object getDataProperty( String data_ref, String propertyName ) {
	Object rv = super.getDataProperty( data_ref, propertyName ) ;
	if( rv != null ) return rv;
	for( int i=0; i<_panels.size(); i++ ) {
	  XMLComponent xc = (XMLComponent) _panels.get(i);
	  rv = xc.getDataProperty( data_ref, propertyName ) ;
	  if( rv != null ) return rv;
	}
	return null;
  }
  
  JDialog getDialog() { return _dialog; }
  
  void destroy() {;}

  public void show( boolean modal ) { show( modal, new ScriptExecutable() ); }

  public void show( boolean modal, ScriptExecutable ex ) {
	close(); 
	_executed = false;
	_scriptExecutable = ex;
	JFrame frame = new JFrame();
	
	String osName = System.getProperty("os.name");
	final boolean solarisWorkaround = (osName != null &&  osName.indexOf("Solaris") != -1);
		
	_dialog = new JDialog( frame, toString(), modal ); // Modal
//	_dialog.addKeyListener(this);

	WindowListener l = new WindowAdapter() {
		public void windowClosing(WindowEvent e) { destroy(); }
	};
	_dialog.addWindowListener( l );

	setup_wizard_panel( (JComponent) _dialog.getContentPane()  );
	_dialog.setSize( 600, 400 );
	
    Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (screenDim.width - _dialog.getSize().width) / 2;
    int y = (screenDim.height - _dialog.getSize().height) / 2;
    _dialog.setLocation(x, y);	
    _dialog.setVisible(true);
  }
  
/*  
  public void show(Component parentComponent, String title) {
	  Frame         frame = JOptionPane.getFrameForComponent(parentComponent);
	  final JDialog dialog;

	  String osName = System.getProperty("os.name");
	  final boolean solarisWorkaround = (osName != null && 
										 osName.indexOf("Solaris") != -1);

	  if (solarisWorkaround) {
		  // Workaround for bug in Solaris where modal dialog
		  // disposal causes segv (4137962); this workaround exposes
		  // bugs on win32, so only do it on Solaris
		  //
		  dialog = SwingUtilities.getRecycledModalDialog(frame, title);

	  } else {
		  dialog = new JDialog(frame, title, true);
	  }
	  JComponent  contentPane = (JComponent) dialog.getContentPane();
	  setup_wizard_panel( contentPane );
	  dialog.pack();
	  dialog.setLocationRelativeTo(parentComponent);
	  dialog.addWindowListener(new WindowAdapter() {
		  boolean gotFocus = false;
		  public void windowClosing(WindowEvent we) {
			  setValue(null);
		  }
		  public void windowActivated(WindowEvent we) {
			  // Once window gets focus, set initial focus
			  if (!gotFocus) {
				  selectInitialValue();
				  gotFocus = true;
			  }
		  }
	  });
	  addPropertyChangeListener(new PropertyChangeListener() {
		  public void propertyChange(PropertyChangeEvent event) {
			  if(dialog.isVisible() && event.getSource() == JOptionPane.this &&
				 (event.getPropertyName().equals(VALUE_PROPERTY) ||
				  event.getPropertyName().equals(INPUT_VALUE_PROPERTY))) {
				  dialog.setVisible(false);
				  if (solarisWorkaround) {
					  // Workaround for bug in Solaris where modal dialog
					 // disposal causes segv (4137962)
					  SwingUtilities.recycleModalDialog(dialog);
				  } else {
					  dialog.dispose();
				  }
			  }
		  }
	  });
	  return dialog;
  }
*/  
  void setup_wizard_panel( JComponent viewer_panel ) {
	EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );

	viewer_panel.setBorder(bb);	
	viewer_panel.add( "Center", _scrollPane );
	viewer_panel.add( "South", constructButtonPanel() );	

	if( getDataCount() > 0 ) {
	  setWizardPanel( _current_panel=0 );
	}
	enableToolTips( true ); 
  
  } 
        
  JPanel constructButtonPanel() {
	JPanel buttonPanel = new JPanel(false);
 	buttonPanel.setLayout(new FlowLayout());

	JButton aButton = new JButton("cancel");
	aButton.addActionListener( new CancelAction() );
	buttonPanel.add( aButton );
 
 	aButton = new JButton("prev");
	aButton.addActionListener( new PrevAction() );
	buttonPanel.add( aButton );

	aButton = new JButton("next");
	aButton.addActionListener( new NextAction() );
	buttonPanel.add( aButton );

	_execute_button = new JButton("execute");
	_execute_button.addActionListener( new DoneAction() );
	buttonPanel.add( _execute_button );

	return buttonPanel;
  }
  
  public void enableToolTips( boolean enable ) {
	ToolTipManager.sharedInstance().setEnabled(enable);
  }

  
    class CancelAction extends Object implements ActionListener {  
	  public void actionPerformed(ActionEvent e) {
		 close();
	  }
    } 
 
     class NextAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e)  {
		if( getDataCount() > 0 ) {
		  try {
			 _current_wizard_panel.collectFieldData();
			 if( _current_panel < ( getDataCount() - 1 ) ) {
			   setWizardPanel( ++_current_panel );
			 }
		  } catch ( XMLException err ) { 
			JOptionPane.showMessageDialog( _frame, err.getMessage(), 
				"Wizard error: Field \"" + err.getComponent().getProperty("name") + "\"", JOptionPane.ERROR_MESSAGE );
		  }
		}
	  }
    }
    
    public int setWizardPanel( int index ) {
	  int imax = _panels.size() - 1; 
	  if( imax < 0 ) return -1;
	  index = ( index < 0 ) ? 0 : (( index > imax ) ? imax : index);
	  _current_wizard_panel = (WizardPanel) _panels.get( index );
	  if( _current_wizard_panel != null ) {
		_scrollPane.getViewport().setView( _current_wizard_panel.getContentPane() );
		_scrollPane.invalidate();
		_scrollPane.validate();
		_scrollPane.repaint();
		_execute_button.setEnabled( index == imax );
	  }
	  return index;
	}

     class PrevAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e)   {
		if( getDataCount() > 0 ) {
		  try {
			 _current_wizard_panel.collectFieldData();
		  } catch ( XMLException err ) {;}
		   if( _current_panel > 0 ) {
			  setWizardPanel( --_current_panel );
		   }
		}
	  }
    } 
	
	void executeScript() throws XMLException {
	  if( _scriptExecutable != null ) {
		String s = generateScript(null);
		_scriptExecutable.execute(s,this);
	  }
	}
	
     class DoneAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) { 
		try {
			_current_wizard_panel.collectFieldData();
			if( _saveData ) {
			  writeXML( DATA );
			}
			executeScript();
			_executed = true;
			close();
		} catch ( XMLException err ) {
		  XMLComponent c = err.getComponent(); 
		  JOptionPane.showMessageDialog( _frame, err.getMessage(), 
			  "Wizard error: Field \"" + ((c==null) ? " (null) " : c.getProperty("name")) + "\"", JOptionPane.ERROR_MESSAGE );
		}
	  }
    } 
    
    public boolean completed() { return 	_executed; }
    
	
    public static void main(String args[]) {
	  try {
		if( args[0].equals("demo") ) {
		  Wizard w = new Wizard( "W0", "TestWizard" );
		  WizardPanel wp = new  WizardPanel( "WP0", "Support",  "This panel is used to set up support for blah, blah, blah..." +
			  "This panel is used to set up support for blah, blah, blah..." +
			  "This panel is used to set up support for blah, blah, blah...", w );
		  wp.addBooleanField(  "Enable support?", "This checkbox switches on support for blah, blah, blah...", false, "true" );
		  wp.addIntField(  "Input Integer:", "This field is used to input an integer for blah, blah, blah...", false, "0.0" );
		  wp.addFloatField( "Input Float:", "This field is used to input a float for blah, blah, blah...", false, "1.0" );
		  wp.addStringField( "Input String:", "This field is used to input a string for blah, blah, blah...", false, "default" );
		  wp.addDirectoryField( "Input Directory:", "This field is used to select a directory for blah, blah, blah...", true, "~", null );
		  wp.addFileField( "Input File path:", "This field is used to select a file for blah, blah, blah...", true, "/hawk/include/", "tcl.h" );
		  WizardHandler handler = new WizardHandler(w);
		  handler.readXML( "W0", DATA, shift( args, 1 ), null );
		  w.show( true  );
		} else {
		  WizardHandler handler = new WizardHandler();
		  Wizard w = handler.readXML( args[0], DEFINITION, shift( args, 1 ), null );
		  if( w != null ) {
			w.enableToolTips( true ); 
			w.show( true  );
		  }
		}
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
	  }
	  System.exit(0);
	}
 
  public String getElementType( int format ) {   return "wizard";  }

  public void writeXML( int format ) { 
	String xml_name =  ID() + "." + getElementType( format );
	String dtd_name =  getElementType(format);
	super.writeXML( xml_name, dtd_name, format );
  }
  
	public static Wizard getWizard( String name, String[] args ) {
		WizardHandler handler = new WizardHandler();
		Wizard w = handler.readXML( name, DEFINITION, args, null );
		return w;
	}

  protected void setScriptArgs( String[] args ) { _scriptArgs = args; }
  protected String[] getScriptArgs() { return _scriptArgs; }
  
  public void setSaveData( boolean saveData ) { _saveData = saveData; }

}
/*
class WizardHandler extends XMLHandler {

  String[] _args;
  	 
  public WizardHandler() { super(); }

  public WizardHandler( XMLData top ) { super(top); }
 
  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create )  throws XMLException {
	XMLComponent rv = null;
	if( name.equals("wizard") ) {
	  String n = atts.getValue("id");
	  rv = ((XMLContainer)_tree_root).getData( n ); 
	  if( rv == null ) {
		if( create ) {
		  rv = new Wizard( atts, (XMLContainer)_tree_root ); 
		  ((Wizard)rv).setScriptArgs( _args );
		} else {
		  ((XMLContainer)_tree_root).dumpChildren();
		  throw new  XMLException( "Can't find wizard element with id " + ((n==null) ? "(null)" : n)  );
		}
	  }
	} else if( name.equals("panel") ) {
	  String n = atts.getValue("id");
	  if( parent != null ) {
		rv = ((XMLData)parent).getData( n ); 
	  }
	  if( rv == null ) {
		if( create ) {
	  	  rv = new  WizardPanel( atts, (XMLData)parent );
		} else {
		  ((XMLData)parent).dumpData();
		  throw new  XMLException( "Can't find panel element with id " + ((n==null) ? "(null)" : n) );
		}
	  }
 	} else if( name.equals("field")  ) {
	  String n = atts.getValue("id");
	  if( parent != null ) {
		rv = parent.getData( n ); 
	  }
	  if( rv == null ) { 
		if( create ) {
		  rv = ((WizardPanel)parent).addField( atts );
		} else {
		   parent.dumpData();
		   throw new  XMLException( "Can't find field element with id " + ((n==null) ? "(null)" : n) );
		}
	  }
 	} 
	return rv;
  }
  
  public Wizard readXML( String name, int format, String[] args, XMLComponent parse_root ) { 
	String  user_file = SimIO.getXMLUsrDirectory() + name + ".wizard.xml";
	String  defaults_file = SimIO.getXMLSysDirectory() + name + ".wizard.xml";  
	_args = args;	  
	return (Wizard) read( defaults_file, user_file, null, format, parse_root );
  }
}
*/
