package miiee.wizard;

import org.xml.sax.*;
import miiee.xml.*;

public class WizardHandler extends XMLHandler {

  String[] _args;

  public WizardHandler() { super(); }

  public WizardHandler( XMLData top ) { super(top); }

  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create )  throws XMLException {
	XMLComponent rv = null;
	if( name.equals("wizard") ) {
	  String n = atts.getValue("id");
	  rv = ((XMLContainer)_tree_root).getData( n );
	  if( rv == null ) {
		if( create ) {
		  rv = new Wizard( atts, (XMLContainer)_tree_root );
		  ((Wizard)rv).setScriptArgs( _args );
		} else {
		  ((XMLContainer)_tree_root).dumpChildren();
		  throw new  XMLException( "Can't find wizard element with id " + ((n==null) ? "(null)" : n)  );
		}
	  }
	} else if( name.equals("panel") ) {
	  String n = atts.getValue("id");
	  if( parent != null ) {
		rv = ((XMLData)parent).getData( n );
	  }
	  if( rv == null ) {
		if( create ) {
	  	  rv = new  WizardPanel( atts, (XMLData)parent );
		} else {
		  ((XMLData)parent).dumpData();
		  throw new  XMLException( "Can't find panel element with id " + ((n==null) ? "(null)" : n) );
		}
	  }
 	} else if( name.equals("field")  ) {
	  String n = atts.getValue("id");
	  if( parent != null ) {
		rv = parent.getData( n );
	  }
	  if( rv == null ) {
		if( create ) {
		  rv = ((WizardPanel)parent).addField( atts );
		} else {
		   parent.dumpData();
		   throw new  XMLException( "Can't find field element with id " + ((n==null) ? "(null)" : n) );
		}
	  }
 	}
	return rv;
  }

  public Wizard readXML( String name, int format, String[] args, XMLComponent parse_root ) {
	String defaults_file = System.getProperty("LIBDIR") + name + ".wizard.xml";
	String user_file = System.getProperty("user.home") + "/.sme/" + name + ".wizard.xml";
	_args = args;
	return (Wizard) read( defaults_file, user_file, null, format, parse_root );
  }

}
