package miiee.wizard;

import org.xml.sax.Attributes;
import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.awt.font.TextAttribute;
import java.io.*;
import javax.swing.event.*;
import java.awt.event.*;
import javax.swing.border.*;
import org.xml.sax.*;
import miiee.xml.*;
import miiee.util.*;
import miiee.client.SMEInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

abstract class FieldAdapter implements PropertyChangeListener, ActionListener {
  public Field _field;
  public Component _component;
  FieldAdapter( Field f, Component c ) { 
	_field = f; _component = c; 
	f.addPropertyChangeListener(  this );
  }
  public abstract void execute( boolean enabled ) throws XMLException;
  public abstract void propertyChange(PropertyChangeEvent evt);
  public void actionPerformed(ActionEvent e) { 
	try {
	  execute( true );
	} catch ( XMLException err ) {
	  System.out.println( err.getMessage() );
	} 
  }
}

public class WizardPanel extends XMLData {

  Vector _fieldAdapters = new Vector(16,16);
  Box _panel = Box.createVerticalBox();
  static int _field_count = 0;
  static int _panel_count = 0;
  Font _title_font;
  
  public WizardPanel( Attributes atts, XMLData parent )  { 
	super( atts, parent );	
	String name = (String) atts.getValue("name");
	if( name != null ) {
	  addTitle( name ); 
	} 
  }

  public WizardPanel( String id, String name ) { 
	super(id); 
	addAttribute("name",name);
	addTitle( name );	 
  }
 
   public WizardPanel( String id, String name, String doc, XMLData parent )  { 
	super( id, parent );	
	addAttribute("name",name);
	addTitle( name );

	if( doc != null ) {
	  try {
		addDocField( toString() + " documentation",  doc );	
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
	  }
	}
  }
  
  void addTitle( String name ) {
	if( _title_font == null ) {	  
	  HashMap font_attr = new HashMap();
	  font_attr.put( TextAttribute.SIZE, new Float(18) );
	  _title_font = new Font(font_attr);
	}
	Box aPanel =  Box.createHorizontalBox(); 	
	aPanel.add( Box.createHorizontalGlue() );
	JLabel label = new JLabel(name);
	label.setFont(_title_font);
	aPanel.add(label);
	aPanel.add( Box.createHorizontalGlue() );
	_panel.add(aPanel);  
  }
  
  public Field getField( String name ) {
	return (Field) getData( name );
  }
 
  Box getContentPane() { return _panel; }

 public Field addDocField( String name, String text )  throws XMLException {
	String id = "DOC" + _field_count++; 
	Field f = new Field( id, name, null, "doc", true, text );
	f.setVisibility(false);
	addData( f );
	
	JTextArea ta = new JTextArea(100,70);
	_fieldAdapters.add( 
	  new FieldAdapter( f, ta ) {
		public void execute( boolean enabled ) throws XMLException {;}
		public void propertyChange(PropertyChangeEvent evt) {
		  String s =  (String) evt.getNewValue();
		  ((JTextArea)_component).setText( s );
		  ((JTextArea)_component).repaint();
		}
	  }
	);
	if( text != null ) {  ta.setText( text ); }

	ta.setMargin( new Insets( 4, 4, 4, 4 ) ); 
	ta.setWrapStyleWord(true);
	ta.setLineWrap(true);
	ta.setBackground(Color.blue);
	ta.setForeground(Color.yellow);
	
	EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );
	
	Box aPanel =  Box.createHorizontalBox(); 
	JScrollPane scrollPane = new JScrollPane();
	scrollPane.getViewport().setView(ta);
	scrollPane.setPreferredSize( new Dimension( 400, 100 ) );
	scrollPane.setBorder(bb);
	aPanel.add(scrollPane);
		
	_panel.add( aPanel );	   
	return f;
 }
  

 public Field addBooleanField( String id, String name,  boolean required ) throws XMLException {
   return addBooleanField( id, name, null, required, null );
 }

 public Field addBooleanField( String name, String help, boolean required, String default_value ) throws XMLException {
	return  addBooleanField( null, name, help, required, default_value );
 }  
 
 public Field addBooleanField( String id, String name, String help, boolean required, String default_value ) throws XMLException {
   if( id == null ) { id = "b" + _field_count++; }
	Field f = new Field( id, name, help, "bool", required, default_value );
	f.setObject( new Boolean(default_value) );
	addData( f );
   
	Box aPanel = Box.createHorizontalBox();
	
	JCheckBox aCheckbox = new JCheckBox(name);
	if( default_value != null ) {
	  aCheckbox.setSelected( default_value.equalsIgnoreCase("true") );
	}	
	if( help != null ) {
	  aCheckbox.setToolTipText(help);
	}
	aPanel.add( Box.createHorizontalStrut(5) ); 
	aPanel.add(aCheckbox);
	aPanel.add( Box.createHorizontalGlue() );
	_panel.add( Box.createVerticalGlue() );
	_panel.add(aPanel);
	f.setToolTipComponent(aCheckbox);
	FieldAdapter fa =  new FieldAdapter( f, aCheckbox ) {
		public void execute( boolean enabled ) throws XMLException {
		  Boolean b = new Boolean(((JCheckBox)_component).isSelected());
		  _field.setObject(b);
		  _field.setProperty( "value", b.toString() );
		}
	  public void propertyChange(PropertyChangeEvent evt) {
		String pname = evt.getPropertyName();
		if( pname.equals("value") ) {
		  Boolean b = new Boolean( (String) evt.getNewValue() );
		  ((JCheckBox)_component).setSelected( b.booleanValue() );
		} else if( pname.equals("help") ) {
		  _field.setToolTipText( (String) evt.getNewValue() ); 
		}
	  }
	};
	_fieldAdapters.add( fa );
	aCheckbox.addActionListener(fa);
	_panel.add(aPanel);
	return f;
 }

 public Field addIntField( String id, String name,  boolean required ) throws XMLException {
   return addIntField( id, name, null, required, null );
 }
 public Field addIntField( String name, String help, boolean required, String default_value ) throws XMLException {
	return  addIntField( null, name, help, required, default_value );
 }  

 public Field addIntField( String id, String name, String help, boolean required, String default_value ) throws XMLException {
   if( id == null ) { id = "i" + _field_count++; }
	Field f = new Field( id, name, help, "int", required, default_value );
	addData( f );

	Box aPanel =  Box.createHorizontalBox(); 	
	JLabel label = new JLabel(name);
	if( help != null ) {
	  label.setToolTipText(help); 
	}
	f.setToolTipComponent(label);
	JTextField value = new JTextField(32);
	value.setMaximumSize( new Dimension(Short.MAX_VALUE, 30 ) ); 
	value.setEditable(true);
	label.setLabelFor(value);
	if( default_value != null ) {
	  value.setText( generateScript( default_value ) );
	}
  	
	aPanel.add( Box.createHorizontalStrut(5) ); 
	aPanel.add(label);
	aPanel.add( Box.createHorizontalStrut(3) ); 
	aPanel.add(value);
	aPanel.add( Box.createHorizontalStrut(5) ); 
	_panel.add( Box.createVerticalGlue() );
	_fieldAdapters.add( new FieldAdapter( f, value ) {
	  public void execute( boolean enabled ) throws XMLException  {
		String s = ((JTextField)_component).getText();
		if( _field.required() && (s.length() == 0) && enabled ) {
		  throw new XMLException( "Missing required field", _field );
		}
		try {
		  Integer I = new Integer( s ); 
		  _field.setObject( I );
		  _field.setProperty("value",s);
		} catch ( NumberFormatException  err ) {
		  if( enabled ) {
			throw new XMLException( "NumberFormatException: " + s, _field );
		  }
		}
	  }
	  public void propertyChange(PropertyChangeEvent evt) {
		String pname = evt.getPropertyName();
		if( pname.equals("value") ) {
		  try {
			((JTextField)_component).setText( generateScript( (String) evt.getNewValue() )  );
		  } catch (XMLException err) {
			System.out.println( "Value field parse error: " + err.getMessage() );
		  }
		} else if( pname.equals("help") ) {
		  _field.setToolTipText( (String) evt.getNewValue() ); 
		}
	  }
	});
	_panel.add(aPanel);
	return f;
 }

 public Field addFloatField( String id, String name,  boolean required ) throws XMLException {
   return addFloatField( id, name, null, required, null );
 }
 public Field addFloatField( String name, String help, boolean required, String default_value ) throws XMLException {
	return  addFloatField( null, name, help, required, default_value );
 }  

 public Field addFloatField( String id, String name, String help, boolean required, String default_value ) throws XMLException {
   if( id == null ) { id = "f" + _field_count++; }
	Field f = new Field( id, name, help, "float", required, default_value );
	addData( f );
   
	Box aPanel =  Box.createHorizontalBox(); 	
	JLabel label = new JLabel(name);
	if( help != null ) {
	  label.setToolTipText(help); 
	}
	JTextField value = new JTextField(32);
	value.setMaximumSize( new Dimension(Short.MAX_VALUE, 30 ) ); 
	value.setEditable(true);
	label.setLabelFor(value);
	f.setToolTipComponent(label);
	if( default_value != null ) {
	  value.setText( generateScript( default_value ) );
	}
	
	aPanel.add( Box.createHorizontalStrut(5) ); 
	aPanel.add(label);
	aPanel.add( Box.createHorizontalStrut(3) ); 
	aPanel.add(value);
	aPanel.add( Box.createHorizontalStrut(5) ); 
	_panel.add( Box.createVerticalGlue() );
	_fieldAdapters.add( new FieldAdapter( f, value ) {
	  public void execute( boolean enabled ) throws XMLException  {  
		String s = ((JTextField)_component).getText();
		if( _field.required() && (s.length() == 0)  && enabled  ) {
		  throw new XMLException( "Missing required field", _field );
		}
		try {
		  Float F = new Float( s ); 
		  _field.setObject( F );
		  _field.setProperty("value",s);
		} catch ( NumberFormatException  err ) {
		  if( enabled ) {
			throw new XMLException( "NumberFormatException: " + s, _field );
		  }
		}
	  }
	  public void propertyChange(PropertyChangeEvent evt) {
		String pname = evt.getPropertyName();
		if( pname.equals("value") ) {
		  try {
			((JTextField)_component).setText( generateScript( (String) evt.getNewValue() )  );
		  } catch (XMLException err) {
			System.out.println( "Value field parse error: " + err.getMessage() );
		  }
		} else if( pname.equals("help") ) {
		  _field.setToolTipText( (String) evt.getNewValue() ); 
		}
	  }
	});
	_panel.add(aPanel);
	return f;
 }

 public Field addStringField( String id, String name,  boolean required ) throws XMLException {
   return addStringField( id, name, null, required, null );
 }
 public Field addStringField( String name, String help, boolean required, String default_value ) throws XMLException {
	return  addStringField( null, name, help, required, default_value );
 }  

 public Field addStringField( String id, String name, String help, boolean required, String default_value ) throws XMLException {
	if( id == null ) { id = "s" + _field_count++; }
	Field f = new Field( id, name, help, "string", required, default_value );
	addData( f );
	
	Box aPanel =  Box.createHorizontalBox();
	JLabel label = new JLabel(name);
	if( help != null ) {
	  label.setToolTipText(help); 
	}
	f.setToolTipComponent(label);
	JTextField value = new JTextField(32);
	value.setEditable(true);
	value.setMaximumSize( new Dimension(Short.MAX_VALUE, 30 ) ); 
	label.setLabelFor(value);
	if( default_value != null ) {
	  value.setText( generateScript( default_value ) );
	}
	
	aPanel.add( Box.createHorizontalStrut(5) ); 
	aPanel.add(label);
	aPanel.add( Box.createHorizontalStrut(3) ); 
	aPanel.add(value);
	aPanel.add( Box.createHorizontalStrut(5) ); 
	_panel.add( Box.createVerticalGlue() );
	_fieldAdapters.add( new FieldAdapter( f, value ) {
	  public void execute(boolean enabled) throws XMLException  { 
		String s = ((JTextField)_component).getText();
		if( _field.required() && (s.length() == 0) && enabled ) {
		  throw new XMLException( "Missing required field", _field );
		}
		_field.setProperty("value",s);
		_field.setObject( s ); 
	  }
	  public void propertyChange(PropertyChangeEvent evt) {
		String pname = evt.getPropertyName();
		if( pname.equals("value") ) {
		  try {
			((JTextField)_component).setText( generateScript( (String) evt.getNewValue() )  );
		  } catch (XMLException err) {
			System.out.println( "Value field parse error: " + err.getMessage() );
		  }
		} else if( pname.equals("help") ) {
		  _field.setToolTipText( (String) evt.getNewValue() ); 
		}
	  }
	});
	_panel.add(aPanel);
	return f;
 }

 public Field addComboField( String id, String name, String[] labels,  boolean required ) throws XMLException {
   return addComboField( id, name, labels, null, required, null );
 }
 public Field addComboField( String name, String[] labels, String help, boolean required, String default_value ) throws XMLException {
	return  addComboField( null, name, labels, help, required, default_value );
 }  

 public Field addComboField( String id, String name, String[] labels, String help, boolean required, String default_value ) throws XMLException {
	if( id == null ) { id = "s" + _field_count++; }
	Field f = new Field( id, name, help, "combo", required, default_value );
	addData( f );
	
	Box aPanel =  Box.createHorizontalBox();
	JLabel label = new JLabel(name);
	if( help != null ) {
	  label.setToolTipText(help); 
	}
	f.setToolTipComponent(label);
	
	EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );
		
	JList value  = (labels==null) ? new JList() : new JList(labels);
	value.setBorder(bb);	
	label.setLabelFor(value);
	value.setSelectedValue( default_value, true );
	
	aPanel.add( Box.createHorizontalStrut(5) ); 
	aPanel.add(label);
	aPanel.add( Box.createHorizontalStrut(3) ); 
	aPanel.add(value);
	aPanel.add( Box.createHorizontalGlue() ); 
	_panel.add( Box.createVerticalGlue() );
	_fieldAdapters.add( new FieldAdapter( f, value ) {
	  public void execute(boolean enabled) throws XMLException  { 
		String s = (String) ((JList)_component).getSelectedValue();
		if( _field.required() && ( (s==null) || (s.length() == 0) ) && enabled ) {
		  throw new XMLException( "Missing required field", _field );
		}
		_field.setProperty("value",s);
		_field.setObject( s ); 
	  }
	  public void propertyChange(PropertyChangeEvent evt) {
		String pname = evt.getPropertyName();
		if( pname.equals("value") ) {
		  ((JList)_component).setListData( parseList( (String) evt.getNewValue() ) );
		} else if( pname.equals("help") ) {
		  _field.setToolTipText( (String) evt.getNewValue() ); 
		}
	  }
	});
	_panel.add(aPanel);
	return f;
 }
 
 String[] parseList( String data ) {
   StringTokenizer st = new StringTokenizer( data, " " );
   int nt = st.countTokens();
   String[] rv = new String[nt];
   for( int i=0; i<nt; i++ ) {
	 rv[i] = st.nextToken();
   }
   return rv;
 }

 public Field addDirectoryField( String id, String name,  boolean required ) throws XMLException {
   return addDirectoryField( id, name, null, required, null, null );
 }
 public Field addDirectoryField( String name, String help, boolean required, String default_value, String test_file ) throws XMLException {
	return  addDirectoryField( null, name, help, required, default_value, test_file );
 }  

 public Field addDirectoryField( String id, String name, String help, boolean required, String default_directory, String test_file ) throws XMLException {
	if( id == null ) { id = "d" + _field_count++; }
	if( default_directory == null ) { default_directory = "~"; }
	Field f = new Field( id, name, help, "dir", required, default_directory );
	f.setProperty("test",test_file);
	addData( f );

	Box aPanel =  Box.createHorizontalBox(); 
	JLabel label = new JLabel(name);
	if( help != null ) {
	  label.setToolTipText(help); 
	}
	JTextField value = new JTextField(32);
	value.setMaximumSize( new Dimension(Short.MAX_VALUE, 30 ) ); 
	value.setEditable(true);
	label.setLabelFor(value);
	f.setToolTipComponent(label);
	if( default_directory != null ) {
	  value.setText( generateScript( default_directory ) );
	}
	
	aPanel.add( Box.createHorizontalStrut(5) ); 
	aPanel.add(label);
	aPanel.add( Box.createHorizontalStrut(3) ); 
	aPanel.add(value);
	JButton  aButton = new JButton("Browse");	
	aButton.setAlignmentY( Component.CENTER_ALIGNMENT );
	
	aButton.addActionListener( new BrowseAction( value ) );
	aPanel.add( Box.createHorizontalStrut(2) ); 
	aPanel.add( aButton );
	aPanel.add( Box.createHorizontalStrut(5) ); 
	_panel.add( Box.createVerticalGlue() );
	_fieldAdapters.add( new FieldAdapter( f, value ) {
	  public void execute( boolean enabled ) throws XMLException { 
		String s = ((JTextField)_component).getText();
		File file = null;
		if( enabled ) {
		  if( _field.required() && (s.length() == 0) ) {
			throw new XMLException( "Missing required field ", _field );
		  }
		  file = new File(s);
		  String test = (String) _field.getProperty("test");
		  if( test != null ) {
			test = generateScript( test );
			String s1 = s +"/" + test;
			File f1 = new File( s1 );
			if( !f1.exists() ) {
			  throw new XMLException( "Can't find file: " + s1, _field );
			}  
		  } 
		}
		_field.setProperty("value",s);
		_field.setObject( file ); 
	  }
	  public void propertyChange(PropertyChangeEvent evt) {
		String pname = evt.getPropertyName();
		if( pname.equals("value") ) {
		  ((JTextField)_component).setText( processDirectory( (String) evt.getNewValue() )  );
		} else if( pname.equals("help") ) {
		  _field.setToolTipText( (String) evt.getNewValue() ); 
		}
	  }
	  public String processDirectory( String default_directory ) {
		System.out.println("Processing dir: " + default_directory );
		if(  default_directory.equals("~") ) { 
		  return System.getProperty("user.home"); 
		} else {
		  StringTokenizer st = new StringTokenizer(default_directory,":/{}",true);
		  StringBuffer buff = new StringBuffer();
		  boolean is_property = false; 
		  while( st.hasMoreTokens() ) {
			String token =  st.nextToken();
			if( token.equals("{") || token.equals("}") ) { ; // ignore
			} else if( token.equals(":") && is_property ) {
			  String pname =  st.nextToken();
			  String prop = SMEInterface.getProperty(pname); 
			  if( prop == null ) {
			   prop = System.getProperty(pname);
			  } 			
			  System.out.println("Parsing property, " + pname + " : " + prop + ", in token: "  + token);
			  buff.append(prop);
			} else if( token.equalsIgnoreCase("property") ) {
			   is_property = true;
			} else {
			  buff.append(token);
			  is_property = false;
			}
		  }
		  return buff.toString();
		}
	  }
	});
	_panel.add(aPanel);
	return f;
 }
 

 public Field addFileField( String id, String name,  boolean required ) throws XMLException {
   return addDirectoryField( id, name, null, required, null, null );
 }
 public Field addFileField( String name, String help, boolean required, String default_value, String filename ) throws XMLException {
	return  addFileField( null, name, help, required, default_value, filename );
 }  

 public Field addFileField( String id, String name, String help, boolean required, String default_directory, String filename ) throws XMLException {
	if( id == null ) { id = "F" + _field_count++; }
	if( ( default_directory == null ) || default_directory.equals("~") ) { 
	  default_directory = System.getProperty("user.home"); 
	}
	Field f = new Field( id, name, help, "file", required, default_directory );
	f.setProperty("test",filename);
	addData( f );

	Box aPanel =  Box.createHorizontalBox();	
	JLabel label = new JLabel(name);
	if( help != null ) {
	  label.setToolTipText(help); 
	}
	JTextField value = new JTextField(32);
	value.setMaximumSize( new Dimension(Short.MAX_VALUE, 30 ) ); 
	value.setEditable(true);
	label.setLabelFor(value);
	f.setToolTipComponent( label ); 
	if( default_directory != null ) {
	  value.setText( generateScript( default_directory + "/" + filename ) );
	}
	
	aPanel.add( Box.createHorizontalStrut(5) ); 
	aPanel.add(label);
	aPanel.add( Box.createHorizontalStrut(3) ); 
	aPanel.add(value);
	JButton  aButton = new JButton("Browse");	
	aButton.setAlignmentY( Component.CENTER_ALIGNMENT );
	
	aButton.addActionListener( new BrowseFileAction( value, filename ) );
	aPanel.add( Box.createHorizontalStrut(2) ); 
	aPanel.add( aButton );
	aPanel.add( Box.createHorizontalStrut(5) ); 
	_fieldAdapters.add( new FieldAdapter( f, value ) {
	  public void execute( boolean enabled ) throws XMLException {
		String s = ((JTextField)_component).getText();
		File file = null;
		if( enabled ) {
		  if( _field.required() && (s.length() == 0) ) {
			throw new XMLException( "Missing required field ", _field );
		  }
		  file = new File(s);
		  if( !file.exists() ) {
			throw new XMLException( "File does not exist: " + s, _field );
		  }
		  String test = (String) _field.getProperty("test");
		  if( test != null ) {
			test = generateScript( test );
			if( !test.equals( file.getName() ) ) {
			  throw new XMLException( "Selected wrong file: " + file.getName(), _field ); 
			} 
		  }
		}
		_field.setProperty("value",s);
		_field.setObject( file ); 
	  }
	  public void propertyChange(PropertyChangeEvent evt) {
		String pname = evt.getPropertyName();
		if( pname.equals("value") ) {
		  try {
			((JTextField)_component).setText( generateScript( (String) evt.getNewValue() )  );
		  } catch (XMLException err) {
			System.out.println( "Value field parse error: " + err.getMessage() );
		  }
		} else if( pname.equals("help") ) {
		  _field.setToolTipText( (String) evt.getNewValue() ); 
		}
	  }
	});
	_panel.add( Box.createVerticalGlue() );
	_panel.add(aPanel);
	return f;
 }

 public Field addField( Attributes atts ) throws XMLException  {
	 String id=null, type=null, name=null, req=null, test=null,  help=null;
	 Object value = null;
	 System.out.print("\n  Parsing field spec: " );
	 for (int i = 0; i < atts.getLength(); i++) {
	   String att_name = atts.getQName(i);
	   String att_value = atts.getValue(i);
	   System.out.print("\t ( " + att_name + ": " + att_value + " ) " );
	   if( att_name.equals("id") ) { id = att_value; }
	   else if( att_name.equals("type") ) { type = att_value; }
	   else if( att_name.equals("name") ) { name = att_value; }
	   else if( att_name.equals("help") ) { help = att_value; }
	   else if( att_name.equals("value") ) { value = att_value; }
	   else if( att_name.equals("required") ) { req = att_value; }
	 }
	  Field f = addField( id, type, name,  help, req.equals("true"), value, test );
	  if( f == null ) {
		throw new XMLException("Unidentified field, type: " + type + ", id: " + id + ", name: " + name );
	  }
	  return f;
 }
 
 public Field addField( String id, String type, String name, String help,  boolean required, Object value, String test ) throws XMLException {
   System.out.println("Adding " + type + " field: " + id + " ( " + name + " ) -> " + value );
   if( type.equalsIgnoreCase("doc")  ) {
	  return addDocField( name, (String)value );
   } else if( type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("bool") ) {
	  return addBooleanField( id, name, help, required, (String)value );
   } else if( type.equalsIgnoreCase("int") || type.equalsIgnoreCase("integer") ) {
	  return addIntField( id, name,  help, required, (String)value );
   } else if( type.equalsIgnoreCase("float") ) {
	  return addFloatField( id, name,  help, required, (String)value );
   } else if( type.equalsIgnoreCase("string") ) {
	  return addStringField( id, name, help,  required, (String)value );
   } else if( type.equalsIgnoreCase("combo") ) {
	  return addComboField( id, name, (String[])value, help, required, null );
   } else if( type.equalsIgnoreCase("dir") || type.equalsIgnoreCase("directory")  ) {
	  return addDirectoryField( id, name,  help, required, (String)value, test );
   } else if( type.equalsIgnoreCase("file")  ) {
	  return addFileField( id, name,  help, required, (String)value, test );
   } 
   return null;
 }

 public void collectFieldData() throws XMLException {
   boolean enabled = isEnabled();
   System.out.println( "Collecting field data, enabled: " + enabled );
   for( int i=0; i<_fieldAdapters.size(); i++ ) {
	 FieldAdapter f = (FieldAdapter) _fieldAdapters.get(i);
	 f.execute( enabled );
	 System.out.println("Got field: " + f._field.ID() + " -> " + f._field.getProperty("value") );
   }
 }

 FieldAdapter getFieldAdapter( Field field ) throws XMLException {
   for( int i=0; i<_fieldAdapters.size(); i++ ) {
	 FieldAdapter f = (FieldAdapter) _fieldAdapters.get(i);
	 if( f._field.ID().equals(field.ID()) ) {
	   return f;
	 }
   }
   return null;
 }
  
  class UpdateDirectoryAction extends Object implements ActionListener {
	JTextField _value;
	UpdateDirectoryAction( JTextField value ) { _value = value; }
	public void actionPerformed(ActionEvent e) {
	   String dir = e.getActionCommand();
	   _value.setText( dir );
	   System.out.println("Got directory: " + dir );
	 }
  } 
 
  class BrowseAction extends Object implements ActionListener {
	JTextField _value;
	BrowseAction( JTextField value ) { _value = value; }
	public void actionPerformed(ActionEvent e) {
	  DirectoryChooser dc = DirectoryChooser.create( _value.getText() );
	  dc.addActionListener( new UpdateDirectoryAction(_value) );
	  dc.show(true);
	}
  } 

  class BrowseFileAction extends Object implements ActionListener {
	JTextField _value;
	String _file;
	BrowseFileAction( JTextField value, String filename ) { _value = value; _file = filename;  }
	public void actionPerformed(ActionEvent e) {
	  JFileChooser chooser = new JFileChooser( _value.getText() );
	  int returnVal = chooser.showDialog( ((Wizard)getParent()).getDialog(), "select" );
	  if(returnVal == JFileChooser.APPROVE_OPTION) {
		 String path = chooser.getSelectedFile().getAbsolutePath();
		 _value.setText( path );
		 System.out.println("Got file: " + path );
	  }
	}
  } 
 
  public String getElementType( int format ) { return "panel"; }

  public void resolve() { 
	String enabler = (String) getProperty("enabler");
	if( enabler != null ) {
	  Field ec = (Field) getData(enabler);
	  if( ec == null ) {
		System.out.println(" Can't find enabler: " + enabler + " for Panel " + ID() );
	  } else {
		setTaskData("enabler",ec,true);
	  }
	}
//	System.out.println("Setting enabler:  ( " + ID() + " ): " + ( (enabler==null) ? "null" : enabler ) );
	super.resolve(); 
  } 
  
}

