package miiee.xml;

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.border.*;
import javax.swing.*;
import javax.swing.event.*;
import miiee.wizard.DirectoryChooser;

public class ImageChooser {

  JList _list;
  ImageFileModel _listModel;
  JDialog _dialog;
  
  public ImageChooser( File path ) {
	_listModel = new ImageFileModel(path);
	_list = new JList( _listModel );
	_list.setCellRenderer( new ImageCellRenderer() ) ;
  }
    
  public void setCurrentDirectory(File dir) { 
	_listModel.setCurrentDirectory(dir);
	_list.repaint(); 
  }
  
  public void close() {
	if( _dialog != null ) {	
	  _dialog.setVisible(false);
	  _dialog.dispose();
	  _dialog = null;
	}
  }

  class CloseAction extends Object implements ActionListener  {
	public void actionPerformed(ActionEvent e) {
	  close();
	}
  }

  class ChangeDirectoryAction extends Object implements ActionListener  {
	public void actionPerformed(ActionEvent e) {
	  DirectoryChooser dc = DirectoryChooser.create( _listModel.getCurrentDirectory().getPath() );
	  dc.addActionListener( new UpdateDirectoryAction() );
	  dc.show(true);
	}
  }

  class UpdateDirectoryAction extends Object implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	   String dir = e.getActionCommand();
	   _listModel.setCurrentDirectory( new File(dir) );
	   _list.repaint();
	   System.out.println("Set directory: " + dir );
	 }
  } 
  
  void destroy() {;}
  
  JDialog getDialog() { return _dialog; }
  
   public void show( boolean modal ) {
	close(); 
	JFrame frame = new JFrame();
			
	_dialog = new JDialog( frame, "Image Chooser", modal );
//	_dialog.addKeyListener(this);

	WindowListener l = new WindowAdapter() {
		public void windowClosing(WindowEvent e) { destroy(); }
	};
	_dialog.addWindowListener( l );

  	JScrollPane scrollpane = new JScrollPane( _list );
	scrollpane.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	scrollpane.setBorder( BorderFactory.createLoweredBevelBorder() );

	_dialog.getContentPane().setLayout(new BorderLayout());
	_dialog.getContentPane().add( "Center", scrollpane);
	_dialog.setSize( 600, 400 );

	JPanel button_panel  = new JPanel( new FlowLayout() );
	JButton  dirButton = new JButton("Change Directory");
	dirButton.addActionListener( new ChangeDirectoryAction() );
	button_panel.add(dirButton);
	JButton  cancelButton = new JButton("Close");
	cancelButton.addActionListener( new CloseAction() );
	button_panel.add(cancelButton);
	_dialog.getContentPane().add( "North", button_panel);
	
    Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (screenDim.width - _dialog.getSize().width) / 2;
    int y = (screenDim.height - _dialog.getSize().height) / 2;
    _dialog.setLocation(x, y);	
    _dialog.setVisible(true);
  }
   
  public static void main(String args[]) {
	String dir = ( args.length == 0 ) ? System.getProperty("user.dir") : args[0];	
	ImageChooser table = new  ImageChooser( new File(dir) );
	table.show(true);
	System.exit(0);
  }
}

class ImageCellRenderer extends JLabel implements ListCellRenderer, Serializable {

    protected static Border noFocusBorder;

    public ImageCellRenderer() {
	  super();
	  noFocusBorder = new EmptyBorder(8, 8, 8, 8);
	  setOpaque(true);
	  setBorder(noFocusBorder);
    }

    public Component getListCellRendererComponent( JList list, Object value,  int index,   boolean isSelected, boolean cellHasFocus) {

	  File f = (File) value;
	  ImageIcon icon = new ImageIcon( f.getPath(), f.getName() );

	  if (isSelected) {
		  setBackground(list.getSelectionBackground());
		  setForeground(list.getSelectionForeground());
	  }
	  else {
		  setBackground(list.getBackground());
		  setForeground(list.getForeground());
	  }

	  setIcon( icon );
	  setText( f.getName() );

	  setEnabled(list.isEnabled());
	  setFont(list.getFont());
	  
	  setBorder((cellHasFocus) ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
	  int iwidth = icon.getIconWidth();
	  int ispacing = ((iwidth/100)+1)*100;
	  int tgap = (ispacing-iwidth)+10;
	  setIconTextGap(tgap);

	  return this;
    }

    public static class UIResource extends DefaultListCellRenderer implements javax.swing.plaf.UIResource {;}

}

/**
 * Models what goes on in a directory of typed files. Has a notion of
 * its current directory, and provides a notion of file typing.
 * 
 * Can be told to "go up". Fakes a meta level above the root file
 * system(s) if it thinks this is a Windows box.
 * 
 * @version 1.15 02/05/98
 * @author Ray Ryan
 */
 
 class ImageFileModel implements ListModel {

    /**
     * Cache of the Files of the local directory
     */
    transient protected Vector _currentDirectories = new Vector();

    /**
     * True if the <code>_currentDirectories</code> cache is trustworthy,
     * false if it should be refreshed
     */
    transient protected boolean _currentDirectoriesFresh = false;

    /**
     * Where this chooser is. Provides context for unqualified calls to
     * <code>getFile</code> and  <code>getFiles</code>, or calls
     * with relative paths.
     */
    protected File curDir;
    
    /**
     * True if we have executed our hack to see if this is a
     * Windows file system
     */
    protected boolean haveCheckedWindows = false;

    /**
     * Undefined if haveCheckedWindows is false. Otherwise, true if we
     * think this is a windows file system.
     */
    protected boolean isWindows;

    protected EventListenerList listenerList = new EventListenerList();

    protected PropertyChangeSupport changeSupport;

    /**
     * Returns a DirectoryModel with current directory
     * <code>path</code>
     */
    public ImageFileModel( File path ) {
	  setCurrentDirectory(path);
    }
    
    public File getCurrentDirectory() {
	return curDir;
    }
	
	public String setParentDirectory() {
	  String s = "/";
	  try {
		s = curDir.getParent();
		setCurrentDirectory( new File( s ) );
		
	  } catch( NullPointerException err ) { ; }
	  
	  return s;
	}
	
    /**
     * Change the directory that is the location of this model.
     * Null means go to the user's home directory
     * Emit a ChangeEvent if directory is actually changed.
     */
    public void setCurrentDirectory(File dir) {
	  if (dir == null) dir = new File(System.getProperty("user.home"));

	  /**
	   * Note that we compare literal paths, not canonical
	   * paths. If they want the chooser to represent the
	   * files at the end of a different route to the same
	   * place, that's perfectly legitimate. See NextStep
	   * for e.g.
	   */
	  if (curDir == null || !curDir.equals(dir)) {
		  invalidateCache();
		  File oldDir = curDir;
		  curDir = dir;
		  firePropertyChange("currentDirectory", oldDir, dir);
		  fireContentsChanged();
	  }
    }
    
    // PENDING Perhaps there should be a public version which both
    // invalidates and throws a currentDirectory property change event?
    /**
     * Invalidates the cached copy of the current directory
     */
    protected void invalidateCache() {
	  _currentDirectoriesFresh = false;
    }

    /**
     * Given a path and a file name, return a File
     */
    public File getFile(String path, String name) {
	  File f = new File(path, name);
	  return f;
    }

    /**
     * Given a path, return a File
     */
    public File getFile(String path) {
	  File f = new File(path);
	  return f;
    }

    /**
     * Convenience, same as 
     * <code>getFilesForDirectory(getCurrentDirectory())</code>
     */
    public Vector getFiles() {
	  return getFilesForDirectory(getCurrentDirectory());
    }

    /**
     * Return a Vector of the Files (directories) in the given directory. The Vector
     * may be empty.
     *
     * The objects in the Vector are of instances of File
     */
    public Vector getFilesForDirectory(File dir) {
	  boolean useCache = dir.equals(getCurrentDirectory());

	  if(useCache && _currentDirectoriesFresh) {
		  return _currentDirectories;
	  } else {
		  Vector resultSet;
		  if (useCache) {
		  resultSet = _currentDirectories;
		  resultSet.removeAllElements();
		  } else {
		  resultSet =  new Vector();
		  }

		  String[] names = dir.list();

		  int nameCount = names == null ? 0 : names.length;	 
		   		  
		  for (int i = 0; i < nameCount; i++) {
			String name = names[i].toLowerCase();
			if( name.endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".xpm") ) {
			  File f;
			  if (dir instanceof WindowsRootDir) {
				  f = getFile(names[i]);
			  } else {
				  f = getFile(dir.getPath(), names[i]);
			  }

			  boolean isFile = f.isFile();
			  if ( isFile ) {
				  resultSet.addElement(f);
			  }
			}
		  }	  
		  System.out.println("Getting files for " + dir + ", file count = " + nameCount + ", image count = " + resultSet.size()  );

		  // The fake windows root dir will get mangled by sorting
		  if (!(dir instanceof ImageFileModel.WindowsRootDir)) {
			sort(resultSet);
		  }

		  if (useCache) {
			_currentDirectoriesFresh = true;
		  }

		  return resultSet;
	  }
    }

    public boolean canGoUp() {
	  File dir = getCurrentDirectory();
	  return dir.getParent() != null || !isWindowsFileSystem();
    }
    
    public void goUp() {
	  File curDir = getCurrentDirectory();

	  String parentPath = curDir.getParent();
	  File parent = parentPath == null ? null : new File(parentPath);

	  // If I'm trying to go up from a root directory and I think
	  // I'm on a Windows box, go the magic Windows meta directory.

	  if (parent != null) {
		  setCurrentDirectory(parent);
	  }
	  /*
		else if (isWindowsFileSystem()) {
		setCurrentDirectory(getSharedWindowsRootDir());
		} 
		*/
    }

    //
    // Property Change Listeners
    //

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (changeSupport != null) {
			changeSupport.firePropertyChange(propertyName, oldValue, newValue);
		}
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (changeSupport == null) {
            changeSupport = new java.beans.PropertyChangeSupport(this);
        }
        changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (changeSupport != null) {
			changeSupport.removePropertyChangeListener(listener);
		}
    }
    //
    // Windows Metaroot Fakery
    //

    protected boolean isWindowsFileSystem() {
	if (!haveCheckedWindows) {
	    isWindows = false;

	    if (File.pathSeparator.equals(";")
		&& File.separator.equals("\\")) {

		String p = getCurrentDirectory().getAbsolutePath();
		if (p.length() >= 3) {
		    char zero = p.charAt(0);
		    char one = p.charAt(1);
		    char two = p.charAt(2);

		    isWindows = ((one == ':')
				 && (two == '\\')
				 && ((zero >= 'A') && (zero <= 'Z')
				     || (zero >= 'a' && zero <= 'z')));
		}
	    }

	    haveCheckedWindows = true;
	}

	return isWindows;
    }
    
    /*    private static Object sharedWindowsRootDirKey = DirectoryModel.class;
    public static WindowsRootDir getSharedWindowsRootDir() {
        WindowsRootDir rootDir = (WindowsRootDir)
            SwingUtilities.appContextGet(sharedWindowsRootDirKey);
	if (rootDir == null) {
	    rootDir = new WindowsRootDir();
            SwingUtilities.appContextPut(sharedWindowsRootDirKey, rootDir);
	}
	return rootDir;
    }
    */
    /**
     * Fakes a meta level above all file systems on a suspected
     * Windows box. Its name is derived from the host name. Its
     * children are A:  and the C: through Z: devices that appear to
     * be mounted.
     * 
     * Really, "Windows-mode" should make this the desktop, where "My
     * Computer" and such appear, and similar behavior is needed for
     * Macintosh. But I don't think that's possible with Java's current
     * system and file system blindness
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    static public class WindowsRootDir extends File {
	protected WindowsRootDir() { super(""); }

	public boolean canRead() { return true; }
	public boolean canWrite() { return false; }
	public boolean delete() { return false; }

	public boolean equals(Object obj) { return obj == this; }
	/**
	 * Returns the hashCode for the object.  This must be defined
	 * here to ensure 100% pure.
	 *
	 * @return the hashCode for the object
	 */
	public int hashCode() { 
	    return super.hashCode();
	}

	public boolean exists() { return true; }

	public String getAbsolutePath() { return getName(); }
	public String getCanonicalPath() throws IOException
	    { throw new IOException(); }
	 
	public String getName() {
	    String hostName;

	    try {
		char name[];
		name = InetAddress.getLocalHost().getHostName().
		    toCharArray();
		name[0] = Character.toUpperCase(name[0]);
		hostName = new String(name);
	    } catch (UnknownHostException e) {
		// PENDING I18N
		hostName = "My Computer";
	    }

	    return hostName;
	}

	public String getParent() { return null; }
	public String getPath() { return getName(); }

	// public int hashCode() { return 0; }

	public boolean isAbsolute() { return true; }

	public boolean isDirectory() { return true; }
	public boolean isFile() { return false; }

	public long lastModified() { return 0; }
	public long length() { return 0; }

	public String[] list() { return list(null); }

	public String[] list(FilenameFilter filter) {
	    boolean windows = true;
            Vector deviceVector = new Vector(); 

            for (char c = 'C'; c <= 'Z'; c++) { 
                char device[] = {c, ':', '\\'}; 
                String devName = new String(device); 
                File devFile = new File(devName); 
                if (devFile != null && devFile.exists()) { 
                    deviceVector.addElement(devName); 
                }
            }

	    // Fake the A: floppy drive. There is no way to test if one
	    // exists or not, and we want to see it listed whether
	    // or not a floppy is "mounted". Don't even talk to me
	    // about a B: drive. Welcome to the 1990s.

	    int count = deviceVector.size() + 1;	// +1 for A:
	    String[] devices = new String[count];
	    devices[0] = "A:\\";

	    if (count > 1) {
		for (int i = 1; i < count; i++) {
		    devices[i] = (String)deviceVector.elementAt(i-1);
		}
	    }
	    return devices;
	}		

	public boolean mkdir() { return false; }
	public boolean mkdirs() { return false; }
	public boolean renameTo() { return false; }
    } // End inner class RootFile

    //
    // Sorting
    //

    // PENDING(jeff) Hopefully we can dispense with this once we
    // go to 1.2

    protected void sort(Vector v){
	  quickSort(v, 0, v.size()-1);
    }

    protected boolean lt(File a, File b) {
	  return a.getName().toLowerCase().compareTo(b.getName().toLowerCase()) < 0;
    }
    
    private void swap(Vector a, int i, int j) {
	Object T = a.elementAt(i); 
	a.setElementAt(a.elementAt(j), i);
	a.setElementAt(T, j);
    }

    // Liberated from the 1.1 SortDemo
    /** This is a generic version of C.A.R Hoare's Quick Sort 
    * algorithm.  This will handle arrays that are already
    * sorted, and arrays with duplicate keys.<BR>
    *
    * If you think of a one dimensional array as going from
    * the lowest index on the left to the highest index on the right
    * then the parameters to this function are lowest index or
    * left and highest index or right.  The first time you call
    * this function it will be with the parameters 0, a.length - 1.
    *
    * @param a       an integer array
    * @param lo0     left boundary of array partition
    * @param hi0     right boundary of array partition
    */
    protected void quickSort(Vector v, int lo0, int hi0) {
	int lo = lo0;
	int hi = hi0;
	File mid;

	if ( hi0 > lo0)
	{

	    /* Arbitrarily establishing partition element as the midpoint of
	     * the array.
	     */
	    mid = (File) v.elementAt(( lo0 + hi0 ) / 2);

	    // loop through the array until indices cross
	    while( lo <= hi )
	    {
		/* find the first element that is greater than or equal to 
		 * the partition element starting from the left Index.
		 */
		// Nasty to have to cast here. Would it be quicker
		// to copy the vectors into arrays and sort the arrays?
		while( ( lo < hi0 ) && lt( (File)v.elementAt(lo), mid ) )
		    ++lo;

		    /* find an element that is smaller than or equal to 
		     * the partition element starting from the right Index.
		     */
		while( ( hi > lo0 ) && lt( mid, (File)v.elementAt(hi) ) )
		    --hi;

		    // if the indexes have not crossed, swap
		if( lo <= hi ) 
		{
		    swap(v, lo, hi);
		    ++lo;
		    --hi;
		}
	    }

	    /* If the right index has not reached the left side of array
		 * must now sort the left partition.
		 */
	    if( lo0 < hi )
		quickSort( v, lo0, hi );

		/* If the left index has not reached the right side of array
		 * must now sort the right partition.
		 */
	    if( lo < hi0 )
		quickSort( v, lo, hi0 );

	}
    }


    //
    // ListModel operations
    //

    public int getSize() {
	Vector files = getFiles();
	return files.size();
    }

    public Object getElementAt(int index) {
	  return (File) getFiles().elementAt(index);
    }

    public File getFileAt(int index) {
	  return (File) getFiles().elementAt(index);
    }

    public void addListDataListener(ListDataListener l) {
	listenerList.add(ListDataListener.class, l);
    }

    public void removeListDataListener(ListDataListener l) {
	listenerList.remove(ListDataListener.class, l);
    }

    /*
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance 
     * is lazily created using the parameters passed into 
     * the fire method.
     * @see EventListenerList
     */
    protected void fireContentsChanged() {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	ListDataEvent e = null;
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i]==ListDataListener.class) {
		// Lazily create the event:
		if (e == null) {
		    e = new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED,
					  0, getSize()-1);
		}
		((ListDataListener)listeners[i+1]).contentsChanged(e);
	    }
	}
    }

}
