package miiee.xml;

import org.xml.sax.*;
import java.io.*;
import java.security.*;
import java.util.Stack;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.help.*;
import javax.swing.event.*;
import javax.swing.*;
import javax.xml.parsers.*;
import javax.swing.tree.*;
import java.net.*;
import miiee.util.*;
import org.apache.crimson.parser.Resolver;

public class LocalResolver extends Resolver {

	static final boolean _debug = false;
	
    public InputStream loadResourceAsStream( String resource_name ) {
       ClassLoader cl = this.getClass().getClassLoader();
       return (cl == null) ? null : cl.getResourceAsStream(resource_name);
    }

    public URL loadResource( String resource_name ) {
       ClassLoader cl = this.getClass().getClassLoader();
       return (cl == null) ? null : cl.getResource(resource_name);
    }

    public HelpBroker loadHelpBroker( String helpsetName ) {
	  if( _debug ) { SimIO.print("Creating help broker: " + helpsetName ); }
	  ClassLoader cl = this.getClass().getClassLoader();
	  HelpBroker hb = null;
	  if( cl == null ) { return null; }
	  String resource = "workspace/help/" + helpsetName + ".hs"; 
	  URL url = cl.getResource(resource);
	  if(  url == null ) {
		String path = System.getProperty("LIBDIR") + "/docs";
		String helpSetPath = path + "/help/" + helpsetName + ".hs";
		url = HelpSet.findHelpSet(cl, helpSetPath );
	  }
	  if( url != null ) {
		try {
		  HelpSet hs = new HelpSet(cl, url);
		  hb = hs.createHelpBroker();
		} catch ( javax.help.HelpSetException err ) {
		  SimIO.print("Error creating help broker: " + err );
		}
	  }
	  return hb;
	}

    public InputSource 	resolveEntity (String name, String uri)  throws IOException, SAXException  {
	  if( name != null ) {
		 int li0 = name.lastIndexOf(' ') + 1;
		 int li1 = name.indexOf('/',li0);
		 String dtd_name = name.substring( li0, li1 );
		 String resource_name = "dtd/" + dtd_name + ".dtd";
		 if( _debug ) { SimIO.print( "Resolving External Entity, name: " + name + ", uri: " + uri + ", resource: " + resource_name + "\n" ); }
		 InputStream ris = loadResourceAsStream(resource_name);
		 if( ris != null ) {
			return createInputSource("text/xml",ris,true,"file");
		 }
	   }
	   int home_index = uri.lastIndexOf("~");
	   if( home_index != -1 ) {
	  	String relative_uri = uri.substring(home_index+1);
		uri = SimIO.getWorkbenchDirectory() + relative_uri;
		if( uri.startsWith("/") ) { uri = "file:" + uri; }
	   }
	   if( _debug ) {  SimIO.print( "Debug>>> index: " + home_index + ", uri: " + uri + ", Codebase: " +  SimIO.getWorkbenchDirectory() ); }
	   InputSource is = resolveApplicationID ( name );
	   return (is == null ) ? super.resolveEntity ( name, uri ) : is;
	}

    static public String normalizePath( String path ) {
      if( path == null ) return null;
      String platform = System.getProperty("platform");
      if( _debug ) {  SimIO.print( "Debug>>> platform: " + platform ); }
      if( ( platform != null ) && platform.equals("CYGWIN") ) {
		if( path.startsWith("file:") ) {
		  path = path.substring(5);
		}
        char fc = path.charAt(1);
        if ( fc != ':' ) {
          path = SimIO.getWindowsPath(path);
        } else {
		  path.replace('/','\\');
        }
      }
      return path;
    }

    public InputSource 	resolveApplicationID ( String name )  throws IOException, SAXException  {
	  if( name == null ) return null;
	  if( SimIO.getApplet() != null ) return null;
	  String dtd_name = null;
	  StringTokenizer st = new StringTokenizer(name,"//");
	  String s0 = st.nextToken();
	  String s1 = st.nextToken();
	  if( s1.equals( SimIO.getApplicationID() ) ) {
		String s2 = st.nextToken();
		if( s2.startsWith("dtd") ) {
		  int isp = s2.lastIndexOf(" ",3);
		  dtd_name = s2.substring(isp+1);
		}
	  }
	  if( dtd_name != null ) {
		String root_path = null;
		try {
		  root_path = System.getProperty("LIBDIR");
		  if( root_path != null ) { root_path = root_path + "/sysdef/"; }
		} catch ( java.security.AccessControlException err ) {;}
		if( root_path == null ) {
		  try {
			root_path = System.getProperty("user.home");
			if( root_path != null ) { root_path = root_path + "/.sme/"; }
		  } catch ( java.security.AccessControlException err ) {;}
		}
		if( root_path != null ) {
		  String dtd_path = root_path + "/dtd/" + dtd_name + ".dtd";
                  dtd_path = LocalResolver.normalizePath(dtd_path);
		  File file = new File(dtd_path);
		  return createInputSource(file);
		}
	  }
	  return null;
    }


}
