package miiee.xml;

import java.lang.ClassNotFoundException;
import java.lang.IllegalAccessException;
import java.lang.InstantiationException;
import java.lang.SecurityException;
import java.lang.ClassCastException;

import org.xml.sax.Parser;


/**
  * Java-specific class for dynamically loading SAX parsers.
  * Copied from IBM xml4j Project.
  *
  * <p>This class is not part of the platform-independent definition
  * of SAX; it is an additional convenience class designed
  * specifically for Java XML application writers.  SAX applications
  * can use the static methods in this class to allocate a SAX parser
  * dynamically at run-time based either on the value of the
  * `org.xml.sax.parser' system property or on a string containing the class
  * name.</p>
  *
  * <p>Note that the application still requires an XML parser that
  * implements SAX.</p>
  *
  * @author David Megginson (ak117@freenet.carleton.ca)
  * @version Revision: 35 1.3 src/org/xml/sax/helpers/ParserFactory.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_9 
  * @see org.xml.sax.Parser
  * @see java.lang.Class
  */
public class ParserFactory {

  static public void setParserClassName( String parser_class ) { System.setProperty( "org.xml.sax.parser", parser_class ); }
  static public String getParserClassName() { 
	try {
	  return System.getProperty( "org.xml.sax.parser", "com.sun.xml.parser.ValidatingParser" ); 
	} catch ( java.security.AccessControlException err ) {
	  return "com.sun.xml.parser.ValidatingParser";
//	  return "com.ibm.xml.parser.SAXDriver";
	}
  }
  

  /**
    * Private null constructor.
  private ParserFactor ()
  {
  }


  /**
    * Create a new SAX parser using the `org.xml.sax.parser' system property.
    *
    * <p>The named class must exist and must implement the
    * org.xml.sax.Parser interface.</p>
    *
    * @exception java.lang.NullPointerException There is no value
    *            for the `org.xml.sax.parser' system property.
    * @exception java.lang.ClassNotFoundException The SAX parser
    *            class was not found (check your CLASSPATH).
    * @exception IllegalAccessException The SAX parser class was
    *            found, but you do not have permission to load
    *            it.
    * @exception InstantiationException The SAX parser class was
    *            found but could not be instantiated.
    * @exception java.lang.ClassCastException The SAX parser class
    *            was found and instantiated, but does not implement
    *            org.xml.sax.Parser.
    * @see #makeParser(java.lang.String)
    * @see org.xml.sax.Parser
    */
  public static Parser makeParser ()
    throws ClassNotFoundException,
           IllegalAccessException, 
           InstantiationException,
           NullPointerException,
           ClassCastException
  {
      return makeParser(null);
  }


  /**
    * Create a new SAX parser object using the class name provided.
    *
    * <p>The named class must exist and must implement the
    * org.xml.sax.Parser interface.</p>
    *
    * @param className A string containing the name of the
    *                  SAX parser class.
    * @exception java.lang.ClassNotFoundException The SAX parser
    *            class was not found (check your CLASSPATH).
    * @exception IllegalAccessException The SAX parser class was
    *            found, but you do not have permission to load
    *            it.
    * @exception InstantiationException The SAX parser class was
    *            found but could not be instantiated.
    * @exception java.lang.ClassCastException The SAX parser class
    *            was found and instantiated, but does not implement
    *            org.xml.sax.Parser.
    * @see #makeParser()
    * @see org.xml.sax.Parser
    */
  public static Parser makeParser (String className)
    throws ClassNotFoundException,
           IllegalAccessException, 
           InstantiationException,
           ClassCastException
  {
    if( className == null ) { className = getParserClassName();  }
    if (className == null) {
      throw new NullPointerException("No value for sax.parser property");
    } else {
	  Class c = Class.forName(className);
	  System.out.println( "Using parser " + className + " -> " + c ); 
      return (Parser)(c.newInstance());
    }
  }

}

